/**********************************************************************
 *                                                                    *
 *       (c) Copyright 2003                                           *
 *       All rights reserved                                          *
 *       Programs written by Jianghui Liu (NJIT)                      *
 *                                                                    *
 *       Permission to use, copy, modify, and distribute this         *
 *       software and its documentation for any purpose and without   *
 *       fee is hereby granted, provided that this copyright          *
 *       notice appears in all copies.   Programmer(s) makes no       *
 *       representations about the suitability of this                *
 *       software for any purpose.  It is provided "as is" without    *
 *       express or implied warranty.                                 *
 *                                                                    *
 **********************************************************************/
package RNA;
public class Statistic
{
    public static double getMean(double[] data)
    {
        int length = data.length;
        double sum = 0;
        for(int i=0; i<length; i++)
            sum += data[i];

        return (sum/length);
    }

    public static double getMean(int[] data)
    {
        int length = data.length;
        double sum = 0;
        for(int i=0; i<length; i++)
            sum += data[i];

        return (sum/length);
    }


    public static double getVar(int[] data)
    {
        double mean = getMean(data);

        int length = data.length;
        double sum = 0;
        for(int i=0; i<length; i++)
            sum += (data[i] - mean) * (data[i] - mean);

        return (sum/(length-1));
    }

    public static double getVar(double[] data)
    {
        double mean = getMean(data);

        int length = data.length;
        double sum = 0;
        for(int i=0; i<length; i++)
            sum += (data[i] - mean) * (data[i] - mean);

        return (sum/(length-1));
    }

    public static double getSTD(int[] data)
    {
        return Math.sqrt(getVar(data));
    }

    public static double getSTD(double[] data)
    {
        return Math.sqrt(getVar(data));
    }

    public static int getMax(int[] data)
    {
        int max = data[0];
        for(int i=0; i<data.length; i++)
        {
            if( max < data[i])
                max = data[i];
        }
        return max;
    }

    public static double getMax(double[] data)
    {
        double max = data[0];
        for(int i=0; i<data.length; i++)
        {
            if( max < data[i])
                max = data[i];
        }
        return max;
    }

    public static int getIndexOfMax(double[] data)
    {
        int index = 0;
        for(int i=0; i<data.length; i++)
        {
            if( data[index] < data[i])
                index = i;
        }
        return index;
    }

    public static int getMin(int[] data)
    {
        int min = data[0];
        for(int i=0; i<data.length; i++)
        {
            if( min > data[i])
                min = data[i];
        }
        return min;
    }

    public static double getMin(double[] data)
    {
        double min = data[0];
        for(int i=0; i<data.length; i++)
        {
            if( min > data[i])
                min = data[i];
        }
        return min;
    }
}
