/*********************************************************
*	Author: Mugdha Khaladkar
*	Provided a wrapper function for invoking
*	the different function of RSmatch
*	and replaces the perl script for Windows
*	platform.
*********************************************************/

import java.io.*;
import java.util.*;
import java.text.NumberFormat;

public class RSmatch{

	public static void main(String[] args) throws IOException{

		if( args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help"))
		{
			System.out.println("Usage: ");
			System.out.println(" 	java RSmatch [options]");
			System.out.println("General options:");
			System.out.println("-p <pmatch|mmatch|imatch>");
			System.out.println("	choose a program from:");
			System.out.println("	pmatch: pair-wise comparison and database search");
			System.out.println("	mmatch: multiple RNA structure alignment with an option for finding common structure");
			System.out.println("	imatch: iterative database search");
			System.out.println("-d <Database>:	Secondary RNA structure database");
			System.out.println("-g <Gap penalty> (Default): -6");
			System.out.println("-o <Output>		File to receive output (Default): result.txt");

			System.out.println("Options for 'pmatch', 'imatch':");
			System.out.println("-n <tonN>		output top <topN> hits Default:10");
			System.out.println("-q <Query>		query secondary structure");

			System.out.println("Options for 'pmatch':");
			System.out.println("-s <score matrix>	File containing position independent score matrices");
			System.out.println("			default is 'scoreMat.structure'");
			System.out.println("-G <alignment type");
			System.out.println("	T:	global alignment");
			System.out.println("	F:	local alignment");
			System.out.println("	default: F");
			System.out.println("-m <query type>");
		    	System.out.println("Query type:");
			System.out.println("    0: real structure without IUB code");
		        System.out.println("    1: pattern structure containing IUB code");
			System.out.println("    default: 0");

			System.out.println("Options for 'imatch':");
			System.out.println("-R <repeat>         number of iterations Default:5");

			System.exit(0);

		}
		String job, structData=null, structQuery=null, ScoreMat="scoreMat.structure", Output, global;
	       	Output = "result.txt";
	 	job = null;
		global = "F";
		int Mode=0,Repeat=5,topN=10;
		double Penalty = -6.0;
		boolean setPenalty= false;
		for(int i = 0; i<args.length; i++){
		        if(args[i].equals("-p")){
				job = new String(args[i+1]);
				i++;
			}
			else if(args[i].equals("-d")){
				structData = new String(args[i+1]);
				i++;
			}
			else if(args[i].equals("-q")){
				structQuery = new String(args[i+1]);
				i++;
			}
			else if(args[i].equals("-s")){
				ScoreMat = new String(args[i+1]);
				i++;
			}
			else if(args[i].equals("-g")){
				setPenalty = true;
				Penalty = Double.parseDouble(args[i+1]);
				i++;
			}
			else if( args[i].equals("-m")) {
				Mode = Integer.parseInt(args[i+1]);
				i++;
			}
			else if(args[i].equals("-R")){
				Repeat = Integer.parseInt(args[i+1]);
				i++;
			}
			else if(args[i].equals("-o")){
				Output = new String(args[i+1]);
				i++;
			}
			else if( args[i].equals("-n")) {
				topN = Integer.parseInt(args[i+1]);
				i++;
			}
			else if(args[i].equals("-G")){
				global = new String(args[i+1]);
				i++;
			}
		}
		if(job.equals("pmatch")){
			job = "dsearch";
		}
		else if(job.equals("mmatch")){
			job = "mrsa";
		}
		else if(job.equals("imatch")){
			job = "isearch";
		}
		if(structData == null){
			System.out.println("ERROR! No database specified");
			System.exit(0);
		}
		if(job.equals("dsearch")){

			if((Mode !=0)&&(Mode != 1)){
			System.out.println("Fatal Error! Illegal argument to '-m', must be '0' or '1' !");
			System.exit(0);
			}
		}
		if(job.equals("dsearch") || job.equals("isearch")){

			if(structQuery == null){

			System.out.println("ERROR! No query specified");
			System.exit(0);

			}
		}
		if(job.equals("isearch")){

			if(Repeat<2){
			System.out.println("ERROR! For job type 'isearch', the # of iterations must be greater than 1!\n");
			System.exit(0);
			}
		}
		if(Penalty>=0){

			System.out.println("Error! Gap penalty MUST be a NEGATIVE value !!!");
			System.exit(0);
		}

	//system("clear");
	System.out.println( "#----- your settings ----#");
	System.out.println("Your job type: " + job);
	if( job.equals("dsearch") && global.equals('T') ){
		System.out.println("Alignment type: Global");
	} else { System.out.println("Alignment type: Local"); }
        System.out.println("Database: "+ structData + "(Secondary structure)");
	if(job.equals("dsearch") || job.equals("isearch")){
		 System.out.println("Return # of top hits: "+ topN);
		 System.out.println("Query: "+ structQuery);
		 if( job.equals("dsearch") && Mode == 1 ) {
		 System.out.println("(secondary structure w/ IUB code)");
	         } else {
	         System.out.println("(secondary structure w/o IUB code)");
		 }

	}
  	if(job.equals("isearch")){
		 System.out.println("# of iterations: "+ Repeat);

	}

	if(job.equals("dsearch")){
		 System.out.println("Score matrices: "+ ScoreMat);
	}

	System.out.println("Gap penalty: "+ Penalty);
        System.out.println("Output: "+ Output);



	System.out.println("==== Job specific settings ====");

	//Calculate start time
 	Date starttime = new Date();
	if( job.equals("dsearch") || job.equals("isearch")){

	if( job.equals("dsearch")){

		String RNAmatcher = "java RNA\RNAmatcher -m "+ Mode+ " -d " + structData+ " -q " + structQuery ;
		RNAmatcher = RNAmatcher + " -s " + ScoreMat + " -g " + Penalty +  " -o " + Output + " -n " + topN;
		if( global.equals('T') ){ RNAmatcher = RNAmatcher + " -b"; }
		System.out.println("\nExecute: regular database search\n");
		//System.out.println(RNAmatcher);
		try{
		Runtime rt= Runtime.getRuntime();
		Process proc = rt.exec(RNAmatcher);
		InputStream inputstream = proc.getInputStream();
		InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
		BufferedReader bufferedreader = new BufferedReader(inputstreamreader);

		String line;
		while((line = bufferedreader.readLine()) != null){
			System.out.println(line);
		}
		}
		catch(IOException e)
		{
		System.err.println("Error on exec() method");
		e.printStackTrace();
		}
	}
        else { //isearch
		String command = "java RNA\ProfileSearcher -d " + structData + " -q " + structQuery + " -r " + Repeat + " -n " + topN;
		command = command + " -o " + Output + " -p " + Penalty;
		System.out.println("Execute: iterative database search");
	//	system(command);
		//System.out.println(command);
		try{
		Runtime rt= Runtime.getRuntime();
		Process proc = rt.exec(command);
		InputStream inputstream = proc.getInputStream();
		InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
		BufferedReader bufferedreader = new BufferedReader(inputstreamreader);

		String line;
		while((line = bufferedreader.readLine()) != null){
			System.out.println(line);
		}
		}
		catch(IOException e)
		{
		System.err.println("Error on exec() method");
		e.printStackTrace();
		}
	}

	}

	if(job.equals("mrsa")){

		String command = "java RNA\MultiAligner -d " + structData + " -p " + Penalty + " -o "+  Output;
		System.out.println("Execute: multiple RNA secondary structure alignment");
		//System.out.println(command);
		try{
		Runtime rt= Runtime.getRuntime();
		Process proc = rt.exec(command);
		InputStream inputstream = proc.getInputStream();
		InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
		BufferedReader bufferedreader = new BufferedReader(inputstreamreader);

		String line;
		while((line = bufferedreader.readLine()) != null){
			System.out.println(line);
		}
		}
		catch(IOException e)
		{
		System.err.println("Error on exec() method");
		e.printStackTrace();
		}
		System.out.println("Detailed output can found in " + Output);

	}
	Date endtime = new Date();
	System.out.println("Total time consumed: " + (endtime.getTime() - starttime.getTime()) + " milliseconds");
	}
}
