// --*- C++ -*------x---------------------------------------------------------
// $Id: JVXMatrixWriter.h,v 1.11 2005/11/14 16:01:47 bindewae Exp $
//
// Class:           JVXMatrixWriter
// 
// Base class:      VrmlMatrixWriterBase
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            07/2005
//
// Description:     writes JVX files for input to program JavaView
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __JVX_MATRIX_WRITER_H__
#define __JVX_MATRIX_WRITER_H__

// Includes

#include <iostream>

#include <debug.h>
#include <AbstractMatrixWriter.h>
// #include <CompensationScorer.h>
#include <MatrixWriterParameters.h>
#include <Stem.h>
#include <Vector3D.h>
#include <Alignment.h>
#include <Letter3D.h>

using namespace std;

/** @author Eckart Bindewald
    @see    Tom Schneider's 1986 and 1992 papers on mutual information
    @review - */
class JVXMatrixWriter : public AbstractMatrixWriter {

public:

  JVXMatrixWriter();

  JVXMatrixWriter(const JVXMatrixWriter& other);
  
  virtual ~JVXMatrixWriter();
  
  /* OPERATORS */
  
  /** Assigment operator. */
  JVXMatrixWriter& operator = (const JVXMatrixWriter& orig);

  friend ostream& operator << (ostream& os, const JVXMatrixWriter& rval);
  
  friend istream& operator >> (istream& is, JVXMatrixWriter& rval);
  
  /* PREDICATES */
  
  /** gets algorithm for scorer of upper matrix triangle */
  // virtual int getAlgorithm1() const { return scorer.getAlgorithm(); }
  
  /** gets algorithm for scorer of lower matrix triangle */
  // virtual int getAlgorithm2() const { return scorer2.getAlgorithm(); }
  
  virtual unsigned int getDivideBoxNum() { return boxDivideNum; }  
  
  virtual const Vec<Letter3D>& getLetters3D() const { return letters3D; }
  
  virtual int getLogoMode() const { return logoMode; }
  
  virtual bool getReadingFrameMode() const { return readingFrameMode;  }

  /** central method */
  //   virtual void writeVrml(ostream& os, const Alignment& ali,
  // 			 const Vec<Stem>& referenceStems) const;

  /** central method */
  virtual void writeVrml(ostream& os, const Alignment& ali,
			 const Vec<Vec<double> >& matrix,
			 const Vec<Vec<double> >& errorMatrix,
			 const Vec<double>& infVec,
			 const Vec<double>& infErrorVec,
			 const Vec<Stem>& referenceStems) const;

  /* MODIFIERS */

  /** copy method */
  virtual void copy(const JVXMatrixWriter& other);


  /** sets algorithm for scorer of upper matrix triangle */
  // virtual void setAlgorithm1(int alg) { scorer.setAlgorithm(alg); }

  /** sets algorithm for scorer of lower matrix triangle */
  // virtual void setAlgorithm2(int alg) { scorer2.setAlgorithm(alg); }

  /** in how many boxes should a box be divided ? */
  virtual void setDivideBoxNum(unsigned int d) { boxDivideNum = d; }

  virtual void setLetters3D(const Vec<Letter3D>& other) { letters3D = other; }

  virtual void setReadingFrameMode(bool b) {
    readingFrameMode = b;
  }


  /** expect eight "RNA", "DNA" or "PROTEIN" */
  virtual void setSequenceType(const string& s) {
    sequenceType = s;
  }


 private:

  /* PREDICATES */


  void writeCone(ostream& os,
		 const Vector3D& pos,
		 const Vector3D& rot,
		 double angle,
		 const Vector3D& col ) const;

  /** cone: if not rotated, point in z-direction.
   * length: distance from base point (center of disc) to tip
   * radius: radius of disc
   * nCircle: number of devisions of circle 
   */
  void writeCone(ostream& os,
		 const Vector3D& pos,
		 double length,
		 double radius,
		 unsigned int nCircle,
		 const Vector3D& rotVec,
		 double rotAngle,
		 const Vector3D& col ) const;
  
  void writeBoxStack(ostream& os,
			 const Vector3D& pos,
			 double height, 
			 const Vec<double>& frequencies,
			 const Vec<Vector3D>& colors ) const;

  /*
    void
    writeBoxStack(ostream& os,
    const Vector3D& pos,
    double height, 
    const Vec<double>& frequencies,
    const Vec<Vector3D>& colors,
    const string& letters,
    const string& extra) const;
    
    void
    writeBoxStackLeft(ostream& os,
    const Vector3D& pos,
    double height, 
    const Vec<double>& frequencies,
    const Vec<Vector3D>& colors,
    const string& letters,
    const string& extra) const;
  */

  /** writes comment to XML file. Avoid "-" characters in comment!
      no comments within tag! 
      @see http://www.extropia.com/tutorials/xml/comments.html
  */
  void writeComment(ostream& os, const string& comment) const;
  
  
//   void
//   writeLogoFlat2(ostream& os,
// 		 const Alignment& ali,
// 		 double inf,
// 		 int pos) const;

//   void writeLogos(ostream& os, const Alignment& ali,
// 		  const Vec<double>& infVec) const;

//   void writeLogosFlat(ostream& os, const Alignment& ali,
// 		      const Vec<double>& infVec) const;

  /** writes single point */
  void writeColor(ostream& os, double r, double g, double b) const;

  /** writes single point */
  void writePoint(ostream& os, double x, double y, double z) const;

  /** central method for writing single box */
  void writeLetter(ostream& os,
		   char c,
		   const Vector3D& posOrig,
		   const Vector3D size,
		   const Vector3D& col,
		   int faceMode) const;

  void writeReadingFrame(ostream& os,
			     const Alignment& ali,
			     int pos) const;

  void writeReadingFrame(ostream& os, const Alignment& ali) const;

  /*
  void writeBoxLetter(ostream& os,
		      const Vector3D& pos,
		      double height, 
		      const Vector3D& col,
		      char letter) const;

  void writeBoxLetterLeft(ostream& os,
			  const Vector3D& pos,
			  double height, 
			  const Vector3D& col,
			  char letter) const;
  */

  /** writes box with letter as texture map.
      The string extra qualifies a potential different image. Defined so far: empty and "r" for 90 right rotated images */
  void writeBoxLetterBoth(ostream& os,
			  const Vector3D& pos,
			  double height, 
			  const Vector3D& col,
			  char letterFront,
			  char letterLeft,
			  int letterStyle) const;

  /** writes box with letter as texture map.
      The string extra qualifies a potential different image. Defined so far: empty and "r" for 90 right rotated images */
  void writeBoxLetterFlat(ostream& os,
			      const Vector3D& pos,
			      double height, 
			      const Vector3D& col,
			  char letterFront) const;
  // char letterLeft) const;

  /** writes box with letter as texture map.
      The string extra qualifies a potential different image. Defined so far: empty and "r" for 90 right rotated images */
  void writeBoxLetterFlat2(ostream& os,
			   const Vector3D& pos,
			   double height, 
			   const Vector3D& col,
			   char letterFront) const;
  // char letterLeft) const;

  /** writes box with letter as texture map.
      The string extra qualifies a potential different image. Defined so far: empty and "r" for 90 right rotated images */
  void writeBoxLetterBoth2(ostream& os,
			   const Vector3D& pos,
			   const Vector3D& dimensions,
			   const Vector3D& col,
			   char letterFront,
			   char letterLeft) const;

  void writeBox(ostream& os,
		const Vector3D& pos,
		double height, 
		const Vector3D& col ) const;
  
  void writeBox(ostream& os,
		const Vector3D& pos,
		const Vector3D& size, 
		const Vector3D& col,
		bool faceMode = true) const;

  /*
  void writeOpenBoxLetter(ostream& os,
			  const Vector3D& pos,
			  double height, 
			  const Vector3D& col,
			  char letter) const;

  void writeOpenBoxLetterLeft(ostream& os,
			  const Vector3D& pos,
			  double height, 
			  const Vector3D& col,
			  char letter) const;
  */

  /** writes box with letter as texture map.
      The string extra qualifies a potential different image. Defined so far: empty and "r" for 90 right rotated images */
  void writeOpenBoxLetterBoth(ostream& os,
			      const Vector3D& pos,
			      double height, 
			      const Vector3D& col,
			      char letterFront,
			      char letterLeft,
			      int letterStyle) const;    

  void writeOpenBox(ostream& os,
		    const Vector3D& pos,
		    double height, 
		    const Vector3D& col ) const;


  void writeOpenBox(ostream& os,
	       const Vector3D& pos,
	       const Vector3D& size, 
	       const Vector3D& col ) const;

  void writeOpenBoxRaw(ostream& os,
	       const Vector3D& pos,
	       const Vector3D& size, 
	       const Vector3D& col ) const;

  void writeBox(ostream& os,
		    const Vector3D& pos,
		    const Vector3D& size,
		    const Vector3D& rot,
		    double angle,
		    const Vector3D& col ) const;

  void writeMatching(ostream& os,
			 const Alignment& ali,
			 int pos) const;
  void writeMatching(ostream& os,
		    const Alignment& ali) const;

  void writePointLayer(ostream& os,
		       const Vector3D& pos,
		       double dz, 
		       double width) const;

  /** writes row of boxes, expects correct order */
  void writeBoxStackRaw(ostream& os,
			const Vector3D& pos,
			double height, 
			const Vec<double>& frequencies,
			const Vec<Vector3D>& colors ) const;

  void writeBoxStackFlat(ostream& os,
			 const Vector3D& pos,
			 double height, 
			 double errorHeight,
			 const Vec<double>& frequencies,
			 const Vec<Vector3D>& colors,
			 const string& lettersFront,
			 int faceMode,
			 int letterStyle) const;
  // const string& lettersLeft) const;

  void writeBoxStackFlat2(ostream& os,
			  const Vector3D& pos,
			  double height, 
			  double errorHeight,
			  const Vec<double>& frequencies,
			  const Vec<Vector3D>& colors,
			  const string& lettersFront,
			  int faceMode,
			  int letterStyle) const;
  // const string& lettersLeft) const;

  // moved to AbstractMatrixWriter :  
//   bool writePosStack(ostream& os,
// 		     const Alignment& ali,
// 		     const Vec<Stem>& refStems,
// 		     unsigned int i,
// 		     unsigned int j,
// 		     double mutInf,
// 		     double mutInfError,
// 		     int letterStyle ) const;  

  /**
     initialize vrml world
     backround code take from: 
     http://www.dform.com/inquiry/tutorials/3dsmax/background/bgascii.html
  */
  void init(ostream& os, unsigned int len) const;
    
  void finalize(ostream& os) const;

  /* ATTRIBUTES */

  Vec<Letter3D> letters3D;

  bool readingFrameMode;
  
  unsigned int boxDivideNum;

  // int errorMode; // if not zero, display error bars

  double boxZMin;
  double dxLetterFlat; // = 0.1;
  double dxLetterFlat2; // = 0.1;
  double dxLetterFront; // = 0.1;
  double dyLetterFlat; // = 0.1;
  double dyLetterFlat2; // = 0.1;
  double dyLetterFront; // = -0.6;
  double dxLetterLeft; // = -0.2;
  double dyLetterLeft; //  = 0.3;

  // double frequencyLimit;

  double gapLimit;

  double infLimit; // = 0.5;
  
  double letterHeight; // minimum height of letters

  double letterWidth;

  //   double referenceGap; // how much "air" between regular stack and reference cube ?

  // double stretchZ; // = 10.0;

  // string alphabet;

  string sequenceType;



  // CompensationScorer scorer;

  // CompensationScorer scorer2;

  MatrixWriterParameters writerParameters;

  // VrmlMatrixColorScheme colorScheme;

};

#endif /* __ACLASS_H__ */

