// --*- C++ -*------x---------------------------------------------------------
// $Id: ResourceBundle.cc,v 1.1 2005/07/09 15:24:58 bindewae Exp $
//
// Class:           ResourceBundle
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2005/07/09 15:24:58 $
//
// Description:     - 
// -----------------x-------------------x-------------------x-----------------

#include <ResourceBundle.h>
#include <StringTools.h>

// ---------------------------------------------------------------------------
//                                   ResourceBundle
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */

/* default constructor */
ResourceBundle::ResourceBundle() 
{
}

/* copy constructor */
ResourceBundle::ResourceBundle(const ResourceBundle& other)
{
  copy(other);
}

/* destructor */
ResourceBundle::~ResourceBundle() { }

/* OPERATORS */

/** Assigment operator. */
ResourceBundle& 
ResourceBundle::operator = (const ResourceBundle& orig)
{
  if ((&orig) != this) {
    copy(orig);
  }
  return *this;
}

/** Returns key-value pairs of the form key=value in each line. 
 */
ostream& 
operator << (ostream& os, const ResourceBundle& rval)
{
  map<string,string>::iterator i;
  for (i = rval.dict.begin(); i != rval.dict.end(); i++) {
    os << i->first << "=" << i->second << endl;
  }
  return os;
}

/** expects key-value pairs of the form key=value in each line. 
    Comments allowed (starting with "#").
 */
istream& 
operator >> (istream& is, ResourceBundle& rval)
{
  while(is) {
    string line = getLine(is);
    if (line.size()>0) {
      vector<string> words=getTokens(line,string("="));
      if ((words.size()==2) && (words[0][0]!='#')) {
	rval.dict.insert(pair<string,string>(words[0],words[1]));
      }
    }
  }
  return is;
}

/* PREDICATES */

string
ResourceBundle::getString(const string& s) const
{
  map<string,string>::iterator iter = dict.find(s);
  if (iter != dict.end()) {
    return iter->second;
  }
  string emptyString;
  return emptyString;
}

/* MODIFIERS */

/* copy method */
void 
ResourceBundle::copy(const ResourceBundle& other)
{
  dict = other.dict;
}
