// --*- C++ -*------x---------------------------------------------------------
#ifndef __CORRELATION__
#define __CORRELATION__

#include <MAFAlignment.h>
#include <debug.h>
#include <GetArg.h>

using namespace std;

class Correlation {

 public:

  typedef MAFAlignment::length_type length_type;
  typedef map<string, string> properties_type;
  
 private:
  double score;
  length_type start;
  length_type stop;
  // mutable map<string, string> properties;

 public:

  Correlation() : score(0.0), start(0), stop(0) { }

  Correlation(length_type _start, length_type _stop) : score(0.0) {
    PRECOND(_start != _stop);
    if (_start < _stop) {
      start = _start;
      stop = _stop;
    }
    else {
      start = _stop;
      stop = _start;   
    }
    POSTCOND(validate());
  }

  Correlation(const Correlation& other) {
    copy(other);
  }

  virtual Correlation& operator = (const Correlation& other) {
    if (&other != this) {
      copy(other);
    }
    return (*this);
  }

  virtual ~Correlation() { }

  virtual void copy(const Correlation& other) {
    score = other.score;
    start = other.start;
    stop = other.stop;
    // properties = other.properties;
  }

  string hash() const { return hash(start, stop); }

  static string hash(length_type _start, length_type _stop) { 
    if (_start > _stop) {
      return hash(_stop, _start);
    }
    return "" + itos(_start) + "_" + itos(_stop); // sorry, hard coded long type
  } 

  double getScore() const { return score; }

  length_type getStart() const { return start; }

  length_type getStop() const { return stop; }

  // properties_type getProperties(); 

  void setScore(double _score) { score = _score; }

  void setStart(length_type _start) { start = _start; }

  void setStop(length_type _stop) { stop = _stop; }

  // void setProperty(const string& key, const string& value) {
  // properties[key] = value;
  // }

  // string getProperty(const string& key) const {
  // string result = properties[key];
  // return result;
  // }

  bool validate() const {
    return start < stop;
  }

};

/** Default output ethod. FIXIT: output of properties */
inline
ostream&
operator << (ostream& os, const Correlation& corr) {
  os << (corr.getStart() + 1) << " " << (corr.getStop() + 1) << " " << corr.getScore();
  return os;
}

inline
bool
operator < (const Correlation& corr1, const Correlation& corr2) {
  if (corr1.getStart() < corr2.getStart()) {
    return true;
  } else if (corr1.getStart() > corr2.getStart()) {
    return false;
  } else { // start is equal, now test stop:
    if (corr1.getStop() < corr2.getStop()) {
      return true;
    } 
  }
  return false; // must be equal or greater
}

inline
bool
operator >= (const Correlation& corr1, const Correlation& corr2) {
  return !(corr1 < corr2);
}

inline
bool
operator == (const Correlation& corr1, const Correlation& corr2) {
  return (corr1.getStart() == corr2.getStart()) && (corr1.getStop() == corr2.getStop());
}

#endif
