// --*- C++ -*------x---------------------------------------------------------
#ifndef __HASH_CORRELATION_FINDER_TEST__
#define __HASH_CORRELATION_FINDER_TEST__

#include <HashCorrelationFinder.h>
#include <debug.h>
#include <iostream>
#include <fstream>

using namespace std;

class HashCorrelationFinderTest {

 public:
  typedef HashCorrelationFinder::length_type length_type;
  typedef HashCorrelationFinder::size_type size_type;

 public:

  HashCorrelationFinderTest() { } 

  static void testFilterIsolatedCorrelations();

  /** Tests the "run" method of HashCorrelationFinder */
  static void testRun();

  /** Tests the "run" method of HashCorrelationFinder using a somewhat larger MAF alignment. */
  static void testRunSlow();

  /** Uses complete mitochondrial genome as test case. */
  static void testRunChrM();

  static void testSearchMafColumn();

  static void testAllFast() {
    testRun();
    testFilterIsolatedCorrelations();    
    testSearchMafColumn();
    testRunChrM();
  }

  static void testAllSlow() {
    testRunSlow();
  }

  static void testAll() {
    testAllFast();
    // testAllSlow();
  }

};


#endif
