// --*- C++ -*------x---------------------------------------------------------
#ifndef __MAIN_TOOLS__
#define __MAIN_TOOLS__

#include <CorrelationFinder.h>
#include <HashCorrelationFinder3.h>

/** Helper methods for "main" methods and applications */
class MainTools {

 public:

  typedef MAFAlignment::size_type size_type;
  typedef CorrelationFinder::length_type length_type;
  typedef HashCorrelationFinder3::count_hash_type count_hash_type;
  /** output of command line parameter with which the program was called. */
  static void parameterOutput(ostream& os, int argc, char** argv) {
    for (int i = 0; i < argc; i++)
      {
	os << argv[i] << " ";
      }
    os << endl;
  }

  static void writeStem(ostream& os, const Stem& stem, double logN, bool pvalMode, bool reverseMode) {
    os << (stem.getStart() + 1) << " " << (stem.getStop() + 1) << " " << stem.getLength();
    if (pvalMode) {
      double logPVal = stem.getEnergy();
      double logEVal = logPVal + logN;
      os << " " << exp(logPVal) << " " << exp(logEVal);
    }
    os << " " << stem.getSequence1() << " " << stem.getSequence2() << " " << stem.getInvariant(reverseMode) << " " << stem.getEnergy();
  }
  
  static void writeStems(ostream& os, const Vec<Stem>& stems, 
		  length_type totLen1, length_type totLen2, bool pvalMode, bool reverseMode) {
    ASSERT(totLen1 > 0);
    os << "Id Start Stop Length Pvalue Evalue" << endl; 
    double logN = 0;
    if (totLen2 > 0) {
      logN = log(totLen1) + log(totLen2); // log(N*M), for 2 sequences
    } else {
      logN = log(totLen1) + log(totLen1-1) - log(2.0); // log((N*(N-1))/2) // for one sequence
    }
    for (size_type i = 0; i < stems.size(); ++i) {
      os << (i + 1) << " ";
      writeStem(os, stems[i], logN, pvalMode, reverseMode);
      os << endl;
      //     << (stems[i].getStart() + 1) << " " << (stems[i].getStop() + 1) << " " << stems[i].getLength();
      //     if (pvalMode) {
      //       double logPVal = stems[i].getEnergy();
      //       double logEVal = logPVal + logN;
      //       os << " " << exp(logPVal) << " " << exp(logEVal) <<  endl;
      //     } else {
      //       os << endl;
      //     }
    }
  }

};

/** Writes hash table as key-value pairs */
template<class T>
inline
void
writeHash(ostream& os, const T& counts) {
  for (typename T::const_iterator it = counts.begin(); it != counts.end(); ++it) {
    os << it->first << " " << it->second << endl;
  }
}

/** Writes hash table as key-value pairs */
template<class S, class T>
inline
void
writeHashs(ostream& os, const S& hash, const T& hash2) { // , const string& notFound, const string& delim=" ") {
  string delim = " ";
  string notFound = "-";
  for (typename S::const_iterator it = hash.begin(); it != hash.end(); ++it) {
    os << it->first << delim << it->second << delim;
    typename T::const_iterator it2 = hash2.find(it->first);
    if (it2 != hash2.end()) {
      os << it2->second;
    } else {
      os << notFound;
    }
    os << endl;
  }
}

/** Writes hash table as key-value pairs */
template<class S, class T>
inline
void
writeHashs(ostream& os, const S& hash, const T& hash2, const T& hash3){ // , const string& notFound, const string& delim=" ") {
  string delim = " ";
  string notFound = "-";
  for (typename S::const_iterator it = hash.begin(); it != hash.end(); ++it) {
    os << it->first << delim << it->second << delim;
    typename T::const_iterator it2 = hash2.find(it->first);
    if (it2 != hash2.end()) {
      os << it2->second;
    } else {
      os << notFound;
    }
    os << delim;
    typename T::const_iterator it3 = hash3.find(it->first);
    if (it3 != hash3.end()) {
      os << it3->second;
    } else {
      os << notFound;
    }
    os << endl;
  }
}


#endif
