#include <LocoRnaMain.h>
#include <BirthdayProb.h>
#include <InteractionClusterAnalyzer.h>
#include <HashCorrelationFinder3.h>

// static member in order to facilitate summing of multi-threaded use
// HashCorrelationFinder::length_type HashCorrelationFinder::ignoredCount = 0; 

// Unload (temporarily save to disk to save RAM memory) alignment blocks with more than this many characters:
MAFAlignment::length_type MAFAlignment::unloadCharLimit = 10000;

HashCorrelationFinder::intersection_cache_type HashCorrelationFinder::intersectionCache;

HashCorrelationFinder3::size_type HashCorrelationFinder3::matchPairCount = 0;
HashCorrelationFinder3::count_hash_type HashCorrelationFinder3::matchPairCountHash;
HashCorrelationFinder3::count_hash_type HashCorrelationFinder3::matchPairCountHash2;

// BirthdayProb InteractionClusterAnalyzer::birthdays(5000); // size of largest cluster that can be analyzed 

/** Main function that executes test method */
int main(int argc, char ** argv, char ** env) {
  LocoRnaMain::writeWelcomeMessage(cout);
  LocoRnaMain locomain(cout, argc, argv, env);
  int code = locomain.run();
  return code;
}
