#include <MAFAlignment.h>
#include <BEDRegions.h>

MAFAlignment::length_type MAFAlignment::unloadCharLimit = 10000;

void helpOutput(ostream& os) {
  os << "usage: filtermaf MAFfile BEDfile ASSEMBLY" << endl;
}

int main(int argc, char ** argv) {
  if (argc != 4) {
    helpOutput(cout);
    exit(0);
  }
  MAFAlignment maf;
  string currAssembly(argv[3]);
  maf.setRefAssembly(currAssembly);
  maf.setVerbose(0);
  BEDRegions bed;
  bed.setAssembly(currAssembly);
  ASSERT(bed.getAssembly() == currAssembly);
  char * filename = argv[1];
  char * bedfilename = argv[2];
  // cout << "Reading BED format regions from file " << bedfilename << " : " << bed.getAssembly() << endl;
  ifstream ifsBed(bedfilename);
  ERROR_IF(!ifsBed, "Could not find BED format filename ");
  bed.read(ifsBed);
  ifsBed.close();
  // cout << "Read BED data file: " << bed.getAssembly() << endl << bed << endl;
  // ASSERT(bed.size() == 1);
  ERROR_IF(!bed.validate(), "BED regions are not well defined!");
  ifstream ifs(filename);
  ERROR_IF(!ifs, "Error opening MAF file!");
  maf.filterMAF(ifs, cout, bed);
  ifs.close();

}

