#ifndef __HISTOGRAM_STANDARD_FUNCTOR__
#define __HISTOGRAM_STANDARD_FUNCTOR__

#include <DoubleIntFunctor.h>

class HistogramStandardFunctor : public DoubleIntFunctor {

 public:

  HistogramStandardFunctor() : min(0.0), step(1.0) { }
  
  HistogramStandardFunctor(double _min, double _step) : min(_min), step(_step)
    { }
  
  virtual ~HistogramStandardFunctor() {}

  virtual int operator() (double value) const {
    return static_cast<int>((value - min) / step);
  }

 private:

  double min;
  double step;

};

#endif
