// --*- C++ -*------x---------------------------------------------------------
// $Id: RankedSolution2.cc,v 1.1.1.1 2006/07/03 14:43:21 bindewae Exp $
//
// Class:           RankedSolution2
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2006/07/03 14:43:21 $
//
// Description:     Implements a ranked docking solutions
// -----------------x-------------------x-------------------x-----------------

#include <RankedSolution2.h>

// ---------------------------------------------------------------------------
//                                   RankedSolution2
// -----------------x-------------------x-------------------x-----------------

/* CONSTRUCTORS */
RankedSolution2::RankedSolution2() : first(0.0), third(0) 
{
}

RankedSolution2::RankedSolution2(const RankedSolution2& other) 
{
  copy(other);
}


/* OPERATORS */

/** Assigment operator. */
RankedSolution2& 
RankedSolution2::operator = (const RankedSolution2& orig)
{
  if (&orig != this) {
    copy(orig);
  }
  return *this;
}

/** comparison operator. */
bool
operator < (const RankedSolution2& lval,
	    const RankedSolution2& rval)
{
  return lval.first < rval.first;
}

/** comparison operator. */
bool
operator < (double lval,
	    const RankedSolution2& rval)
{
  return lval < rval.first;
}

/** comparison operator. */
bool
operator < (const RankedSolution2& lval,
	    double rval)
{
  return lval.first < rval;
}

/* PREDICATES */



/* MODIFIERS */


void
RankedSolution2::copy(const RankedSolution2& other)
{
  first = other.first;
  second = other.second;
  third = other.third;
}

