// --*- C++ -*------x---------------------------------------------------------
// $Id: RankedSolution2.h,v 1.1.1.1 2006/07/03 14:43:20 bindewae Exp $
//
// Class:           RankedSolution2
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Description:     Implements ranked solutions
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __RANKED_SOLUTION2_H__
#define __RANKED_SOLUTION2_H__

// Includes

#include <iostream>
#include <debug.h>
#include <CoordinateSystem.h>

class RankedSolution2 {
public:
  RankedSolution2();

  RankedSolution2(double _first, const CoordinateSystem& _second) : first(_first),
							       second(_second), third(0)
  {
  }

  RankedSolution2(double _first, const CoordinateSystem& _second, unsigned int _third) : 
    first(_first), second(_second), third(_third)
  {
  }

  RankedSolution2(const RankedSolution2& orig);

  virtual ~RankedSolution2() {} 

  /* OPERATORS */

  /** Assigment operator. */
  RankedSolution2& operator = (const RankedSolution2& orig);

  friend ostream& operator << (ostream& os, const RankedSolution2& rval) { 
    os << rval.first << " " << rval.second << " " << rval.third; return os; }

  friend istream& operator >> (istream& is, RankedSolution2& rval) { 
    is >> rval.first >> rval.second >> rval.third; return is; }

  /* PREDICATES */

  /* MODIFIERS */
  void copy(const RankedSolution2& other);

  /* ATTRIBUTES */

  double first;
  CoordinateSystem second;
  unsigned int third;

protected:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* PRIVATE ATTRIBUTES */

};

/** comparison operator. */
bool operator < (const RankedSolution2& lval,
		 const RankedSolution2& rval) ;

/** comparison operator. */
bool operator < (double lval,
		 const RankedSolution2& rval) ;

/** comparison operator. */
bool operator < (const RankedSolution2& lval,
		 double rval) ;


#endif /* __ACLASS_H__ */

