#ifndef _PROPERTIES_H_
#define _PROPERTIES_H_

# include<string>
#include <map>

using namespace std;

class Properties {

 private:
  map<string, string> properties;

 public:

  Properties() { }

  Properties(const Properties& other) { copy(other); }

  Properties& operator = (const Properties& other) {
    if (&other != this) {
      copy(other);
    }
    return (*this);
  }

  void copy(const Properties& other) {
    properties = other.properties;
  }

  virtual ~Properties() { }

  string getProperty(string key) const {
    map<string, string>::const_iterator it = properties.find(key);
    if (it == properties.end()) {
      return "";
    }
    return it->second;
  }

  void setProperty(string key, string value) {
    properties[key] = value;
  }



};

#endif
