#include <string>
#include <iostream>
#include <fstream>
#include <map>
#include <GetArg.h>
#include <debug.h>
#include <StringTools.h>

typedef string::size_type size_type;
typedef multimap<string,size_type> map_type;

void
helpOutput(ostream& os) {
  os << "Program ijoin performs inner join on two files and a specified field. Version 0.5.0" << endl
     << "usage: ijoin <FILE1> <FILE2> <COLUMN1> <COLUMN2>" << endl;
}

int main(int argc, char ** argv) {
  if (argc != 5) {
    helpOutput(cout);
    exit(0);
  }
  string delim = "\t";
  string filename1(argv[1]);
  string filename2(argv[2]);
  size_type col1 = stoui(argv[3]);
  ERROR_IF(col1 < 1, "First column number must be great or equal one.");
  col1--;
  size_type col2 = stoui(argv[4]);
  ERROR_IF(col2 < 1, "Second column number must be great or equal one.");
  col2--;
  ifstream file1(filename1.c_str());
  ERROR_IF(!file1, "Error opening first file!");
  vector<string> lines1 = getLines(file1);
  file1.close();
  map_type map1;
  map_type map2;
  for (size_type i = 0; i < lines1.size(); ++i) {
    vector<string> words = getTokens(lines1[i]);
    if (words.size() > col1) {
      map1.insert(pair<string,size_type>(words[col1], i)); // store line number
    }
  }

  ifstream file2(filename2.c_str());
  ERROR_IF(!file2, "Error opening second file!");
  vector<string> lines2 = getLines(file2);
  file1.close();
  for (size_type i = 0; i < lines2.size(); ++i) {
    vector<string> words = getTokens(lines2[i]);
    if (words.size() > col2) {
      map2.insert(pair<string,size_type>(words[col2], i)); // store line number
    }
  }
  // cout << "# hash map sizes: " << map1.size() << " " << map2.size() << endl;
  for (map_type::const_iterator it = map1.begin(); it != map1.end(); it++) {
    pair<map_type::const_iterator, map_type::const_iterator> range = map2.equal_range(it->first);
    for (map_type::const_iterator jt = range.first; jt != range.second; jt++) {
      cout << lines1[it->second] << delim << lines2[jt->second] << endl;
    }
  }
  return 0;
}
