#include <fstream>
#include <Hops.h>
#include <GetArg.h>
#include <RnaSecondaryStructure.h>
#include <RnaSecondaryStructureTools.h>

using namespace std;

typedef Hops::index_type index_type;

void
helpOutput(ostream& os) {
  cout << "The program hops computes the minimum number of steps between two residues of an RNA secondary structure." << endl;
  cout << "A step (a \"hop\") can be along the sequence or across a base pairing." << endl;
  cout << "Usage: hops -i filename -j index1 -k index2 [-v verbose]" << endl;
}

int main(int argc, char** argv) {

  if (argc < 4) {
    helpOutput(cout);
    exit(0);
  }
  string filename;
  index_type id1 = 0;
  index_type id2 = 0;
  index_type verbose = 0;
  getArg("i", filename, argc, argv, filename);
  getArg("j", id1, argc, argv, id1);
  ERROR_IF(id1 < 1, "Index 1 (option -j) must be greater or equals 1!");
  id1--;  // internal counting is zero-based
  getArg("k", id2, argc, argv, id2);
  ERROR_IF(id2 < 1, "Index 2 (option -k) must be greater or equals 1!");
  id2--; // internal counting is zero-based
  getArg("v", verbose, argc, argv, verbose);
  
  ERROR_IF(filename.size() == 0, 
	   "No filename was specified. Use option -i");

  ifstream ifs(filename.c_str());
  ERROR_IF(!ifs, "Error opening file " + filename);
  RnaSecondaryStructure structure = RnaSecondaryStructureTools::readCt(ifs);
  
  Hops hops(structure);
  hops.setVerbose(verbose);
  if (verbose > 0) {
    RnaSecondaryStructureTools::writeCt(cout, structure);
  }
  cout << "Hops " << (id1 + 1) << " " << (id2 + 1) << " : " << hops.hops(id1,id2) << endl;

}

