#ifndef _HIST_3D_PARAM_H_
#define _HIST_3D_PARAM_H_

class Hist3DParam {
 public:
  Hist3DParam() : minX(0.0),minY(0.0),minZ(0.0),
    numX(100),numY(100),numZ(100),
    deltaX(1.0),deltaY(1.0),deltaZ(1.0) { }

  friend ostream& operator << (ostream& os, const Hist3DParam& rval);
  friend istream& operator >> (istream& is, Hist3DParam& rval);

  double minX;
  double minY;
  double minZ;
  unsigned int numX;
  unsigned int numY;
  unsigned int numZ;
  double deltaX;
  double deltaY;
  double deltaZ;
};

inline
ostream&
operator << (ostream& os, const Hist3DParam& rval)
{
  os << rval.minX << " " << rval.deltaX << " " << rval.numX << endl
     << rval.minY << " " << rval.deltaY << " " << rval.numY << endl
     << rval.minZ << " " << rval.deltaZ << " " << rval.numZ << endl;
  return os;
}

inline
istream&
operator >> (istream& is, Hist3DParam& rval)
{
  is >> rval.minX >> rval.deltaX >> rval.numX 
     >> rval.minY >> rval.deltaY >> rval.numY 
     >> rval.minZ >> rval.deltaZ >> rval.numZ;
  return is;
}


#endif
