// --*- C++ -*------x---------------------------------------------------------
// $Id: addmatrices.cc,v 1.2 2007/01/22 05:49:04 bindewae Exp $
//
// Program:         - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            $Date: 2007/01/22 05:49:04 $
//
// Description:     
// 
// -----------------x-------------------x-------------------x-----------------

#include <iostream>
#include <fstream>
#include <string>
#include <Vec.h>
#include <debug.h>
#include <GetArg.h>
#include <FileName.h>
#include <vectornumerics.h>

void
helpOutput(ostream& os)
{
  os << "usage: addmatrices -i inputfiles -m [1|2] --verbose n" << endl;
  os << "--average 0|1|2 : no averaging , average, standard deviation" << endl;
  os << "--if inputformat" << endl
     << "--of outputformat" << endl;
  
}

/** output of command line parameter with which the program was called. */
void
parameterOutput(ostream& os, int argc, char** argv)
{
  for (int i = 0; i < argc; i++)
    {
      os << argv[i] << " ";
    }
  os << endl;
}

/** reads matrix in format that is also used by program "R" */
/*
Vec<Vec<double> >
readPlainMatrix(istream& is)
{
  Vec<Vec<double > > result;
  while (is) {
    string line = getLine(is);
    Vec<string> words = getTokens(line);
    if (words.size() > 0) {
      Vec<double> row(words.size());
      for (unsigned int i = 0; i < words.size(); ++i) {
	row[i] = stod(words[i]);
	if (!isDefined(row[i])){
	  row[i] = 0.0;
	}
      }
      result.push_back(row);
    }
  }
  return result;
}
*/

void
writeMatrix(ostream& os,
	    const  Vec<Vec<double> >& m)
{
  for (unsigned int i = 0; i < m.size(); ++i) {
    for (unsigned int j = 0; j < m[i].size(); ++j) {
      os << m[i][j] << " ";
    }
    os << endl;
  }
}

int
main(int argc, char ** argv)
{

  bool helpMode;
  int argcFile = 0;
  int mode = 1;
  char ** argvFile = 0;
  int avgMode = 0;
  int inputFormat = 3;
  int outputFormat = 3;
  unsigned int verboseLevel = 1;
  double sumTot = 0.0;
  double sumSquareTot = 0.0;
  string commandFileName;
  string logFileName; //  = "mainprogramtemplate.log";
  string rootDir = ".";
  Vec<string> inputFileNames;

  getArg("-help", helpMode, argc, argv);

  if ((argc < 2) || helpMode)  {
    helpOutput(cout);
    exit(0);
  }

  getArg("-root", rootDir, argc, argv, rootDir);
  addSlash(rootDir);

  getArg("-commands", commandFileName, argc, argv, commandFileName);
  addPathIfRelative(commandFileName, rootDir);

  if (commandFileName.size() > 0) {
    ifstream commandFile(commandFileName.c_str());
    if (!commandFile) {
      if (isPresent("-commands", argc, argv)) {
	ERROR_IF(!commandFile, "Error opening command file.");
      }
      else {
	cerr << "Warning: Could not find command file: " + commandFileName 
	     << endl;
      }
    }
    else {
      argvFile = streamToCommands(commandFile, argcFile, 
				  string("mainprogramtemplate"));
    }
    commandFile.close();
  }
  
  getArg("-average", avgMode, argc, argv, avgMode);
  getArg("i", inputFileNames, argc, argv);
  getArg("-if", inputFormat, argc, argv, inputFormat);
  getArg("-log", logFileName, argc, argv, logFileName);
  getArg("-log", logFileName, argcFile, argvFile, logFileName);
  addPathIfRelative(logFileName, rootDir);
  getArg("m", mode, argcFile, argvFile, mode);
  getArg("m", mode, argc, argv, mode);
  getArg("-of", outputFormat, argc, argv, outputFormat);
  getArg("-verbose", verboseLevel, argcFile, argvFile, verboseLevel);
  getArg("-verbose", verboseLevel, argc, argv, verboseLevel);


  if (logFileName.size() > 0) {
    ofstream logFile(logFileName.c_str(), ios::app);
    parameterOutput(logFile, argc, argv);
    if (argcFile > 1) {
      logFile << "Parameters from command file: ";
      parameterOutput(logFile, argcFile, argvFile);
    }
    logFile.close();
  }


  /***************** MAIN PROGRAM *****************************/

  Vec<Vec<double> > matrix, matrixSquare;
  Vec<Vec<double > > tmpMatrix;  
  for (unsigned int i = 0; i < inputFileNames.size(); ++i) {
    if (verboseLevel > 1) {
      cout << "Reading matrix : " << inputFileNames[i] << endl;
    }
    ifstream inputFile(inputFileNames[i].c_str());
    ERROR_IF(!inputFile, "Error opening input file!");
    if (i == 0) {
      switch (inputFormat) {
      case 1: inputFile >> matrix;
	break;
      case 3: matrix = readPlainMatrix(inputFile);
	break;
      default: ERROR("Unknown input format!");
      }
      matrixSquare = matrix;
      for (unsigned int i = 0; i < matrixSquare.size(); ++i) {
	for (unsigned int j = 0; j < matrixSquare[i].size(); ++j) {
	  matrixSquare[i][j] = matrix[i][j] * matrix[i][j];
	}
      }
      for (unsigned int i = 0; i < matrix.size(); ++i) {
	for (unsigned int j = 0; j < matrix[i].size(); ++j) {
	  sumTot += matrix[i][j];
	  sumSquareTot += matrix[i][j] * matrix[i][j];
	}
      }
    }
    else {
      switch (inputFormat) {
      case 1: inputFile >> tmpMatrix;
	break;
      case 3: tmpMatrix = readPlainMatrix(inputFile);
	break;
      default: ERROR("Unknown input format!");
      }
      switch (mode) {
      case 1:
	matrix = matrixAdd(matrix, tmpMatrix);
	break;
      case 2:
	matrix = matrixMax(matrix, tmpMatrix);
	break;
      default:
	ERROR("Unknown matrix transformation mode!");
      }
      matrixSquare = matrixSquareAdd(matrixSquare, tmpMatrix);
      for (unsigned int i = 0; i < tmpMatrix.size(); ++i) {
	for (unsigned int j = 0; j < tmpMatrix[i].size(); ++j) {
	  sumTot += tmpMatrix[i][j];
	  sumSquareTot += tmpMatrix[i][j] * tmpMatrix[i][j];
	}
      }

    }
    inputFile.close();
  }

  unsigned int numTot = inputFileNames.size()*matrix.size()*matrix[0].size();
  double avgTot = sumTot / numTot;
  double devTot = sqrt(varianceFromSum(sumTot, sumSquareTot, numTot));
  // standard deviation assuming mean zero:
  double devZero = sqrt(sumSquareTot / numTot);
  
  if (avgMode == 0) { // simple sum, nothing to be done!
  }
  else if (avgMode == 1) { // compute average
    for (unsigned int i = 0; i < matrix.size(); ++i) {
      for (unsigned int j = 0; j < matrix[i].size(); ++j) {
	matrix[i][j] /= inputFileNames.size();
      }
    }
  }
  else if (avgMode == 2) { // compute standard deviation
    for (unsigned int i = 0; i < matrix.size(); ++i) {
      for (unsigned int j = 0; j < matrix[i].size(); ++j) {
	matrix[i][j] = sqrt(varianceFromSum(matrix[i][j],
			       matrixSquare[i][j],inputFileNames.size()));
      }
    }
  }
  else if (avgMode == 3) { // average unless zero hypothesis cannot be rouled out:
    for (unsigned int i = 0; i < matrix.size(); ++i) {
      for (unsigned int j = 0; j < matrix[i].size(); ++j) {
	double dev = sqrt(varianceFromSum(matrix[i][j],
			       matrixSquare[i][j],inputFileNames.size()));
	double avg = matrix[i][j] / inputFileNames.size();
	if (fabs(avg) <= dev) {
	  matrix[i][j] = 0.0;
	}
	else {
	  matrix[i][j] /= inputFileNames.size();
	}
      }
    }

  }
  else {
    ERROR("Unknown averaging mode!");
  }

  switch (outputFormat) {
  case 1: cout << matrix << endl;
    break;
  case 3:
    writeMatrix(cout, matrix);
    break;
  case 5:
    cout << "Average: " << avgTot << " +- " << devTot << " " 
	 << devZero << endl;
    break;
  default:
    ERROR("Unknown output format!");
  }

  return 0;
}
