# compute combined P-value of a set of independent tests according to Simes
# Taken from paper by James Theiler: A brief note on Combining statistics test by multiplying p-values
computeCombinedPValuesSimes <- function(pv) {
# print(pv)
  stopifnot(!is.list(pv))
  stopifnot(is.numeric(pv))
  pv <- sort(pv)
  m <- length(pv)
  result <- m *pv[1]
  if (m >= 2) {
   for (k in 2:m) {
    x <- m * pv[k] / k
    if (x < result) {
       result <- x
    }
   }
  }
  if (result > 1.0) {
   result <- 1.0
  }
  result
}

test.computeCombinedPValuesSimes <- function(pv=rep(0.05, 5)) {
 computeCombinedPValuesSimes(pv)
}

# compute combined P-value of a set of independent tests
computeCombinedPValues <- function(pv, method="TPM", t=0.05, verbose=FALSE) {
  stopifnot(length(pv) >= 1) 
  result <- NULL
  if (method == "simes") {
    result = computeCombinedPValuesSimes(pv)
  } else if (method == "TPM") {
    result = computeCombinedPValuesTPM(pv, t=t, verbose=verbose)
  } else if (method == "tpms") { # Combination of TPM and Simes
     found <- FALSE
     method2 = "simes"
     for (i in 1:length(pv)) {
       if (pv[i] <= t) {
        found <- TRUE
        method2 = "TPM"
        break
       }
     }
    result = computeCombinedPValues(pv, method2, t)
  } else {
   stop("Unknown method for combining P-values. Currently implemented: TPM(default), simes.")
 }
 result
}

test.computeCombinedPValues <- function(pv=rep(0.06, 5), method="tpms", t=0.05) {
 computeCombinedPValues(pv , method=method)
}
