readFASTA <- function (file, checkComments = TRUE, strip.descs = TRUE) 
{
    if (missing(strip.descs)) 
        warning("use 'strip.descs=FALSE' for compatibility with old version\n", 
            "  of readFASTA(), or 'strip.descs=TRUE' to remove the \">\"\n", 
            "  at the beginning of the description lines and to get\n", 
            "  rid of this warning (see '?readFASTA' for more details)")
    if (is.character(file)) {
        file <- file(file, "r")
        on.exit(close(file))
    }
    else {
        if (!inherits(file, "connection")) 
            stop("'file' must be a character string or connection")
        if (!isOpen(file)) {
            open(file, "r")
            on.exit(close(file))
        }
    }
    s1 <- scan(file = file, what = "", sep = "\n", quote = "", 
        allowEscapes = FALSE, quiet = TRUE)
    if (checkComments) {
        comments <- grep("^;", s1)
        if (length(comments) > 0) 
            s1 <- s1[-comments]
    }
    descriptions <- which(substr(s1, 1L, 1L) == ">")
    numF <- length(descriptions)
    if (numF == 0) 
        stop("no FASTA sequences found")
    dp <- descriptions + 1L
    dm <- descriptions - 1L
    end <- c(dm[-1], length(s1))
    lapply(seq_len(numF), function(i) {
        desc <- s1[descriptions[i]]
        if (strip.descs) 
            desc <- substr(desc, 2L, nchar(desc))
        if (end[i] >= dp[i]) {
            seq <- paste(s1[dp[i]:end[i]], collapse = "")
        }
        else {
            warning("record \"", desc, "\" contains no sequence")
            seq <- ""
        }
        list(desc = desc, seq = seq)
    })
}

