/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.impl.NativeLibLoader;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.media.opengl.GLDrawableFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JOGLAppletLauncher
extends Applet {
    private static final NativeLibInfo[] allNativeLibInfo;
    private NativeLibInfo nativeLibInfo;
    private String[] nativeLibNames;
    private Applet subApplet;
    private String subAppletClassName;
    private String subAppletDisplayName;
    private String subAppletImageName;
    private String installDirectory;
    private JPanel loaderPanel = new JPanel(new BorderLayout());
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private boolean isInitOk = false;
    private boolean firstStart = true;
    private boolean joglStarted = false;
    private boolean haveJOAL = false;
    private static final String JRE_PREFIX = "deployment.javapi.jre.";
    private static final String NODDRAW_PROP = "-Dsun.java2d.noddraw=true";
    private static final String DONT_ASK = ".dont_ask";

    private static String md2Hash(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD2");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public void init() {
        this.subAppletClassName = this.getParameter("subapplet.classname");
        if (this.subAppletClassName == null) {
            this.displayError("Init failed : Missing subapplet.classname argument");
            return;
        }
        this.subAppletDisplayName = this.getParameter("subapplet.displayname");
        if (this.subAppletDisplayName == null) {
            this.subAppletDisplayName = "Applet";
        }
        this.subAppletImageName = this.getParameter("subapplet.image");
        this.initLoaderLayout();
        this.validate();
        String string = this.getCodeBase().toExternalForm();
        String string2 = string.substring(string.indexOf(":") + 3);
        this.installDirectory = string2.replace(':', '_').replace('.', '_').replace('/', '_').replace('~', '_') + JOGLAppletLauncher.md2Hash(this.getParameter("archive"));
        String string3 = System.getProperty("os.name");
        String string4 = System.getProperty("os.arch");
        if (this.checkOSAndArch(string3, string4)) {
            this.isInitOk = true;
        } else {
            this.displayError("Init failed : Unsupported os / arch ( " + string3 + " / " + string4 + " )");
        }
    }

    private void displayMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOGLAppletLauncher.this.progressBar.setString(string);
            }
        });
    }

    private void displayError(final String string) {
        System.err.println(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOGLAppletLauncher.this.progressBar.setString("Error : " + string);
            }
        });
    }

    private void setProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOGLAppletLauncher.this.progressBar.setValue(n);
            }
        });
    }

    private void initLoaderLayout() {
        this.setLayout(new BorderLayout());
        this.progressBar.setBorderPainted(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Loading...");
        boolean bl = false;
        ImageIcon imageIcon = null;
        if (this.subAppletImageName != null) {
            try {
                imageIcon = new ImageIcon(new URL(this.subAppletImageName));
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        if (bl) {
            this.add((Component)this.loaderPanel, "South");
            this.loaderPanel.add((Component)new JLabel(imageIcon), "Center");
            this.loaderPanel.add((Component)this.progressBar, "South");
        } else {
            this.add((Component)this.loaderPanel, "South");
            this.loaderPanel.add((Component)this.progressBar, "Center");
        }
    }

    public void start() {
        if (this.isInitOk) {
            if (this.firstStart) {
                this.firstStart = false;
                String string = System.getProperty("user.home");
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    classLoader.loadClass("javax.media.opengl.GL");
                    Package package_ = Package.getPackage("javax.media.opengl");
                    String string2 = string + File.separator + ".jogl_ext" + File.separator + this.installDirectory + File.separator + package_.getImplementationVersion().replace(':', '_');
                    final File file = new File(string2);
                    Thread thread = new Thread(){

                        public void run() {
                            JOGLAppletLauncher.this.refreshJOGL(file);
                        }
                    };
                    thread.setPriority(4);
                    thread.start();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Unable to load javax.media.opengl package");
                    System.exit(0);
                }
            } else if (this.joglStarted) {
                this.checkNoDDrawAndUpdateDeploymentProperties();
                this.subApplet.start();
            }
        }
    }

    public void stop() {
        if (this.subApplet != null) {
            this.subApplet.stop();
        }
    }

    public void destroy() {
        if (this.subApplet != null) {
            this.subApplet.destroy();
        }
    }

    public Applet getSubApplet() {
        return this.subApplet;
    }

    private boolean checkOSAndArch(String string, String string2) {
        for (int i = 0; i < allNativeLibInfo.length; ++i) {
            NativeLibInfo nativeLibInfo = allNativeLibInfo[i];
            if (!nativeLibInfo.matchesOSAndArch(string, string2)) continue;
            this.nativeLibInfo = nativeLibInfo;
            return true;
        }
        return false;
    }

    private boolean getBooleanParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return false;
        }
        return !string2.toLowerCase().equals("false");
    }

    private void checkNoDDrawAndUpdateDeploymentProperties() {
        if (this.getBooleanParameter("jogl.disable.noddraw.check")) {
            return;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && !"true".equalsIgnoreCase(System.getProperty("sun.java2d.noddraw"))) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            JOGLAppletLauncher.this.updateDeploymentPropertiesImpl();
                        }
                    });
                }
                catch (Exception exception) {}
            } else {
                this.updateDeploymentPropertiesImpl();
            }
        }
    }

    private void updateDeploymentPropertiesImpl() {
        String string = System.getProperty("user.home");
        File file = new File(string + File.separator + ".jogl_ext" + File.separator + DONT_ASK);
        if (file.exists()) {
            return;
        }
        int n = 0;
        if (!this.getBooleanParameter("jogl.silent.noddraw.check")) {
            n = JOptionPane.showOptionDialog(null, "For best robustness of JOGL applets on Windows,\nwe recommend disabling Java2D's use of DirectDraw.\nThis setting will affect all applets, but is unlikely\nto slow other applets down significantly. May we update\nyour deployment.properties to turn off DirectDraw for\napplets? You can change this back later if necessary\nusing the Java Control Panel, Java tab, under Java\nApplet Runtime Settings.", "Update deployment.properties?", 1, 3, null, new Object[]{"Yes", "No", "No, Don't Ask Again"}, "Yes");
        }
        if (n < 0 || n == 1) {
            return;
        }
        if (n == 2) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            String string2;
            String string3;
            File file2 = new File(System.getProperty("user.home") + File.separator + "Application Data/Sun/Java/Deployment");
            if (!file2.exists()) {
                return;
            }
            File file3 = new File(file2, "deployment.properties");
            if (!file3.exists()) {
                return;
            }
            Properties properties = new Properties();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file3));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
            HashSet<String> hashSet = new HashSet<String>();
            Object object = properties.keySet().iterator();
            while (object.hasNext()) {
                int n2;
                string3 = (String)object.next();
                if (!string3.startsWith(JRE_PREFIX) || (n2 = string3.lastIndexOf(".")) < 0 || n2 <= JRE_PREFIX.length()) continue;
                string2 = string3.substring(JRE_PREFIX.length(), n2);
                hashSet.add(string2);
            }
            hashSet.add(System.getProperty("java.version"));
            object = hashSet.iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                String string4 = JRE_PREFIX + string3 + ".args";
                string2 = properties.getProperty(string4);
                if (string2 == null) {
                    string2 = NODDRAW_PROP;
                } else if (string2.indexOf(NODDRAW_PROP) < 0) {
                    string2 = string2 + " " + NODDRAW_PROP;
                }
                properties.setProperty(string4, string2);
            }
            object = new BufferedOutputStream(new FileOutputStream(file3));
            properties.store((OutputStream)object, null);
            ((OutputStream)object).close();
            if (!this.getBooleanParameter("jogl.silent.noddraw.check")) {
                JOptionPane.showMessageDialog(null, "For best robustness, we recommend you now exit and\nrestart your web browser. (Note: clicking \"OK\" will\nnot exit your browser.)", "Browser Restart Recommended", 1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void refreshJOGL(File file) {
        String[] stringArray;
        try {
            stringArray = Class.forName(this.subAppletClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.displayError("Start failed : class not found : " + this.subAppletClassName);
            return;
        }
        if (!file.exists() && !file.mkdirs()) {
            this.displayError("Unable to create directories for target: " + file);
            return;
        }
        try {
            stringArray = Class.forName("net.java.games.joal.AL", false, this.getClass().getClassLoader());
            this.haveJOAL = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[]{this.nativeLibInfo.formatNativeJarName("jogl-natives-{0}.jar"), this.nativeLibInfo.formatNativeJarName("gluegen-rt-natives-{0}.jar"), this.haveJOAL ? this.nativeLibInfo.formatNativeJarName("joal-natives-{0}.jar") : null};
        for (int i = 0; i < stringArray.length; ++i) {
            URLConnection uRLConnection;
            String string = stringArray[i];
            if (string == null) continue;
            String string2 = this.getCodeBase().toExternalForm() + string;
            try {
                URL uRL = new URL(string2);
                uRLConnection = uRL.openConnection();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.displayError("Couldn't access the native lib URL : " + string2);
                return;
            }
            long l = this.getTimestamp(file, string, uRLConnection.getLastModified());
            if (l == uRLConnection.getLastModified()) continue;
            this.displayMessage("Updating local version of the native libraries");
            File file2 = new File(file, string);
            try {
                this.saveNativesJarLocally(file2, uRLConnection);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.displayError("Unable to install the native file locally");
                return;
            }
            try {
                Object object;
                int n;
                JarFile jarFile = new JarFile(file2);
                if (!this.findNativeEntries(jarFile)) {
                    this.displayError("native libraries not found in jar file");
                    return;
                }
                byte[] byArray = new byte[8192];
                for (n = 0; n < this.nativeLibNames.length; ++n) {
                    object = jarFile.getJarEntry(this.nativeLibNames[n]);
                    if (object == null) {
                        this.displayError("error looking up jar entry " + this.nativeLibNames[n]);
                        return;
                    }
                    if (this.checkNativeCertificates(jarFile, (JarEntry)object, byArray)) continue;
                    this.displayError("Native library " + this.nativeLibNames[n] + " isn't properly signed or has other errors");
                    return;
                }
                this.setProgress(0);
                for (n = 0; n < this.nativeLibNames.length; ++n) {
                    this.displayMessage("Installing native files from " + string);
                    if (!this.installFile(file, jarFile, this.nativeLibNames[n], byArray)) {
                        return;
                    }
                    int n2 = 100 * (n + 1) / this.nativeLibNames.length;
                    this.setProgress(n2);
                }
                jarFile.close();
                file2.delete();
                try {
                    File file3 = new File(file, this.getTimestampFileName(string));
                    file3.delete();
                    object = new BufferedWriter(new FileWriter(file3));
                    ((Writer)object).write("" + uRLConnection.getLastModified());
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                    continue;
                }
                catch (Exception exception) {
                    this.displayError("Error writing time stamp for native libraries");
                    return;
                }
            }
            catch (Exception exception) {
                this.displayError("Error opening jar file " + file2.getName() + " for reading");
                return;
            }
        }
        this.loadNativesAndStart(file);
    }

    private String getTimestampFileName(String string) {
        return "timestamp-" + string.replace('.', '-');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTimestamp(File file, String string, long l) {
        try {
            String string2 = this.getTimestampFileName(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(file, string2)));
            try {
                StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(48, 57);
                streamTokenizer.wordChars(45, 45);
                streamTokenizer.nextToken();
                String string3 = streamTokenizer.sval;
                if (string3 != null) {
                    long l2 = Long.parseLong(string3);
                    return l2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l != 0L) return 0L;
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNativesJarLocally(File file, URLConnection uRLConnection) throws IOException {
        FilterOutputStream filterOutputStream = null;
        InputStream inputStream = null;
        this.displayMessage("Downloading native library");
        this.setProgress(0);
        try {
            int n;
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n2 = uRLConnection.getContentLength();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            int n3 = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                int n4 = 100 * (n3 += n) / n2;
                this.setProgress(n4);
            }
            filterOutputStream.close();
            inputStream.close();
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean findNativeEntries(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!this.nativeLibInfo.matchesNativeLib(jarEntry.getName())) continue;
            arrayList.add(jarEntry.getName());
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        this.nativeLibNames = arrayList.toArray(new String[0]);
        return true;
    }

    private boolean checkNativeCertificates(JarFile jarFile, JarEntry jarEntry, byte[] byArray) {
        try {
            int n;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n2 = (int)jarEntry.getSize();
            while ((n = inputStream.read(byArray)) > 0) {
            }
            inputStream.close();
            Certificate[] certificateArray = jarEntry.getCertificates();
            Certificate[] certificateArray2 = GLDrawableFactory.class.getProtectionDomain().getCodeSource().getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return false;
            }
            int n3 = 0;
            block3: for (int i = 0; i < certificateArray2.length; ++i) {
                for (int j = 0; j < certificateArray.length; ++j) {
                    if (!certificateArray[j].equals(certificateArray2[i])) continue;
                    ++n3;
                    continue block3;
                }
            }
            return n3 == certificateArray2.length;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean installFile(File file, JarFile jarFile, String string, byte[] byArray) {
        try {
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                this.displayError("Error finding native library " + string);
                return false;
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            int n = (int)jarEntry.getSize();
            BufferedOutputStream bufferedOutputStream = null;
            File file2 = new File(file, string);
            boolean bl = false;
            try {
                bl = file2.exists();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            catch (Exception exception) {
                if (bl) {
                    return true;
                }
                this.displayError("Error opening file " + string + " for writing");
                return false;
            }
            try {
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                this.displayError("Error writing file " + string + " to disk");
                iOException.printStackTrace();
                file2.delete();
                return false;
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError("Error writing file " + string + " to disk");
            return false;
        }
    }

    private void loadNativesAndStart(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block16: {
                    JOGLAppletLauncher.this.displayMessage("Loading native libraries");
                    NativeLibLoader.disableLoading();
                    com.sun.gluegen.runtime.NativeLibLoader.disableLoading();
                    JOGLAppletLauncher.this.loadLibrary(file, "gluegen-rt");
                    Class<?> clazz = null;
                    if (JOGLAppletLauncher.this.nativeLibInfo.mayNeedDRIHack()) {
                        try {
                            clazz = Class.forName("com.sun.opengl.impl.x11.DRIHack");
                            clazz.getMethod("begin", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    JOGLAppletLauncher.this.loadLibrary(file, "jogl");
                    if (JOGLAppletLauncher.this.nativeLibInfo.mayNeedDRIHack()) {
                        try {
                            clazz.getMethod("end", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (!JOGLAppletLauncher.this.nativeLibInfo.isMacOS()) {
                        try {
                            System.loadLibrary("jawt");
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (unsatisfiedLinkError.getMessage().indexOf("already loaded") != -1) break block16;
                            JOGLAppletLauncher.this.displayError("Unable to load JAWT");
                            throw unsatisfiedLinkError;
                        }
                    }
                }
                JOGLAppletLauncher.this.loadLibrary(file, "jogl_awt");
                if (JOGLAppletLauncher.this.haveJOAL) {
                    Object object;
                    try {
                        object = Class.forName("net.java.games.joal.impl.NativeLibLoader");
                        ((Class)object).getMethod("disableLoading", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    object = System.getProperty("java.library.path");
                    String string = file.getAbsolutePath();
                    boolean bl = false;
                    if (object == null) {
                        object = string;
                        bl = true;
                    } else if (((String)object).indexOf(string) < 0) {
                        object = (String)object + File.pathSeparator + string;
                        bl = true;
                    }
                    if (bl) {
                        System.setProperty("java.library.path", (String)object);
                    }
                    JOGLAppletLauncher.this.loadLibrary(file, "joal_native");
                }
                JOGLAppletLauncher.this.displayMessage("Starting applet " + JOGLAppletLauncher.this.subAppletDisplayName);
                JOGLAppletLauncher.this.startSubApplet();
            }
        });
    }

    private void loadLibrary(File file, String string) {
        String string2 = this.nativeLibInfo.getNativeLibName(string);
        try {
            System.load(new File(file, string2).getPath());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            throw unsatisfiedLinkError;
        }
    }

    private void startSubApplet() {
        try {
            this.subApplet = (Applet)Class.forName(this.subAppletClassName).newInstance();
            this.subApplet.setStub(new AppletStubProxy());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            this.displayError("Class not found (" + this.subAppletClassName + ")");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.displayError("Unable to start " + this.subAppletDisplayName);
            return;
        }
        this.add((Component)this.subApplet, "Center");
        try {
            this.subApplet.init();
            this.remove(this.loaderPanel);
            this.validate();
            this.checkNoDDrawAndUpdateDeploymentProperties();
            this.subApplet.start();
            this.joglStarted = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        allNativeLibInfo = new NativeLibInfo[]{new NativeLibInfo("win", "x86", "windows-i586", "", ".dll"), new NativeLibInfo("win", "amd64", "windows-amd64", "", ".dll"), new NativeLibInfo("win", "x86_64", "windows-amd64", "", ".dll"), new NativeLibInfo("mac", "ppc", "macosx-ppc", "lib", ".jnilib"), new NativeLibInfo("mac", "i386", "macosx-universal", "lib", ".jnilib"), new NativeLibInfo("linux", "i386", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "x86", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "amd64", "linux-amd64", "lib", ".so"), new NativeLibInfo("linux", "x86_64", "linux-amd64", "lib", ".so"), new NativeLibInfo("sunos", "sparc", "solaris-sparc", "lib", ".so"), new NativeLibInfo("sunos", "sparcv9", "solaris-sparcv9", "lib", ".so"), new NativeLibInfo("sunos", "x86", "solaris-i586", "lib", ".so"), new NativeLibInfo("sunos", "amd64", "solaris-amd64", "lib", ".so"), new NativeLibInfo("sunos", "x86_64", "solaris-amd64", "lib", ".so")};
    }

    class AppletStubProxy
    implements AppletStub {
        AppletStubProxy() {
        }

        public boolean isActive() {
            return JOGLAppletLauncher.this.isActive();
        }

        public URL getDocumentBase() {
            return JOGLAppletLauncher.this.getDocumentBase();
        }

        public URL getCodeBase() {
            return JOGLAppletLauncher.this.getCodeBase();
        }

        public String getParameter(String string) {
            return JOGLAppletLauncher.this.getParameter(string);
        }

        public AppletContext getAppletContext() {
            return JOGLAppletLauncher.this.getAppletContext();
        }

        public void appletResize(int n, int n2) {
            JOGLAppletLauncher.this.resize(n, n2);
        }
    }

    private static class NativeLibInfo {
        private String osName;
        private String osArch;
        private String osNameAndArchPair;
        private String nativePrefix;
        private String nativeSuffix;

        public NativeLibInfo(String string, String string2, String string3, String string4, String string5) {
            this.osName = string;
            this.osArch = string2;
            this.osNameAndArchPair = string3;
            this.nativePrefix = string4;
            this.nativeSuffix = string5;
        }

        public boolean matchesOSAndArch(String string, String string2) {
            return string.toLowerCase().startsWith(this.osName) && (this.osArch == null || string2.toLowerCase().equals(this.osArch));
        }

        public boolean matchesNativeLib(String string) {
            return string.toLowerCase().endsWith(this.nativeSuffix);
        }

        public String formatNativeJarName(String string) {
            return MessageFormat.format(string, this.osNameAndArchPair);
        }

        public String getNativeLibName(String string) {
            return this.nativePrefix + string + this.nativeSuffix;
        }

        public boolean isMacOS() {
            return this.osName.equals("mac");
        }

        public boolean mayNeedDRIHack() {
            return !this.isMacOS() && !this.osName.equals("win");
        }
    }
}

