/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.geometry.spline;

import no.geosoft.cc.geometry.spline.BezierSpline;
import no.geosoft.cc.geometry.spline.CatmullRomSpline;
import no.geosoft.cc.geometry.spline.CubicSpline;
import no.geosoft.cc.geometry.spline.Spline;

public class SplineFactory {
    public static double[] createBezier(double[] dArray, int n) {
        BezierSpline bezierSpline = new BezierSpline(dArray, n);
        return ((Spline)bezierSpline).generate();
    }

    public static double[] createCubic(double[] dArray, int n) {
        CubicSpline cubicSpline = new CubicSpline(dArray, n);
        return ((Spline)cubicSpline).generate();
    }

    public static double[] createCatmullRom(double[] dArray, int n) {
        CatmullRomSpline catmullRomSpline = new CatmullRomSpline(dArray, n);
        return ((Spline)catmullRomSpline).generate();
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, -1.0, 0.0, 10.0, 0.0, 0.0};
        double[] dArray2 = SplineFactory.createBezier(dArray, 20);
        double[] dArray3 = SplineFactory.createCubic(dArray, 20);
        double[] dArray4 = SplineFactory.createCatmullRom(dArray, 20);
        System.out.println("-- Bezier");
        int n = 0;
        while (n < dArray2.length) {
            System.out.println(dArray2[n] + "," + dArray2[n + 1] + "," + dArray2[n + 2]);
            n += 3;
        }
        System.out.println("-- Cubic");
        int n2 = 0;
        while (n2 < dArray3.length) {
            System.out.println(dArray3[n2] + "," + dArray3[n2 + 1] + "," + dArray3[n2 + 2]);
            n2 += 3;
        }
        System.out.println("-- Catmull-Rom");
        int n3 = 0;
        while (n3 < dArray4.length) {
            System.out.println(dArray4[n3] + "," + dArray4[n3 + 1] + "," + dArray4[n3 + 2]);
            n3 += 3;
        }
    }
}

