/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.Command;
import commandtools.PackageConstants;
import commandtools.Parameter;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class AbstractCommand
implements Command {
    protected String name;
    protected static Logger log = Logger.getLogger("general_debug");
    protected Properties resultProperties = new Properties();
    private List<Command> parameters = new ArrayList<Command>();

    public AbstractCommand(String name) {
        this.name = name;
    }

    @Override
    public void addParameter(Command command) {
        this.parameters.add(command);
    }

    @Override
    public boolean checkParameterNames() {
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (this.isAllowedParameterName(this.getParameterName(i))) continue;
            log.warning("Bad parameter name found: " + this.getParameterName(i));
            return false;
        }
        return true;
    }

    @Override
    public String getShortHelpText() {
        return "Sorry, short help of this command not yet implemented";
    }

    @Override
    public String getLongHelpText() {
        return "Sorry, long help of this command not yet implemented";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.size();
    }

    @Override
    public Command getParameter(int n) {
        assert (n < this.getParameterCount());
        return this.parameters.get(n);
    }

    @Override
    public Command getParameter(String name) {
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!this.getParameterName(i).equals(name)) continue;
            return this.getParameter(i);
        }
        return null;
    }

    @Override
    public Properties getResultProperties() {
        return this.resultProperties;
    }

    @Override
    public String getParameterName(int n) {
        return this.parameters.get(n).getName();
    }

    @Override
    public boolean isAllowedParameterName(String name) {
        return true;
    }

    public int parse(String paramName, int defaultValue) throws NumberFormatException {
        StringParameter param = (StringParameter)this.getParameter(paramName);
        if (param == null) {
            return defaultValue;
        }
        return Integer.parseInt(param.getValue());
    }

    public double parse(String paramName, double defaultValue) throws NumberFormatException {
        StringParameter param = (StringParameter)this.getParameter(paramName);
        if (param == null) {
            return defaultValue;
        }
        return Double.parseDouble(param.getValue());
    }

    public boolean parse(String paramName, boolean defaultValue) throws ParsingException {
        StringParameter param = (StringParameter)this.getParameter(paramName);
        if (param == null) {
            return defaultValue;
        }
        return param.parseBoolean();
    }

    public String parse(String paramName, String defaultValue) throws NumberFormatException {
        StringParameter param = (StringParameter)this.getParameter(paramName);
        if (param == null) {
            return defaultValue;
        }
        return param.getValue();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        if (this.getParameterCount() > 0) {
            buf.append(" ");
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            Command subCommand = this.getParameter(i);
            if (subCommand instanceof Parameter) {
                buf.append(((Object)subCommand).toString());
                buf.append(" ");
                continue;
            }
            buf.append(((Object)subCommand).toString());
            buf.append(PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    @Override
    public Vector<String> toStringVector() {
        Vector<String> result = new Vector<String>();
        String toAdd = this.getName();
        if (this.getParameterCount() > 0) {
            toAdd = toAdd + " ";
        }
        if (toAdd.equals("composite ")) {
            toAdd = "";
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            Command subCommand = this.getParameter(i);
            toAdd = toAdd + ((Object)subCommand).toString();
            if (subCommand instanceof Parameter) {
                toAdd = toAdd + " ";
                continue;
            }
            result.add(toAdd);
            toAdd = new String();
        }
        return result;
    }
}

