/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.PackageConstants;
import generaltools.ParsingException;
import java.util.Properties;
import java.util.logging.Logger;

public class InterpreterTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    public static String replaceEnvironmentVariables(String text, Properties properties) throws ParsingException {
        StringBuffer buf = new StringBuffer(text);
        int pc = 0;
        while (pc + 1 < buf.length() && buf.charAt(pc) != PackageConstants.COMMENT_CHAR) {
            int pc2 = pc;
            boolean found = false;
            if (buf.charAt(pc) == '$' && buf.charAt(pc + 1) == '{') {
                for (pc2 = pc + 2; pc2 < buf.length(); ++pc2) {
                    if (buf.charAt(pc2) != '}') continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new ParsingException("Could not find closing bracket for environment variable at position " + (pc + 1) + " in text " + text);
                }
                String varName = buf.substring(pc + 2, ++pc2 - 1);
                String varContent = null;
                if (properties != null) {
                    varContent = properties.getProperty(varName);
                }
                if (varContent == null) {
                    varContent = System.getenv(varName);
                }
                if (varContent == null) {
                    throw new ParsingException("Undefined variable: " + varName);
                }
                buf.replace(pc, pc2, varContent);
                log.finest("Replaced " + pc + " " + pc2 + " " + varContent);
            }
            ++pc;
        }
        return buf.toString();
    }
}

