/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class AdjacencyTools {
    private static List<Integer> findConnectedSet(boolean[][] adjacencyMatrix, int n) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(new Integer(n));
        boolean isOk = true;
        do {
            isOk = true;
            block1: for (int i = 0; i < adjacencyMatrix.length; ++i) {
                Integer newI;
                if (i == n || result.contains(newI = new Integer(i))) continue;
                for (int j = 0; j < result.size(); ++j) {
                    int testNode = (Integer)result.get(j);
                    if (!adjacencyMatrix[testNode][i]) continue;
                    result.add(newI);
                    isOk = false;
                    continue block1;
                }
            }
        } while (!isOk);
        return result;
    }

    public static List<List<Integer>> findConnectedSets(boolean[][] adjacencyMatrix) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        for (int i = 0; i < adjacencyMatrix.length; ++i) {
            Integer newN = new Integer(i);
            if (AdjacencyTools.contains(result, newN)) continue;
            List<Integer> newClique = AdjacencyTools.findConnectedSet(adjacencyMatrix, i);
            result.add(newClique);
        }
        return result;
    }

    private static boolean contains(List<List<Integer>> lists, Integer n) {
        for (int i = 0; i < lists.size(); ++i) {
            if (!lists.get(i).contains(n)) continue;
            return true;
        }
        return false;
    }

    public static void writeMatrix(PrintStream ps, boolean[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                if (matrix[i][j]) {
                    ps.print("1 ");
                    continue;
                }
                ps.print("0 ");
            }
            ps.println("");
        }
    }

    public static void writeGroup(PrintStream ps, List<Integer> group) {
        for (int i = 0; i < group.size(); ++i) {
            ps.print("" + group.get(i) + " ");
        }
    }

    public static void writeGroups(PrintStream ps, List<List<Integer>> groups) {
        for (int i = 0; i < groups.size(); ++i) {
            AdjacencyTools.writeGroup(ps, groups.get(i));
            ps.println();
        }
    }
}

