/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerArrayMaxDifferentConstraint;
import graphtools.IntegerArraySumConstraint;
import graphtools.IntegerPermutator;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.Test;

public class IntegerArrayGenerator
implements IntegerPermutator {
    private int[] maxNumbers;
    private int[] numbers;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();
    private boolean initial = false;

    public IntegerArrayGenerator() {
    }

    public IntegerArrayGenerator(IntegerArrayGenerator other) {
        this.copy(other);
    }

    public void copy(IntegerArrayGenerator other) {
        int i;
        if (this.maxNumbers == null || this.maxNumbers.length != other.maxNumbers.length) {
            this.maxNumbers = new int[other.maxNumbers.length];
        }
        if (this.numbers == null || this.numbers.length != other.numbers.length) {
            this.numbers = new int[other.numbers.length];
        }
        for (i = 0; i < this.size(); ++i) {
            this.maxNumbers[i] = other.maxNumbers[i];
            this.numbers[i] = other.numbers[i];
        }
        this.initial = other.initial;
        this.constraints = new ArrayList<IntegerArrayConstraint>();
        for (i = 0; i < other.constraints.size(); ++i) {
            this.constraints.add(other.constraints.get(i));
        }
    }

    @Override
    public Object clone() {
        IntegerArrayGenerator result = new IntegerArrayGenerator(this);
        return result;
    }

    public IntegerArrayGenerator(int[] maxNumbers) {
        assert (maxNumbers != null && maxNumbers.length > 0);
        this.maxNumbers = maxNumbers;
        this.numbers = new int[maxNumbers.length];
        this.reset();
    }

    public IntegerArrayGenerator(int length, int base) {
        assert (length > 0);
        assert (base > 0);
        this.maxNumbers = new int[length];
        for (int i = 0; i < length; ++i) {
            this.maxNumbers[i] = base;
        }
        this.numbers = new int[this.maxNumbers.length];
        this.reset();
        assert (this.numbers.length == length);
        assert (this.validate());
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        this.constraints.add(constraint);
        this.reset();
        assert (this.validate());
    }

    public int[] getMaxNumbers() {
        return this.maxNumbers;
    }

    @Override
    public BigInteger getTotal() {
        BigDecimal result = BigDecimal.ONE;
        for (int i = 0; i < this.numbers.length; ++i) {
            result = result.multiply(new BigDecimal((double)this.maxNumbers[i]));
        }
        return result.toBigInteger();
    }

    @Test(groups={"new"})
    public void testGetTotal() {
        IntegerArrayGenerator gen = new IntegerArrayGenerator(2, 3);
        BigInteger nine = new BigDecimal("9").toBigInteger();
        assert (gen.getTotal().equals(nine));
        gen.next();
        assert (gen.getTotal().equals(nine));
    }

    private void printVec(PrintStream ps, int[] x) {
        for (int n : x) {
            ps.print("" + n + " ");
        }
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.maxNumbers.length; ++i) {
            if (this.numbers[i] + 1 >= this.maxNumbers[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inc() {
        assert (this.hasNext());
        block0: while (this.hasNext()) {
            for (int pc = 0; pc < this.numbers.length; ++pc) {
                int n = pc;
                this.numbers[n] = this.numbers[n] + 1;
                if (this.numbers[pc] >= this.maxNumbers[pc]) {
                    this.numbers[pc] = 0;
                    continue;
                }
                if (!this.validate()) continue block0;
                return true;
            }
        }
        return false;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    @Override
    public int[] get() {
        if (!this.validate()) {
            System.out.println("IntegerArrayGenerator: Numbers do not validate: ");
            this.printVec(System.out, this.numbers);
            return null;
        }
        int[] result = new int[this.numbers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.numbers[i];
        }
        return result;
    }

    @Override
    public int[] next() {
        boolean check = this.inc();
        if (!check) {
            return null;
        }
        return this.get();
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.numbers.length; ++i) {
            this.numbers[i] = 0;
        }
        while (!this.validate() && this.hasNext()) {
            System.out.println("IntegerArrayGenerator.result: Sofar could not find validating reset position:");
            this.printVec(System.out, this.numbers);
            this.inc();
        }
        if (!this.validate()) {
            System.out.println("Could not find validating reset position:");
            this.printVec(System.out, this.numbers);
            assert (false);
        }
    }

    @Override
    public int size() {
        return this.numbers.length;
    }

    public long totalNumber() {
        long result = 1L;
        for (int a : this.maxNumbers) {
            result *= (long)a;
        }
        return result;
    }

    @Override
    public boolean validate() {
        boolean check1;
        if (this.numbers.length == 0) {
            return true;
        }
        boolean bl = check1 = this.maxNumbers != null && this.numbers != null && this.maxNumbers.length > 0 && this.maxNumbers.length == this.numbers.length && this.numbers[0] >= 0;
        if (!check1) {
            return false;
        }
        if (this.constraints == null) {
            return false;
        }
        for (IntegerArrayConstraint constraint : this.constraints) {
            if (constraint.validate(this.numbers)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.numbers.length; ++i) {
            buf.append("" + this.numbers[i] + "(" + this.maxNumbers[i] + ") ");
        }
        return buf.toString();
    }

    @Test(groups={"new"})
    public void testIntegerArrayGenerator() {
        String methodName = "testIntegerArrayGenerator";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayGenerator gen = new IntegerArrayGenerator(2, 3);
        int count = 0;
        System.out.println("Results of integer Array generator");
        do {
            int[] x = gen.get();
            assert (x != null);
            this.printVec(System.out, x);
            System.out.println();
            ++count;
        } while (gen.hasNext() && gen.next() != null);
        System.out.println("gen has no successor: " + gen);
        assert (count == 9);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerArrayGenerator2() {
        String methodName = "testIntegerArrayGenerator2";
        System.out.println(TestTools.generateMethodHeader(methodName));
        int[] maxNumbers = new int[]{3, 1, 1, 2};
        IntegerArrayGenerator gen = new IntegerArrayGenerator(maxNumbers);
        int count = 0;
        System.out.println("Results of integer Array generator");
        do {
            int[] x = gen.get();
            assert (x != null);
            this.printVec(System.out, x);
            System.out.println();
            ++count;
        } while (gen.hasNext() && gen.next() != null);
        System.out.println("gen has no successor: " + gen);
        assert (count == 6);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerArrayGenerator3() {
        String methodName = "testIntegerArrayGenerator3";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayGenerator gen = new IntegerArrayGenerator(4, 3);
        gen.addConstraint(new IntegerArrayMaxDifferentConstraint(2));
        int count = 0;
        System.out.println("Results of integer Array generator");
        while (gen.hasNext()) {
            int[] x = gen.next();
            System.out.print("" + ++count + " : ");
            this.printVec(System.out, x);
            System.out.println();
        }
        assert (count == 44);
        System.out.println("gen has no successor: " + gen);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int computeSum(int[] a) {
        int s = 0;
        for (int i = 0; i < a.length; ++i) {
            s += a[i];
        }
        return s;
    }

    @Test(groups={"new"})
    public void testIntegerArrayGenerator4() {
        String methodName = "testIntegerArrayGenerator4";
        System.out.println(TestTools.generateMethodHeader(methodName));
        int sum = 3;
        IntegerArrayGenerator gen = new IntegerArrayGenerator(4, 3);
        gen.addConstraint(new IntegerArraySumConstraint(sum));
        int count = 0;
        System.out.println("Results of integer Array generator, sum must always be " + sum);
        while (gen.hasNext()) {
            ++count;
            int[] x = gen.next();
            if (x == null) {
                System.out.println("Could not generate further solutions! Quitting loop.");
                break;
            }
            System.out.print("" + count + " : ");
            int computedSum = this.computeSum(x);
            this.printVec(System.out, x);
            System.out.print(" sum: " + computedSum);
            assert (computedSum == sum);
            System.out.println();
        }
        System.out.println("gen has no successor: " + gen);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

