/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IntegerList
implements Comparable {
    private List<Integer> nodes = new ArrayList<Integer>();
    private Set<Integer> nodeSet = new HashSet<Integer>();

    public IntegerList() {
    }

    public IntegerList(IntegerList orig) {
        for (int i = 0; i < orig.size(); ++i) {
            this.add(orig.get(i));
        }
    }

    public IntegerList(int[] orig) {
        for (int i = 0; i < orig.length; ++i) {
            this.add(orig[i]);
        }
    }

    public void add(int n) {
        this.nodes.add(new Integer(n));
        if (!this.contains(n)) {
            this.nodeSet.add(new Integer(n));
        }
    }

    public void clear() {
        this.nodes = new ArrayList<Integer>();
        this.nodeSet = new HashSet<Integer>();
    }

    public boolean containsAll(IntegerList other) {
        for (int i = 0; i < other.size(); ++i) {
            if (this.contains(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        return this.nodes.get(n);
    }

    public int compareTo(Object obj) {
        if (obj instanceof IntegerList) {
            IntegerList other = (IntegerList)obj;
            if (this.size() < other.size()) {
                return -1;
            }
            if (this.size() > other.size()) {
                return 1;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) < other.get(i)) {
                    return -1;
                }
                if (this.get(i) <= other.get(i)) continue;
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public boolean contains(int n) {
        return this.nodeSet.contains(new Integer(n));
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != n) continue;
            return i;
        }
        return -1;
    }

    public int indexOfSmallest() {
        int smallest = this.get(0);
        int smallestId = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (this.get(i) >= smallest) continue;
            smallest = this.get(i);
            smallestId = i;
        }
        return smallestId;
    }

    public IntegerList rotateToSmallest() {
        assert (this.isUnique());
        int smallest = this.get(this.indexOfSmallest());
        for (int i = 0; i < this.size(); ++i) {
            IntegerList path = this.rotate(i);
            if (path.get(0) != smallest) continue;
            return path;
        }
        assert (false);
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerList) {
            IntegerList other = (IntegerList)obj;
            if (other.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IntegerList reverse() {
        IntegerList result = new IntegerList();
        for (int i = this.size() - 1; i >= 0; --i) {
            result.add(this.get(i));
        }
        return result;
    }

    public IntegerList rotate(int rot) {
        IntegerList result = new IntegerList();
        if (this.size() == 0) {
            return result;
        }
        while (rot < 0) {
            rot += this.size();
        }
        rot %= this.size();
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get((i + rot) % this.size()));
        }
        return result;
    }

    public int size() {
        return this.nodes.size();
    }

    public IntegerList subset(int start, int length) {
        IntegerList result = new IntegerList();
        for (int i = 0; i < length; ++i) {
            result.add(this.get(start + i));
        }
        return result;
    }

    public boolean isUnique() {
        return this.nodes.size() == this.nodeSet.size();
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public String toString() {
        String result = "" + this.size() + "  ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.get(i) + " ";
        }
        return result;
    }
}

