/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import graphtools.IntegerList;
import graphtools.IntegerListList;
import java.util.logging.Logger;

public class PathTools {
    public static Logger log = Logger.getLogger("NanoTiler_debug");

    public static boolean isCyclical(IntegerList path) {
        return path != null && path.size() > 2 && path.get(0) == path.get(path.size() - 1);
    }

    public static boolean isEquivalent(IntegerList path1, IntegerList path2) {
        return path1.equals(path2) || path1.equals(path2.reverse());
    }

    public static boolean isEquivalentCircular(IntegerList path1, IntegerList path2) {
        if (path1.size() != path2.size()) {
            return false;
        }
        if (path1.size() == 0) {
            return true;
        }
        if (path1.equals(path2) || path1.equals(path2.reverse())) {
            return true;
        }
        IntegerList path1Sub = path1;
        IntegerList path2Sub = path2;
        if (path1.size() > 1 && path1.get(0) == path1.get(path1.size() - 1)) {
            path1Sub = path1.subset(0, path1.size() - 1);
            path2Sub = path2.subset(0, path2.size() - 1);
        }
        IntegerList path2Rev = path2.reverse();
        for (int i = 1; i < path1Sub.size(); ++i) {
            IntegerList rotPath = path1Sub.rotate(i);
            rotPath.add(rotPath.get(0));
            if (!rotPath.equals(path2) && !rotPath.equals(path2Rev)) continue;
            return true;
        }
        log.info("The following paths are not equivalent: " + path1.toString() + " " + path2.toString());
        return false;
    }

    public static boolean isSameCircular(IntegerList path1, IntegerList path2) {
        if (path1.size() != path2.size()) {
            return false;
        }
        if (path1.size() == 0) {
            return true;
        }
        if (path1.equals(path2) || path1.equals(path2.reverse())) {
            return true;
        }
        IntegerList path1Sub = path1;
        IntegerList path2Sub = path2;
        if (path1.size() > 1 && path1.get(0) == path1.get(path1.size() - 1)) {
            path1Sub = path1.subset(0, path1.size() - 1);
            path2Sub = path2.subset(0, path2.size() - 1);
        }
        for (int i = 1; i < path1Sub.size(); ++i) {
            IntegerList rotPath = path1Sub.rotate(i);
            rotPath.add(rotPath.get(0));
            if (!rotPath.equals(path2)) continue;
            return true;
        }
        log.info("The following paths are not same (with rotations): " + path1.toString() + " " + path2.toString());
        return false;
    }

    public static boolean containsPair(IntegerList path, int id1, int id2) {
        for (int i = 1; i < path.size(); ++i) {
            if (path.get(i - 1) != id1 || path.get(i) != id2) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverlapping(IntegerList path1, IntegerList path2) {
        for (int i = 1; i < path1.size(); ++i) {
            int id2;
            int id1 = path1.get(i - 1);
            if (!PathTools.containsPair(path2, id1, id2 = path1.get(i))) continue;
            return true;
        }
        return false;
    }

    public static int findEquivalentPath(IntegerListList paths, IntegerList path) {
        for (int i = 0; i < paths.size(); ++i) {
            if (!PathTools.isEquivalent(path, paths.get(i))) continue;
            return i;
        }
        return paths.size();
    }

    public static int findEquivalentCircularPath(IntegerListList paths, IntegerList path) {
        for (int i = 0; i < paths.size(); ++i) {
            if (!PathTools.isEquivalentCircular(path, paths.get(i))) continue;
            return i;
        }
        return paths.size();
    }

    public static IntegerListList getUniquePaths(IntegerListList paths) {
        IntegerListList result = new IntegerListList();
        if (paths == null || paths.size() == 0) {
            return result;
        }
        result.add(paths.get(0));
        for (int i = 1; i < paths.size(); ++i) {
            int id = PathTools.findEquivalentPath(result, paths.get(i));
            if (id < result.size()) continue;
            result.add(paths.get(i));
        }
        return result;
    }

    public static IntegerListList getUniqueCircularPaths(IntegerListList paths) {
        IntegerListList result = new IntegerListList();
        if (paths == null || paths.size() == 0) {
            return result;
        }
        result.add(paths.get(0));
        for (int i = 1; i < paths.size(); ++i) {
            int id = PathTools.findEquivalentCircularPath(result, paths.get(i));
            if (id < result.size()) continue;
            result.add(paths.get(i));
        }
        return result;
    }
}

