/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import graphtools.GraphBase;
import graphtools.IntPair;
import graphtools.IntegerList;
import java.util.ArrayList;
import java.util.List;

public class SimpleGraph
implements GraphBase {
    public static final String NEWLINE = System.getProperty("line.separator");
    boolean[][] matrix;
    int nodeCount;
    int edgeCount;
    List<IntPair> edgeList = new ArrayList<IntPair>();
    List<IntPair>[] edgeArray;

    public SimpleGraph(int n) {
        this.nodeCount = n;
        this.edgeCount = 0;
        this.matrix = new boolean[n][n];
        this.edgeArray = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = false;
            }
            this.edgeArray[i] = new ArrayList<IntPair>(i);
        }
    }

    @Override
    public IntegerList getConnections(int n) {
        IntegerList result = new IntegerList();
        for (int i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[n][i]) continue;
            result.add(i);
        }
        return result;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }

    public int getNodeEdgeCount(int n) {
        return this.edgeArray[n].size();
    }

    @Override
    public IntPair getEdge(int n) {
        return this.edgeList.get(n);
    }

    @Override
    public IntPair getNodeEdge(int edgeNum, int nodeId) {
        return this.edgeArray[nodeId].get(edgeNum);
    }

    @Override
    public boolean isConnected(int n1, int n2) {
        return this.matrix[n1][n2];
    }

    public static boolean isEquivalent(IntPair edge1, IntPair edge2) {
        return edge1.getFirst() == edge2.getFirst() && edge1.getSecond() == edge2.getSecond() || edge1.getFirst() == edge2.getSecond() && edge1.getSecond() == edge2.getFirst();
    }

    @Override
    public int indexOf(IntPair edge) {
        for (int i = 0; i < this.getEdgeCount(); ++i) {
            if (!SimpleGraph.isEquivalent(this.getEdge(i), edge)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int nodeIndexOf(IntPair edge, int node) {
        for (int i = 0; i < this.getNodeEdgeCount(node); ++i) {
            if (!SimpleGraph.isEquivalent(this.getNodeEdge(i, node), edge)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setConnected(int i, int j, boolean status) {
        if (status) {
            if (!this.matrix[i][j]) {
                IntPair newEdge = new IntPair(i, j);
                this.edgeList.add(newEdge);
                this.edgeArray[i].add(newEdge);
                this.edgeArray[j].add(newEdge);
                ++this.edgeCount;
            }
        } else if (this.matrix[i][j]) {
            --this.edgeCount;
            IntPair newEdge = new IntPair(i, j);
            this.edgeList.remove(newEdge);
            if (this.edgeArray[i].contains(newEdge)) {
                this.edgeArray[i].remove(newEdge);
            } else {
                this.edgeArray[i].remove(newEdge.reverse());
            }
            if (this.edgeArray[j].contains(newEdge)) {
                this.edgeArray[j].remove(newEdge);
            } else {
                this.edgeArray[j].remove(newEdge.reverse());
            }
        }
        this.matrix[i][j] = status;
        this.matrix[j][i] = status;
    }

    @Override
    public String toString() {
        String result = "" + this.getNodeCount() + " " + this.getEdgeCount() + NEWLINE;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            for (int j = 0; j < this.getNodeCount(); ++j) {
                result = this.matrix[i][j] ? result + "1 " : result + "0 ";
            }
            result = result + NEWLINE;
        }
        return result;
    }
}

