/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import graphtools.GraphBase;
import graphtools.GraphBaseOrderSet;
import graphtools.IntegerList;
import graphtools.IntegerListList;
import graphtools.SimpleGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SimpleGraphBaseOrderSet
implements GraphBaseOrderSet {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    int nodeCount;
    List graphs = new ArrayList();
    IntegerListList[][] pathMatrix;
    int highestOrder;
    GraphBase graph;

    public SimpleGraphBaseOrderSet(GraphBase graph) {
        this.graph = graph;
        this.nodeCount = graph.getNodeCount();
        this.highestOrder = 1;
        log.fine("Starting SimpleGraphBaseOrderSet(GraphBase graph)! " + this.highestOrder + " " + this.nodeCount);
        this.pathMatrix = new IntegerListList[this.nodeCount][this.nodeCount];
        int countConnected = 0;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            for (int j = 0; j < graph.getNodeCount(); ++j) {
                this.pathMatrix[i][j] = new IntegerListList();
                if (!graph.isConnected(i, j)) continue;
                ++countConnected;
                IntegerList newPath = new IntegerList();
                newPath.add(i);
                newPath.add(j);
                this.pathMatrix[i][j].add(newPath);
                log.fine("Added path to " + i + " " + j + " " + this.pathMatrix[i][j].size());
            }
        }
        log.fine("Overall " + countConnected + " connections defined as paths!");
    }

    public SimpleGraphBaseOrderSet(GraphBase graph, int order) {
        this(graph);
        for (int i = 0; i < order - 1; ++i) {
            this.generateNextOrderGraph();
        }
    }

    @Override
    public void generateNextOrderGraph() {
        SimpleGraph newGraph = new SimpleGraph(this.size());
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                IntegerListList paths;
                if (i == j || (paths = this.getPaths(i, j)) == null) continue;
                for (int m = 0; m < paths.size(); ++m) {
                    IntegerList newPath;
                    int conn;
                    int k;
                    int endNode;
                    IntegerList endConnections;
                    IntegerList path = paths.get(m);
                    if (path == null || path.size() - 1 != this.highestOrder || (endConnections = this.graph.getConnections(endNode = path.get(path.size() - 1))) == null) continue;
                    if (path.size() > 2) {
                        for (k = 0; k < endConnections.size(); ++k) {
                            conn = endConnections.get(k);
                            if (conn != i && path.contains(conn)) continue;
                            newPath = new IntegerList(path);
                            newPath.add(conn);
                            this.pathMatrix[i][conn].add(newPath);
                            if (conn != i) continue;
                            log.fine("Cyclical path found for node " + i);
                        }
                        continue;
                    }
                    for (k = 0; k < endConnections.size(); ++k) {
                        conn = endConnections.get(k);
                        if (conn == i || conn == j) continue;
                        newPath = new IntegerList(path);
                        newPath.add(conn);
                        this.pathMatrix[i][conn].add(newPath);
                    }
                }
            }
        }
        ++this.highestOrder;
    }

    @Override
    public int getHighestOrder() {
        return this.highestOrder;
    }

    @Override
    public int size() {
        return this.nodeCount;
    }

    public IntegerListList getPaths(int n1, int n2) {
        return this.pathMatrix[n1][n2];
    }

    @Override
    public IntegerListList getCyclicalPaths(int node) {
        return this.pathMatrix[node][node];
    }

    public String toString() {
        String result = "";
        result = result + "Cyclical paths:" + NEWLINE;
        for (int i = 0; i < this.pathMatrix.length; ++i) {
            if (this.pathMatrix[i][i].size() <= 0) continue;
            for (int j = 0; j < this.pathMatrix[i][i].size(); ++j) {
                IntegerList path = this.pathMatrix[i][i].get(j);
                result = result + " " + i + ": ";
                for (int k = 0; k < path.size(); ++k) {
                    result = result + path.get(k) + " ";
                }
                result = result + NEWLINE;
            }
        }
        return result;
    }
}

