/*
 * Decompiled with CFR 0.152.
 */
package numerictools;

import generaltools.Randomizer;
import java.util.Random;
import java.util.logging.Logger;
import numerictools.DoubleArrayTools;
import numerictools.OptimizationNDResult;
import numerictools.PotentialND;
import numerictools.PotentialNDOptimizer;
import numerictools.SimpleOptimizationNDResult;

public class MonteCarloOptimizer
implements PotentialNDOptimizer {
    private int iterMax = 10000;
    private double stepWidth = 1.0;
    private double kt = 10.0;
    private boolean minimize = true;
    private Random rand = Randomizer.getInstance();
    public int verboseLevel = 1;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    double computeRandomPosition(double x) {
        return x + 2.0 * (this.rand.nextDouble() - 0.5) * this.stepWidth;
    }

    double[] generateNewPosition(double[] position) {
        double[] newPos = new double[position.length];
        for (int i = 0; i < position.length; ++i) {
            newPos[i] = this.computeRandomPosition(position[i]);
        }
        return newPos;
    }

    public double getKt() {
        return this.kt;
    }

    @Override
    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setIterMax(int n) {
        this.iterMax = n;
    }

    public void setKt(double kt) {
        this.kt = kt;
    }

    public void setStepWidth(double x) {
        this.stepWidth = x;
    }

    @Override
    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    @Override
    public OptimizationNDResult optimize(PotentialND potential, double[] startPos) {
        int dim = startPos.length;
        SimpleOptimizationNDResult result = new SimpleOptimizationNDResult(dim);
        result.bestValue = potential.getValue(startPos);
        result.bestPosition = startPos;
        double[] currentPos = new double[startPos.length];
        System.arraycopy(startPos, 0, currentPos, 0, dim);
        double currentVal = result.bestValue;
        if (this.verboseLevel == 1) {
            this.log.fine("Starting optimization at value and position: " + result.bestValue);
        } else if (this.verboseLevel > 1) {
            this.log.info("Starting optimization at value: " + result.bestValue);
            DoubleArrayTools.writeArray(System.out, startPos);
        }
        for (int iter = 0; iter < this.iterMax; ++iter) {
            double[] newPosition = this.generateNewPosition(currentPos);
            double newVal = potential.getValue(newPosition);
            if (this.minimize && newVal < result.bestValue || !this.minimize && newVal > result.bestValue) {
                result.bestValue = newVal;
                result.bestPosition = newPosition;
                result.stepCount = iter;
                if (this.verboseLevel > 1) {
                    this.log.fine("New best value and position: " + newVal);
                    DoubleArrayTools.writeArray(System.out, newPosition);
                    this.log.fine("Iteration: " + iter + " currently best: " + result);
                }
            }
            double delta = newVal - currentVal;
            if (!this.minimize) {
                delta = -delta;
            }
            if (!(Math.exp(-delta / this.kt) > this.rand.nextDouble())) continue;
            System.arraycopy(newPosition, 0, currentPos, 0, dim);
            currentVal = newVal;
        }
        if (this.verboseLevel > 0) {
            this.log.fine("Finishing optimization at value and position: " + result.bestValue);
            DoubleArrayTools.writeArray(System.out, result.bestPosition);
        }
        return result;
    }
}

