/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;

public class AlignCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "alignxyz";
    private Object3DGraphController controller;
    private String name1;
    private String name2;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;

    public AlignCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        AlignCommand command = new AlignCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.x = this.x;
        command.y = this.y;
        command.z = this.z;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: alignxyz obj1-name obj2-name x y z";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"alignxyz\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " Object1Name Object2Name x y z" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Align command rotates the selected subtree such that objects 1 and 2 point in direction x,y,z." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            if (this.name2 != null && this.name2.length() > 2) {
                this.controller.getGraph().alignObject(this.name1, this.name2, new Vector3D(this.x, this.y, this.z));
            } else {
                this.controller.getGraph().alignOrientation(this.name1);
            }
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 5 && this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        try {
            StringParameter p0 = (StringParameter)this.getParameter(0);
            this.name1 = p0.getValue();
            if (this.getParameterCount() < 2) {
                return;
            }
            StringParameter p1 = (StringParameter)this.getParameter(1);
            this.name2 = p1.getValue();
            StringParameter p2 = (StringParameter)this.getParameter(2);
            this.x = Double.parseDouble(p2.getValue());
            StringParameter p3 = (StringParameter)this.getParameter(3);
            this.y = Double.parseDouble(p3.getValue());
            StringParameter p4 = (StringParameter)this.getParameter(4);
            this.z = Double.parseDouble(p4.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number syntax in command align : " + nfe.getMessage());
        }
    }
}

