/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class CellCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "cell";
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double alpha = 0.0;
    private double beta = 0.0;
    private double gamma = 0.0;
    private Object3DGraphController controller;

    public CellCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        CellCommand command = new CellCommand(this.controller);
        command.a = this.a;
        command.b = this.b;
        command.c = this.c;
        command.alpha = this.alpha;
        command.beta = this.beta;
        command.gamma = this.gamma;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: cell a b c alpha beta gamma";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"cell\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " a b c alpha beta gamma" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Currently not supported." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        this.controller.setCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 6) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter p3 = (StringParameter)this.getParameter(3);
        StringParameter p4 = (StringParameter)this.getParameter(4);
        StringParameter p5 = (StringParameter)this.getParameter(5);
        this.a = Double.parseDouble(p0.getValue());
        this.b = Double.parseDouble(p1.getValue());
        this.c = Double.parseDouble(p2.getValue());
        this.alpha = Math.PI / 180 * Double.parseDouble(p3.getValue());
        this.beta = Math.PI / 180 * Double.parseDouble(p4.getValue());
        this.gamma = Math.PI / 180 * Double.parseDouble(p5.getValue());
    }
}

