/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.objects3d.TorsionLink;

public class GenerateTorsionConstraintCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "gentorsionconstraint";
    private Object3DGraphController controller;
    private String name1;
    private String name2;
    private String name3;
    private String name4;
    private double min = 0.0;
    private double max = 0.0;

    public GenerateTorsionConstraintCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenerateTorsionConstraintCommand command = new GenerateTorsionConstraintCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.name3 = this.name3;
        command.name4 = this.name4;
        command.min = this.min;
        command.max = this.max;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: gentorsionconstraint name1 name2 name3 name4 distmin distmax";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"gentorsionconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " objectname1 objectname2 objectname3 objectname4 distmin distmax" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "Computes torsion angle between v1-v2 and v4-v3 , with v1,..,v4 being the position vectors of specified objects 1 to 4." + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Adds a torsion constraint between four object descriptors. Angle is measured in degree." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            TorsionLink newLink = this.controller.addTorsionConstraint(this.name1, this.name2, this.name3, this.name4, this.min, this.max);
            System.out.println("Added constraint for parameters:" + this.name1 + " " + this.name2 + " " + this.name3 + " " + this.name4 + " " + this.min + " " + this.max + " : " + newLink.toString());
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 6) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter p3 = (StringParameter)this.getParameter(3);
        StringParameter p4 = (StringParameter)this.getParameter(4);
        StringParameter p5 = (StringParameter)this.getParameter(5);
        this.name1 = p0.getValue();
        this.name2 = p1.getValue();
        this.name3 = p2.getValue();
        this.name4 = p3.getValue();
        try {
            this.min = Math.toRadians(Double.parseDouble(p4.getValue()));
            this.max = Math.toRadians(Double.parseDouble(p5.getValue()));
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing number value: " + nfe.getMessage());
        }
    }
}

