/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class LinksCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "links";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String name;
    private String linkType = null;

    public LinksCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        assert (ps != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        LinksCommand command = new LinksCommand(this.ps, this.controller);
        command.name = this.name;
        command.linkType = this.linkType;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: links";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"links\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Links command lists all of the existing links." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        this.ps.println(this.controller.getLinks().toPrettyString(this.linkType));
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter nameParameter = (StringParameter)this.getParameter("name");
        if (nameParameter != null) {
            this.name = nameParameter.getValue();
        }
        if ((nameParameter = (StringParameter)this.getParameter("type")) != null) {
            this.linkType = nameParameter.getValue();
        }
    }
}

