/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class RingFixConstraintsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "ringfixconstraints";
    private Object3DGraphController controller;
    private String[] junctionNames;

    public RingFixConstraintsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        RingFixConstraintsCommand command = new RingFixConstraintsCommand(this.controller);
        command.junctionNames = this.junctionNames;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Generates helix constraints corresponding to a ring with as high symmetry as possible. Correct usage: ringfixconstraints [junctions=subtree1,subtree2,...]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"ringfixconstraints\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.junctionNames == null || this.junctionNames.length == 0) {
            this.junctionNames = new String[1];
            this.junctionNames[0] = this.controller.getGraph().getGraph().getFullName();
        }
        this.controller.generateRingFixConstraints(this.junctionNames);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter p = (StringParameter)this.getParameter("junctions");
        if (p != null) {
            this.junctionNames = p.getValue().split(",");
        }
    }
}

