/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.logging.Level;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;

public class StericCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "steric";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String subcom = "";
    private Level verboseLevel = Level.INFO;
    private double distance = 0.5;

    public StericCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        StericCommand command = new StericCommand(this.ps, this.controller);
        command.ps = this.ps;
        command.controller = this.controller;
        command.subcom = this.subcom;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Returns number of non-hydrogen atom collisions. Correct usage: steric [d=COLLISION_DISTANCE]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"steric\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " d=COLLISION_DISTANCE" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Returns number of non-hydrogen atom collisions." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        int numCollisions = this.controller.getGraph().countAtomCollisions(this.distance, this.verboseLevel);
        this.ps.println("Number of collisions: " + numCollisions);
        this.resultProperties.setProperty("atom_collisions", "" + numCollisions);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter distPar = (StringParameter)this.getParameter("d");
        try {
            if (distPar != null) {
                this.distance = Double.parseDouble(distPar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing distance value: " + nfe.getMessage());
        }
    }
}

