/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.PrintStream;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SuperposableCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "superposable";
    private Object3DGraphController controller;
    private PrintStream ps;
    private double rms = 3.0;
    private String subcom = "";

    public SuperposableCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
        this.ps = ps;
    }

    @Override
    public Object cloneDeep() {
        SuperposableCommand command = new SuperposableCommand(this.ps, this.controller);
        command.ps = this.ps;
        command.controller = this.controller;
        command.rms = this.rms;
        command.subcom = this.subcom;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: superposable [junctions|kl|strands]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"superposable\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " FILENAME" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     superposable command list properties of all versus all superposition of strands, junctions or kissing loops." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        if (this.subcom.equals("junctions")) {
            this.controller.getJunctionController().printSuperposableJunctions(this.rms, this.ps);
        } else if (this.subcom.equals("kl")) {
            this.controller.getJunctionController().printSuperposableKissingLoops(this.rms, this.ps);
        } else if (this.subcom.equals("strands")) {
            if (this.getParameterCount() < 3) {
                throw new CommandExecutionException("Missing object names! Usage: superposable strands name1 name2");
            }
            try {
                for (int i = 1; i < this.getParameterCount(); ++i) {
                    for (int j = 1; j < i; ++j) {
                        Properties properties;
                        this.resultProperties = properties = this.controller.getGraph().superposeStrands(((StringParameter)this.getParameter(i)).getValue(), ((StringParameter)this.getParameter(j)).getValue());
                        this.ps.println(properties.toString());
                    }
                }
            }
            catch (Object3DGraphControllerException gce) {
                throw new CommandExecutionException(gce.getMessage());
            }
        } else {
            throw new CommandExecutionException("Could not generate superpositions. Use superposable junctions|kl");
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() > 0) {
            StringParameter par1 = (StringParameter)this.getParameter(0);
            this.subcom = par1.getValue();
        }
    }
}

