/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;

public class TwistCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "twist";
    private double a = 0.0;
    private double b = 0.0;
    private double c = 1.0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double alpha = 0.0;
    private String name;
    private Object3DGraphController controller;

    public TwistCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        TwistCommand command = new TwistCommand(this.controller);
        command.a = this.a;
        command.b = this.b;
        command.c = this.c;
        command.x = this.x;
        command.y = this.y;
        command.z = this.z;
        command.alpha = this.alpha;
        command.name = this.name;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: twist alpha rx ry rz [px py pz]  : rotate around axis (rx,ry,rz) and center (px, py, pz) angle angle alpha";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"twist\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " alpha rx ry rz [px py pz]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "        rotate around axis (rx, ry, rz) and center (px, py, pz) angle angle alpha" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        block7: {
            assert (this.controller != null);
            this.prepareReadout();
            Vector3D axis = new Vector3D(this.a, this.b, this.c);
            Vector3D center = new Vector3D(this.x, this.y, this.z);
            if (axis.length() == 0.0) {
                throw new CommandExecutionException("Length of rotation axis must be greater zero!");
            }
            try {
                if (this.getParameterCount() == 7) {
                    this.controller.getGraph().twistSelected(axis, center, this.alpha);
                    break block7;
                }
                if (this.getParameterCount() == 4) {
                    this.controller.getGraph().twistSelected(this.a, this.b, this.c, this.alpha);
                    break block7;
                }
                if (this.getParameterCount() == 5) {
                    this.controller.getGraph().twistSelected(axis, this.name, this.alpha);
                    break block7;
                }
                throw new CommandExecutionException(this.helpOutput());
            }
            catch (Object3DGraphControllerException ce) {
                throw new CommandExecutionException("Error in twist command: " + ce.getMessage());
            }
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 4 && this.getParameterCount() != 7) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter p3 = (StringParameter)this.getParameter(3);
        try {
            this.alpha = Math.PI / 180 * Double.parseDouble(p0.getValue());
            this.a = Double.parseDouble(p1.getValue());
            this.b = Double.parseDouble(p2.getValue());
            this.c = Double.parseDouble(p3.getValue());
            if (this.getParameterCount() == 5) {
                StringParameter p4 = (StringParameter)this.getParameter(4);
                this.name = p4.getValue();
            } else if (this.getParameterCount() == 7) {
                StringParameter p4 = (StringParameter)this.getParameter(4);
                StringParameter p5 = (StringParameter)this.getParameter(5);
                StringParameter p6 = (StringParameter)this.getParameter(6);
                this.x = Double.parseDouble(p4.getValue());
                this.y = Double.parseDouble(p5.getValue());
                this.z = Double.parseDouble(p6.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number syntax in command rotate : " + nfe.getMessage());
        }
    }
}

