/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.Vector3D;

public class UnShiftCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "unshift";
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private Object3DGraphController controller;

    public UnShiftCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        UnShiftCommand command = new UnShiftCommand(this.controller);
        command.a = this.a;
        command.b = this.b;
        command.c = this.c;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"unshift\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     unshift" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     unshift x y z" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Unshift command shifts selection opposite x y z." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    private String helpOutput() {
        return "Shift selected objects in reverse direction. Correct usage: unshift x y z";
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        Object3DController gControl = this.controller.getGraph();
        Vector3D shift = new Vector3D(-this.a, -this.b, -this.c);
        if (gControl.getSelectionRoot() == null) {
            gControl.translate(shift);
        } else {
            gControl.translateSelected(shift);
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 3) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        try {
            this.a = Double.parseDouble(p0.getValue());
            this.b = Double.parseDouble(p1.getValue());
            this.c = Double.parseDouble(p2.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number syntax in command shift : " + nfe.getMessage());
        }
    }
}

