/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.DistanceCommand;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.RnaTools;
import tools3d.objects3d.Object3D;

public class DistanceWizard
implements GeneralWizard {
    private static final int COL_SIZE_NAME = 25;
    private static final String FRAME_TITLE = "Distance Wizard";
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private CommandApplication application;
    private Object3DGraphController graphController;
    private NanoTilerInterpreter interpreter;
    private JLabel instructions;
    private JTextField selectionField1;
    private JTextField selectionField2;
    private JTextField distanceField;
    private Font font = new Font("new", 1, 16);
    private JLabel label;
    private Vector<String> tree;
    private String[] allowedNames = RnaTools.getRnaClassNames();
    private String[] forbiddenNames = null;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;

    public DistanceWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = this.frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        JPanel westCenterPanel = new JPanel();
        westCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Object 1: ");
        westCenterPanel.add((Component)this.label, "North");
        this.selectionField1 = new JTextField(this.getSelectionText(), 25);
        westCenterPanel.add((Component)this.selectionField1, "Center");
        westCenterPanel.add((Component)new TreePanel(this.selectionField1), "South");
        centerPanel.add((Component)westCenterPanel, "West");
        JPanel centerCenterPanel = new JPanel();
        centerCenterPanel.setLayout(new BorderLayout());
        this.label = new JLabel("Object 2: ");
        centerCenterPanel.add((Component)this.label, "North");
        this.selectionField2 = new JTextField(this.getSelectionText(), 25);
        centerCenterPanel.add((Component)this.selectionField2, "Center");
        centerCenterPanel.add((Component)new TreePanel(this.selectionField2), "South");
        centerPanel.add((Component)centerCenterPanel, "East");
        JPanel southCenterPanel = new JPanel();
        southCenterPanel.setLayout(new BorderLayout());
        this.distanceField = new JTextField(50);
        southCenterPanel.add((Component)this.distanceField, "East");
        this.label = new JLabel("Distance: ");
        southCenterPanel.add((Component)this.label, "West");
        centerPanel.add((Component)southCenterPanel, "South");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        buttonPanel.add(button);
        button = new JButton("Get Distance");
        button.addActionListener(new DistanceListener());
        buttonPanel.add(button);
        f.add((Component)centerPanel, "Center");
        f.add((Component)buttonPanel, "South");
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController controller, Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        if (controller == null) {
            log.info("GraphController received by lauchWizard is null!");
        }
        this.graphController = controller;
        this.addComponents();
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTextField field;

        public SelectionListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)DistanceWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(this.field.getText())) {
                    text = (String)DistanceWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                this.field.setText(text);
            }
        }
    }

    private class TreePanel
    extends JPanel {
        public TreePanel(JTextField field) {
            Object3DGraphController controller = ((AbstractDesigner)DistanceWizard.this.application).getGraphController();
            DistanceWizard.this.tree = controller.getGraph().getTree(DistanceWizard.this.allowedNames, DistanceWizard.this.forbiddenNames);
            this.setLayout(new BorderLayout());
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            labelPanel.add(new JLabel("Tree:"));
            this.add(labelPanel);
            DistanceWizard.this.treePanel = new JPanel();
            DistanceWizard.this.treeList = new JList(DistanceWizard.this.tree);
            DistanceWizard.this.treeList.addListSelectionListener(new SelectionListener(field));
            DistanceWizard.this.treeScroll = new JScrollPane(DistanceWizard.this.treeList);
            DistanceWizard.this.treeScroll.setVerticalScrollBarPolicy(20);
            DistanceWizard.this.treeScroll.setHorizontalScrollBarPolicy(30);
            DistanceWizard.this.treeScroll.setPreferredSize(new Dimension(300, 200));
            DistanceWizard.this.treePanel.add(DistanceWizard.this.treeScroll);
            this.add((Component)DistanceWizard.this.treePanel, "South");
        }
    }

    private class DistanceListener
    implements ActionListener {
        private DistanceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "dist " + DistanceWizard.this.selectionField1.getText().trim() + " " + DistanceWizard.this.selectionField2.getText().trim();
            try {
                DistanceWizard.this.application.runScriptLine(command);
                try {
                    Command command2 = DistanceWizard.this.interpreter.interpretLine("dist");
                    DistanceWizard.this.distanceField.setText("" + ((DistanceCommand)command2).getDistance());
                }
                catch (BadSyntaxException ex) {}
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(DistanceWizard.this.frame, ce + ": " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DistanceWizard.this.frame.setVisible(false);
            DistanceWizard.this.frame = null;
            DistanceWizard.this.finished = true;
        }
    }
}

