/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import rnadesign.designapp.rnagui.Object3DTree;
import rnadesign.rnacontrol.Object3DController;
import tools3d.objects3d.Object3D;

public class Object3DTreePanel
extends JPanel
implements ModelChangeListener {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    List<TreeSelectionListener> selectionListeners = new ArrayList<TreeSelectionListener>();
    Object3DController graphController;
    Object3DTree tree;
    JScrollPane scrollPane;
    int selectionMode = 1;

    public Object3DTreePanel(Object3DController graphController, int dimX, int dimY, boolean multiSelectionMode) {
        super(new BorderLayout());
        this.graphController = graphController;
        this.selectionMode = multiSelectionMode ? 4 : 1;
        log.fine("Constructing new Object3DTreePanel!");
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long used = total - free;
        long max = rt.maxMemory();
        log.info("Free memory: " + free + NEWLINE + "Total Memory: " + total + NEWLINE + "Used: " + used + NEWLINE + "Max: " + max);
        JPanel buttonPanel = new JPanel();
        this.tree = this.constructNewTree(this.graphController.getGraph());
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setPreferredSize(new Dimension(dimX, dimY));
        this.add((Component)buttonPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        log.fine("Adding Object3DTreePanel to modelChangeListener of GraphController!");
        this.graphController.addModelChangeListener(this);
    }

    private void synchronizeSelection() {
        Object3D node = (Object3D)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.graphController.deselectAll();
        this.graphController.setSelectionCursor(node);
        this.graphController.selectCurrent();
    }

    public Object3DTreePanel(Object3DController graphController, int dimX, int dimY) {
        this(graphController, dimX, dimY, false);
    }

    public Object3DTreePanel(Object3DController graphController) {
        this(graphController, 200, 200);
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void fireTreeSelectionChanged(TreeSelectionEvent event) {
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            TreeSelectionListener listener = this.selectionListeners.get(i);
            listener.valueChanged(event);
        }
    }

    public Object3D getLastSelected() {
        return (Object3D)this.tree.getLastSelectedPathComponent();
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        log.fine("Called Object3DTreePanel.modelChanged!");
        Object3D newRoot = this.graphController.getGraph();
        Object3D oldRoot = null;
        if (this.tree.getTreeModel() != null) {
            log.fine("getTreeModel is not null");
            oldRoot = (Object3D)this.tree.getTreeModel().getRoot();
            if (newRoot != oldRoot) {
                log.fine("Called Object3DTreePanel.modelChanged: root has changed!?");
                this.tree = this.constructNewTree(this.graphController.getGraph());
                this.remove(this.scrollPane);
                this.scrollPane = new JScrollPane(this.tree);
                this.add((Component)this.scrollPane, "Center");
                this.repaint();
            }
        } else {
            log.fine("Called Object3DTreePanel.modelChanged: root has not changed");
            this.tree = this.constructNewTree(this.graphController.getGraph());
            this.remove(this.scrollPane);
            this.scrollPane = new JScrollPane(this.tree);
            this.add((Component)this.scrollPane, "Center");
            this.repaint();
        }
    }

    private Object3DTree constructNewTree(Object3D object3D) {
        Object3DTree newTree = new Object3DTree(object3D);
        newTree.getSelectionModel().setSelectionMode(this.selectionMode);
        newTree.addTreeSelectionListener(new Object3DTreeSelectionListener());
        return newTree;
    }

    private class Object3DTreeSelectionListener
    implements TreeSelectionListener {
        private Object3DTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object3D node = (Object3D)Object3DTreePanel.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            log.fine("node is not null!");
            Object3DTreePanel.this.graphController.setSelectionCursor(node);
            Object3DTreePanel.this.graphController.selectCurrent();
            Object3DTreePanel.this.fireTreeSelectionChanged(e);
        }
    }
}

