/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SequenceController;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaStrand;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import sequence.DuplicateNameException;
import sequence.Sequence;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class OptimizationWizard
implements GeneralWizard {
    private static final int COL_SIZE = 15;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JFrame keyFrame = null;
    private CommandApplication application;
    private NanoTilerInterpreter interpreter;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private String[] commandNames;
    public static final String FRAME_TITLE = "Optimization Wizard";

    public OptimizationWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
        this.interpreter = (NanoTilerInterpreter)application.getInterpreter();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        assert (graphController != null);
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BoxLayout(f, 1));
        String[] allowedNames = new String[]{"RnaStrand"};
        String[] forbiddenNames = new String[]{"StrandJunction3D"};
        Vector<String> strandTree = this.graphController.getGraph().getTree(allowedNames, forbiddenNames);
        int strandCount = strandTree.size();
        Object3D root = this.graphController.getGraph().getGraph();
        MutableSecondaryStructure secStruc = null;
        SecondaryStructureScriptFormatWriter secStrucWriter = new SecondaryStructureScriptFormatWriter();
        try {
            secStruc = this.graphController.generateSecondaryStructure();
        }
        catch (DuplicateNameException dne) {
            log.warning("Duplicate sequence names detected! Cannot generate secondary structure.");
        }
        List<String[]> secondaryStructureLists = secStrucWriter.writeSecondaryStructure(secStruc);
        String[] strandNames = new String[strandCount];
        ArrayList<RnaStrand> strandList = new ArrayList<RnaStrand>();
        ArrayList<Residue3D[]> residueLists = new ArrayList<Residue3D[]>();
        SequenceController seqController = this.graphController.getSequences();
        ArrayList<Sequence> sequenceList = new ArrayList<Sequence>();
        ArrayList<String[]> sequenceResidueLists = new ArrayList<String[]>();
        for (int i = 0; i < strandCount; ++i) {
            StringTokenizer strandTokenizer = new StringTokenizer(strandTree.get(i));
            RnaStrand tempStrand = (RnaStrand)Object3DTools.findByFullName(root, strandTokenizer.nextToken());
            strandList.add(tempStrand);
            strandNames[i] = tempStrand.getName();
            sequenceList.add(seqController.getSequence(strandNames[i]));
            String currSequence = ((Sequence)sequenceList.get(i)).sequenceString();
            String[] currSequenceElements = new String[currSequence.length()];
            Residue3D[] currStrandResidues = new Residue3D[currSequence.length()];
            for (int j = 0; j < currSequence.length(); ++j) {
                currSequenceElements[j] = currSequence.substring(j, j + 1);
                currStrandResidues[j] = tempStrand.getResidue3D(j);
            }
            sequenceResidueLists.add(currSequenceElements);
            residueLists.add(currStrandResidues);
        }
        ArrayList<JPanel> strandPanels = new ArrayList<JPanel>();
        ArrayList<JCheckBox[]> sequenceBoxes = new ArrayList<JCheckBox[]>();
        int j = 0;
        while (j < strandCount) {
            JLabel label;
            JPanel tempPanel = new JPanel();
            tempPanel.setLayout(new BorderLayout());
            tempPanel.setBorder(BorderFactory.createTitledBorder(strandNames[j]));
            Residue3D[] tempResidueList = (Residue3D[])residueLists.get(j);
            String[] tempSequence = (String[])sequenceResidueLists.get(j);
            String[] tempStructure = secondaryStructureLists.get(j);
            JCheckBox[] boxes = new JCheckBox[tempSequence.length];
            JPanel innerTempPanel = new JPanel();
            innerTempPanel.setLayout(new GridLayout(4, tempSequence.length, 2, 0));
            innerTempPanel.setMinimumSize(new Dimension(50, 50));
            for (int s = 0; s < boxes.length; ++s) {
                label = new JLabel(" " + tempStructure[s]);
                innerTempPanel.add(label);
            }
            for (int g = 0; g < boxes.length; ++g) {
                label = new JLabel(" " + tempSequence[g]);
                innerTempPanel.add(label);
            }
            for (int l = 0; l < boxes.length; ++l) {
                JCheckBox tempBox = new JCheckBox();
                tempBox.setPreferredSize(new Dimension(10, 10));
                Residue3D tempResidue = tempResidueList[l];
                String residueStatus = tempResidue.getProperty("sequence_status");
                if (residueStatus != null && (residueStatus.equals("adhoc") || residueStatus.equals("optimized"))) {
                    tempBox.setSelected(true);
                }
                boxes[l] = tempBox;
                innerTempPanel.add(tempBox);
            }
            sequenceBoxes.add(boxes);
            for (int u = 0; u < boxes.length; ++u) {
                label = new JLabel(Integer.toString(u + 1));
                innerTempPanel.add(label);
            }
            JPanel tempButtonPanel = new JPanel();
            JButton selectAll = new JButton("Select all");
            int panelNumber = j++;
            final JCheckBox[] currBoxArray = (JCheckBox[])sequenceBoxes.get(panelNumber);
            selectAll.addActionListener(new ActionListener(){
                JCheckBox[] boxArray;
                {
                    this.boxArray = currBoxArray;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int f = 0; f < currBoxArray.length; ++f) {
                        currBoxArray[f].setSelected(true);
                    }
                }
            });
            tempButtonPanel.add(selectAll);
            JButton deselectAll = new JButton("Deselect all");
            deselectAll.addActionListener(new ActionListener(){
                JCheckBox[] boxArray;
                {
                    this.boxArray = currBoxArray;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int f = 0; f < currBoxArray.length; ++f) {
                        currBoxArray[f].setSelected(false);
                    }
                }
            });
            tempButtonPanel.add(deselectAll);
            final JTextField startParamField = new JTextField(3);
            startParamField.setText("0");
            final JTextField endParamField = new JTextField(3);
            endParamField.setText("0");
            JButton selectButton = new JButton("Select");
            selectButton.addActionListener(new ActionListener(){
                JCheckBox[] boxArray;
                {
                    this.boxArray = currBoxArray;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!startParamField.getText().equals("") && !endParamField.getText().equals("")) {
                        for (int f = Integer.parseInt(startParamField.getText()); f <= Integer.parseInt(endParamField.getText()) && f <= currBoxArray.length; ++f) {
                            if (f <= 0) continue;
                            currBoxArray[f - 1].setSelected(true);
                        }
                    }
                }
            });
            JButton deselectButton = new JButton("Deselect");
            deselectButton.addActionListener(new ActionListener(){
                JCheckBox[] boxArray;
                {
                    this.boxArray = currBoxArray;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!startParamField.getText().equals("") && !endParamField.getText().equals("")) {
                        for (int f = Integer.parseInt(startParamField.getText()); f <= Integer.parseInt(endParamField.getText()) && f <= currBoxArray.length; ++f) {
                            if (f <= 0) continue;
                            currBoxArray[f - 1].setSelected(false);
                        }
                    }
                }
            });
            tempButtonPanel.add(selectButton);
            tempButtonPanel.add(startParamField);
            tempButtonPanel.add(new JLabel("-"));
            tempButtonPanel.add(endParamField);
            tempButtonPanel.add(deselectButton);
            tempPanel.add((Component)innerTempPanel, "Center");
            tempPanel.add((Component)tempButtonPanel, "South");
            strandPanels.add(tempPanel);
        }
        JPanel strandPaneContainer = new JPanel();
        strandPaneContainer.setLayout(new BoxLayout(strandPaneContainer, 1));
        for (int u = 0; u < strandPanels.size(); ++u) {
            JScrollPane tempStrandPane = new JScrollPane((Component)strandPanels.get(u), 20, 30);
            tempStrandPane.setPreferredSize(new Dimension(400, 140));
            strandPaneContainer.add(tempStrandPane);
        }
        JScrollPane strandPaneContainerScroll = new JScrollPane(strandPaneContainer, 20, 30);
        strandPaneContainerScroll.setPreferredSize(new Dimension(400, 140));
        f.add(strandPaneContainerScroll);
        JPanel commandOptions = new JPanel();
        JLabel errorLabel = new JLabel("Error:");
        commandOptions.add(errorLabel);
        JTextField errorField = new JTextField(5);
        errorField.setText("0");
        commandOptions.add(errorField);
        JLabel iter1 = new JLabel("iter1:");
        commandOptions.add(iter1);
        JTextField iter1Field = new JTextField(7);
        iter1Field.setText("200");
        commandOptions.add(iter1Field);
        JLabel iter2 = new JLabel("iter2:");
        commandOptions.add(iter2);
        JTextField iter2Field = new JTextField(7);
        iter2Field.setText("200");
        commandOptions.add(iter2Field);
        JButton runOptButton = new JButton("Run Optimization");
        if (strandCount == 0) {
            runOptButton.setEnabled(false);
        }
        final ArrayList<JCheckBox[]> sequenceBoxes2 = sequenceBoxes;
        final ArrayList<String[]> sequenceResidueLists2 = sequenceResidueLists;
        final int strandCount2 = strandCount;
        JFrame frame2 = _frame;
        final Container f2 = f;
        final String[] strandNames2 = strandNames;
        final JTextField iter1Field2 = iter1Field;
        final JTextField iter2Field2 = iter2Field;
        final JTextField errorField2 = errorField;
        JButton runOptButton2 = runOptButton;
        if (strandCount2 > 0) {
            runOptButton.addActionListener(new ActionListener(){
                String resCommand = "resproperty ";

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int i = 0; i < strandCount2; ++i) {
                        System.out.println("Opt loop Started");
                        JCheckBox[] strandBoxes = (JCheckBox[])sequenceBoxes2.get(i);
                        int k = 0;
                        boolean hasCheckedBox = false;
                        while (!hasCheckedBox && k < strandBoxes.length) {
                            if (strandBoxes[k].isSelected()) {
                                hasCheckedBox = true;
                                this.resCommand = this.resCommand + strandNames2[i] + ":";
                                continue;
                            }
                            ++k;
                        }
                        System.out.println(this.resCommand);
                        String[] residues = (String[])sequenceResidueLists2.get(i);
                        if (!hasCheckedBox) continue;
                        for (int f = 0; f < strandBoxes.length; ++f) {
                            if (!strandBoxes[f].isSelected()) continue;
                            this.resCommand = this.resCommand + Integer.toString(f + 1) + ",";
                        }
                        System.out.println(this.resCommand);
                        this.resCommand = this.resCommand.substring(0, this.resCommand.length() - 1);
                        this.resCommand = this.resCommand + ";";
                        System.out.println(this.resCommand);
                    }
                    System.out.println(this.resCommand);
                    this.resCommand = this.resCommand.substring(0, this.resCommand.length() - 1);
                    this.resCommand = this.resCommand + " adhoc";
                    System.out.println(this.resCommand);
                    if (!this.resCommand.equals("resproperty adhoc")) {
                        try {
                            OptimizationWizard.this.application.runScriptLine("resproperty all fragment");
                            try {
                                OptimizationWizard.this.application.runScriptLine(this.resCommand);
                                try {
                                    OptimizationWizard.this.application.runScriptLine("optsequences error=" + errorField2.getText().trim() + " iter=" + iter1Field2.getText().trim() + " iter2=" + iter2Field2.getText().trim());
                                }
                                catch (CommandException ce) {
                                    JOptionPane.showMessageDialog(f2, ce + ": " + ce.getMessage());
                                }
                            }
                            catch (CommandException cex) {
                                JOptionPane.showMessageDialog(f2, cex + ": " + cex.getMessage());
                            }
                        }
                        catch (CommandException cex) {
                            JOptionPane.showMessageDialog(f2, cex + ": " + cex.getMessage());
                        }
                    }
                    this.resCommand = "resproperty ";
                }
            });
            runOptButton.addActionListener(new DoneListener());
        }
        commandOptions.add(runOptButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new DoneListener());
        commandOptions.add(closeButton);
        JButton interfaceKeyButton = new JButton("Interface Key");
        interfaceKeyButton.addActionListener(new LaunchKeyListener());
        commandOptions.add(interfaceKeyButton);
        commandOptions.setMaximumSize(new Dimension(2000, 50));
        f.add(commandOptions);
    }

    private class LaunchKeyListener
    implements ActionListener {
        private LaunchKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptimizationWizard.this.keyFrame = new JFrame("Sequence Optimization Interface Key");
            OptimizationWizard.this.keyFrame.setLayout(new BorderLayout());
            JTextArea textArea = new JTextArea(10, 10);
            textArea.append("Structure: . . . ( . . ( . ) . . ) . . .\n  ( ) = Paired Bases\n . . = Unpaired Bases\n\n Sequence:  GCGGGAUAC \n");
            textArea.setEditable(false);
            OptimizationWizard.this.keyFrame.add((Component)textArea, "North");
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptimizationWizard.this.keyFrame.setVisible(false);
                    OptimizationWizard.this.keyFrame = null;
                }
            });
            OptimizationWizard.this.keyFrame.add((Component)closeButton, "South");
            OptimizationWizard.this.keyFrame.pack();
            OptimizationWizard.this.keyFrame.setVisible(true);
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptimizationWizard.this.frame.setVisible(false);
            OptimizationWizard.this.frame = null;
            OptimizationWizard.this.finished = true;
        }
    }
}

