/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.util.Properties;
import java.util.TreeMap;
import tools3d.Ambiente;
import tools3d.Appearance;
import tools3d.Camera;
import tools3d.GeometryColorModel;
import tools3d.Vector3D;

public class RainbowColorModel
implements GeometryColorModel {
    private Integer redFactor = -5;
    private Integer blueFactor = 10;
    private Integer greenFactor = 2;
    private TreeMap<Integer, Color> colors = new TreeMap();
    public static final Color COLOR = Color.red;
    public static final Color DEFAULT_COLOR = Color.gray;

    @Override
    public Color computeColor(Ambiente ambiente, Appearance appearance, Properties properties, Vector3D faceNormal, Camera camera) {
        if (properties == null) {
            return DEFAULT_COLOR;
        }
        String className = properties.getProperty("class_name");
        String siblingId = properties.getProperty("sibling_id");
        String parentId = properties.getProperty("parent_id");
        String parentClassName = properties.getProperty("parent_class_name");
        if (className == null || siblingId == null || siblingId == null || parentClassName == null) {
            return DEFAULT_COLOR;
        }
        if (className.equals("Nucleotide3D")) {
            Integer index = Integer.parseInt(siblingId);
            Color color = this.getColor(index, COLOR);
            this.colors.put(index, color);
            return color;
        }
        if (parentClassName.equals("Nucleotide3D")) {
            Integer index = Integer.parseInt(parentId);
            Color color = this.colors.get(index);
            if (color == null) {
                color = this.getColor(index, COLOR);
                this.colors.put(index, color);
            }
            return color;
        }
        return DEFAULT_COLOR;
    }

    public Color getColor(int index, Color offset) {
        int red = offset.getRed();
        int blue = offset.getBlue();
        int green = offset.getGreen();
        for (int i = 0; i < index; ++i) {
            red = this.addFactorToColor(red, this.redFactor);
            blue = this.addFactorToColor(blue, this.blueFactor);
            green = this.addFactorToColor(green, this.greenFactor);
        }
        return new Color(red, blue, green);
    }

    private int addFactorToColor(int colorValue, Integer factor) {
        int result = colorValue + factor;
        if (result < 0) {
            result *= -1;
            if (factor == this.redFactor) {
                this.redFactor = this.redFactor * -1;
            } else if (factor == this.blueFactor) {
                this.blueFactor = this.blueFactor * -1;
            } else if (factor == this.greenFactor) {
                this.greenFactor = this.greenFactor * -1;
            }
        }
        if (result > 255) {
            result = 255;
            if (factor == this.redFactor) {
                this.redFactor = this.redFactor * -1;
            } else if (factor == this.blueFactor) {
                this.blueFactor = this.blueFactor * -1;
            } else if (factor == this.greenFactor) {
                this.greenFactor = this.greenFactor * -1;
            }
        }
        return result;
    }
}

