/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandExecutionException;
import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class RemoveLinksWizard
implements GeneralWizard,
ModelChangeListener {
    public static final String FRAME_TITLE = "Remove Links";
    private CommandApplication application;
    private JList list = new JList();
    private static int junction_suffix = 1;
    private int selectedLink;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JFrame frame;
    private LinkController linkController;

    public RemoveLinksWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.linkController = graphController.getLinks();
        this.frame = new JFrame(FRAME_TITLE);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RemoveLinksWizard.this.finished = true;
            }
        });
        this.graphController.getLinks().addModelChangeListener(this);
        JPanel panel = new JPanel();
        this.list.setAlignmentX(0.5f);
        this.list.setListData(this.getLinks());
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(300, 300));
        panel.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttonPanel = new JPanel();
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveLinksWizard.this.frame.setVisible(false);
                RemoveLinksWizard.this.frame.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        buttonPanel.add(close);
        JButton remove = new JButton("Remove Link");
        remove.addActionListener(new RemoveListener());
        buttonPanel.add(remove);
        panel.add((Component)buttonPanel, "South");
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public String[] getLinks() {
        String s = this.graphController.getLinks().toPrettyString();
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        String[] array = new String[tokenizer.countTokens()];
        int i = 0;
        if (tokenizer.countTokens() <= 1) {
            array[0] = "";
            return array;
        }
        while (tokenizer.hasMoreTokens()) {
            if (i == 0) {
                tokenizer.nextToken();
                array[i] = tokenizer.nextToken();
            } else {
                array[i] = tokenizer.nextToken();
            }
            ++i;
        }
        return array;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        String s = this.graphController.getLinks().toPrettyString();
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        final String[] array = new String[tokenizer.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokenizer.nextToken();
        }
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return array.length;
            }

            @Override
            public Object getElementAt(int index) {
                return array[index];
            }
        });
        this.list.revalidate();
        this.frame.repaint();
    }

    private final class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (RemoveLinksWizard.this.selectedLink < 0 || RemoveLinksWizard.this.selectedLink >= RemoveLinksWizard.this.linkController.size()) {
                    throw new CommandExecutionException("Undefined link number: " + (RemoveLinksWizard.this.selectedLink + 1));
                }
                try {
                    RemoveLinksWizard.this.linkController.remove(RemoveLinksWizard.this.selectedLink);
                    RemoveLinksWizard.this.list.setListData(RemoveLinksWizard.this.getLinks());
                }
                catch (Object3DGraphControllerException gce) {
                    throw new CommandExecutionException(gce.getMessage());
                }
            }
            catch (CommandExecutionException commandExecutionException) {
                // empty catch block
            }
        }
    }

    private final class ListListener
    implements ActionListener {
        private ListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoveLinksWizard.this.selectedLink = ((JList)e.getSource()).getSelectedIndex();
        }
    }
}

