/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rnadesign.designapp.AbstractDesigner;
import rnadesign.designapp.rnagui.Wizard;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class RenameWizard
implements Wizard {
    public static final int COL_SIZE_SELECTION = 20;
    public static final int COL_SIZE_COORDINATE = 6;
    private boolean finished = false;
    private JFrame frame = null;
    private Container container = null;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    public static final String FRAME_TITLE = "Rename Wizard";
    private JTextField selectionField;
    private JTextField nameField;
    private CommandApplication application;
    private Vector<String> tree;
    private String[] allowedNames;
    private String[] forbiddenNames;
    private JPanel treePanel;
    private JButton treeButton;
    private JList treeList;
    private JScrollPane treeScroll;
    private JLabel label;

    public RenameWizard(CommandApplication application) {
        assert (application != null);
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void addComponents() {
        Container f = new Container();
        f.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        this.treeButton = new JButton("View tree");
        this.treeButton.addActionListener(new TreeListener());
        top.add(this.treeButton);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        this.label = new JLabel("Original Object: ");
        left.add(this.label);
        this.label = new JLabel("New Name: ");
        left.add(this.label);
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        this.selectionField = new JTextField(this.getSelectionText(), 20);
        center.add((Component)this.selectionField, "Center");
        this.nameField = new JTextField(20);
        center.add(this.nameField);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel southBottomPanel = new JPanel();
        JButton button = new JButton("Close");
        button.addActionListener(new CancelListener());
        southBottomPanel.add(button);
        button = new JButton("Rename Object");
        button.addActionListener(new DoneListener());
        southBottomPanel.add(button);
        bottomPanel.add((Component)southBottomPanel, "South");
        f.add((Component)left, "West");
        f.add((Component)top, "North");
        f.add((Component)center, "Center");
        f.add((Component)bottomPanel, "South");
        this.container.add(f);
    }

    private String getSelectionText() {
        Object3DGraphController graphController = ((AbstractDesigner)this.application).getGraphController();
        Object3DController gControl = graphController.getGraph();
        Object3D selection = gControl.getSelectionRoot();
        if (selection == null) {
            return "";
        }
        String selectionName = selection.getName();
        Object3D curr = selection;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            selectionName = curr.getName() + "." + selectionName;
        }
        return selectionName;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Component parentFrame) {
        this.frame = new JFrame(FRAME_TITLE);
        this.container = this.frame.getContentPane();
        this.container.setLayout(new FlowLayout());
        this.addComponents();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private class TreeListener
    implements ActionListener {
        private TreeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RenameWizard.this.treeButton.getText().equals("View tree")) {
                RenameWizard.this.treeButton.setText("Hide tree");
                Object3DGraphController controller = ((AbstractDesigner)RenameWizard.this.application).getGraphController();
                RenameWizard.this.tree = controller.getGraph().getTree(RenameWizard.this.allowedNames, RenameWizard.this.forbiddenNames);
                Container j = new Container();
                j.setLayout(new BorderLayout());
                RenameWizard.this.treePanel = new JPanel();
                RenameWizard.this.treeList = new JList(RenameWizard.this.tree);
                RenameWizard.this.treeList.addListSelectionListener(new SelectionListener());
                RenameWizard.this.treeScroll = new JScrollPane(RenameWizard.this.treeList);
                RenameWizard.this.treePanel.add(RenameWizard.this.treeScroll);
                j.add((Component)RenameWizard.this.treePanel, "South");
                RenameWizard.this.frame.getContentPane().add(j);
                RenameWizard.this.frame.pack();
            } else {
                RenameWizard.this.frame.getContentPane().remove(1);
                RenameWizard.this.treeButton.setText("View tree");
                RenameWizard.this.frame.pack();
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                String text = (String)RenameWizard.this.tree.get(e.getFirstIndex());
                if ((text = text.substring(0, text.indexOf(" "))).equals(RenameWizard.this.selectionField.getText())) {
                    text = (String)RenameWizard.this.tree.get(e.getLastIndex());
                    text = text.substring(0, text.indexOf(" "));
                }
                RenameWizard.this.selectionField.setText(text);
            }
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = "rename " + RenameWizard.this.selectionField.getText().trim() + " " + RenameWizard.this.nameField.getText().trim();
            try {
                RenameWizard.this.application.runScriptLine(command);
            }
            catch (CommandException ce) {
                JOptionPane.showMessageDialog(RenameWizard.this.frame, "Error executing command: " + command + " : " + ce.getMessage());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameWizard.this.frame.setVisible(false);
            RenameWizard.this.frame = null;
            RenameWizard.this.finished = true;
        }
    }
}

