/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.BadSyntaxException;
import commandtools.CommandApplication;
import commandtools.CommandException;
import commandtools.UnknownCommandException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.CommandHistoryDisplay;
import rnadesign.designapp.rnagui.PackageConstants;

public class ScriptCommandDisplay
extends JPanel {
    private CommandApplication app;
    private CommandHistoryDisplay historyDisplay;
    private JTextField commandInputField;
    private JFrame frame;
    private Logger log = Logger.getLogger("NanoTiler_debug");

    public ScriptCommandDisplay(CommandApplication application) {
        this.app = application;
        assert (this.app.getInterpreter() != null);
        this.addComponents();
    }

    private void addComponents() {
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel leftUpperPanel = new JPanel();
        JPanel leftLowerPanel = new JPanel();
        leftLowerPanel.setLayout(new FlowLayout(4));
        leftUpperPanel.add(new JLabel("Command:"));
        this.commandInputField = new JTextField("", 60);
        this.commandInputField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int id = e.getKeyCode();
                if (id == 10) {
                    String commandText = ScriptCommandDisplay.this.commandInputField.getText();
                    ScriptCommandDisplay.this.log.info("Running command: " + commandText);
                    try {
                        ScriptCommandDisplay.this.app.runScriptLine(commandText);
                    }
                    catch (Exception ex) {
                        ScriptCommandDisplay.this.log.warning(ex.getMessage());
                    }
                    ScriptCommandDisplay.this.commandInputField.setText("");
                } else if (id == 39) {
                    String text = ScriptCommandDisplay.this.commandInputField.getText();
                    String completed = ScriptCommandDisplay.this.app.getInterpreter().autoComplete(text);
                    ScriptCommandDisplay.this.commandInputField.setText(completed);
                }
                ScriptCommandDisplay.this.commandInputField.requestFocusInWindow();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        leftUpperPanel.add(this.commandInputField);
        JButton runButton = new JButton("Run");
        runButton.addActionListener(new RunCommandListener());
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ClearCommandListener());
        JButton helpButton = new JButton("Help");
        helpButton.addActionListener(new HelpCommandListener());
        leftLowerPanel.add(runButton);
        leftLowerPanel.add(clearButton);
        leftLowerPanel.add(helpButton);
        this.historyDisplay = new CommandHistoryDisplay(this.app);
        rightPanel.add(this.historyDisplay);
        JButton saveButton = new JButton("Save history");
        saveButton.addActionListener(new SaveListener());
        rightPanel.add(saveButton);
        leftPanel.add((Component)leftUpperPanel, "North");
        leftPanel.add((Component)leftLowerPanel, "South");
        this.add(leftPanel);
        this.add(rightPanel);
    }

    private class ClearCommandListener
    implements ActionListener {
        private ClearCommandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptCommandDisplay.this.commandInputField.setText("");
            ScriptCommandDisplay.this.log.finest("Clear text input!");
        }
    }

    private class HelpCommandListener
    implements ActionListener {
        private HelpCommandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String commandText = "help";
            ScriptCommandDisplay.this.log.fine("Running command: " + commandText);
            try {
                ScriptCommandDisplay.this.app.runScriptLine(commandText);
            }
            catch (UnknownCommandException uce) {
                ScriptCommandDisplay.this.log.warning(uce.getMessage());
            }
            catch (BadSyntaxException bse) {
                ScriptCommandDisplay.this.log.warning(bse.getMessage());
            }
            catch (CommandException ce) {
                ScriptCommandDisplay.this.log.warning(ce.getMessage());
            }
        }
    }

    private class RunCommandListener
    implements ActionListener {
        private RunCommandListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String commandText = ScriptCommandDisplay.this.commandInputField.getText();
            ScriptCommandDisplay.this.log.info("Running command: " + commandText);
            try {
                ScriptCommandDisplay.this.app.runScriptLine(commandText);
            }
            catch (Exception ex) {
                ScriptCommandDisplay.this.log.warning(ex.getMessage());
            }
            ScriptCommandDisplay.this.commandInputField.setText("");
            ScriptCommandDisplay.this.commandInputField.requestFocusInWindow();
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptCommandDisplay.this.log.fine("Export-BPL item activated!");
            if (ScriptCommandDisplay.this.app.getCommandHistory() == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setApproveButtonText("Save");
            chooser.setFileSelectionMode(2);
            File cwd = new File(".");
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showSaveDialog(ScriptCommandDisplay.this.commandInputField);
            if (returnVal == 0) {
                String fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                ScriptCommandDisplay.this.log.info("You chose this file: " + fileName);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(fileName);
                    PrintStream ps = new PrintStream(fos);
                    ps.println(((Object)ScriptCommandDisplay.this.app.getCommandHistory()).toString());
                    fos.close();
                }
                catch (IOException exc) {
                    ScriptCommandDisplay.this.log.severe("Error Writing to File: " + fileName + " " + exc.getMessage());
                }
                ScriptCommandDisplay.this.log.fine("Finished writing history!");
            }
        }
    }
}

