/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import rnadesign.designapp.rnagui.AbstractGeometryPainter;
import rnadesign.rnacontrol.CameraController;
import tools3d.Character3D;
import tools3d.Drawable;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.Point3D;
import tools3d.Vector3D;

public class WireGeometryCharactersPainter
extends AbstractGeometryPainter {
    private double pointRadius = 2.0;

    @Override
    public void paintPoint(Graphics g, Point3D point) {
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        if (point.getAppearance() != null) {
            g2.setColor(point.getAppearance().getColor());
        } else {
            g.setColor(this.getDefaultPaintColor(point));
        }
        Vector3D pos3d = point.getPosition();
        CameraController camera = this.getCameraController();
        Point2D point2d = camera.project(pos3d);
        double radius = point.getRadius();
        if (radius < this.pointRadius) {
            radius = this.pointRadius;
        }
        g2.draw(new Ellipse2D.Double(point2d.getX(), point2d.getY(), radius *= camera.getZoom(), radius));
        g.setColor(saveColor);
    }

    @Override
    public void paintCharacter(Graphics g, Character3D point) {
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        char[] characters = new char[]{point.getCharacter()};
        if (point.getAppearance() != null) {
            g2.setColor(point.getAppearance().getColor());
        } else {
            g.setColor(this.getDefaultPaintColor(point));
        }
        Vector3D pos3d = point.getPosition();
        CameraController camera = this.getCameraController();
        Point2D point2d = camera.project(point.getPosition());
        g.setColor(saveColor);
    }

    @Override
    public void paintEdge(Graphics g, Edge3D edge) {
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        if (edge.getAppearance() != null) {
            g2.setColor(edge.getAppearance().getColor());
        } else {
            g.setColor(this.getDefaultPaintColor(edge));
        }
        Vector3D first3d = edge.getFirst();
        Vector3D second3d = edge.getSecond();
        CameraController camera = this.getCameraController();
        Point2D first2d = camera.project(first3d);
        Point2D second2d = camera.project(second3d);
        g.drawLine((int)first2d.getX(), (int)first2d.getY(), (int)second2d.getX(), (int)second2d.getY());
        g.setColor(saveColor);
    }

    @Override
    public void paintFace(Graphics g, Face3D face) {
    }

    @Override
    public boolean isPaintable(Drawable p) {
        return true;
    }
}

