/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import java.util.logging.Logger;
import symmetry.Cell;
import tools3d.LineShape;
import tools3d.Shape3DSet;
import tools3d.SimpleShape3DSet;
import tools3d.Vector3D;

public class GridShapeTools {
    private static Logger log = Logger.getLogger("NanoTiler_debug");

    private static void addLine(Shape3DSet shapeSet, LineShape line) {
        shapeSet.add(line);
    }

    public static Shape3DSet createUnitCellShape(Cell cell) {
        SimpleShape3DSet shapeSet = new SimpleShape3DSet();
        Vector3D zero = new Vector3D(0.0, 0.0, 0.0);
        Vector3D x = cell.getX();
        Vector3D y = cell.getY();
        Vector3D z = cell.getZ();
        Vector3D xy = x.plus(y);
        Vector3D xz = x.plus(z);
        Vector3D xyz = xy.plus(z);
        Vector3D yz = y.plus(z);
        LineShape lineShape = new LineShape(new Vector3D(zero), new Vector3D(x));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(zero), new Vector3D(y));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(x), new Vector3D(xy));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(y), new Vector3D(xy));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(z), new Vector3D(xz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(z), new Vector3D(yz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(xz), new Vector3D(xyz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(yz), new Vector3D(xyz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(zero), new Vector3D(z));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(x), new Vector3D(xz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(xy), new Vector3D(xyz));
        GridShapeTools.addLine(shapeSet, lineShape);
        lineShape = new LineShape(new Vector3D(y), new Vector3D(yz));
        GridShapeTools.addLine(shapeSet, lineShape);
        log.finest("GridShapeTools.createUnitCellShape: created shape with " + shapeSet.size() + " lines!");
        return shapeSet;
    }
}

