/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import controltools.ModelChanger;
import generaltools.AlgorithmFailureException;
import generaltools.ConstraintDouble;
import generaltools.ParsingException;
import generaltools.PropertyTools;
import generaltools.Randomizer;
import generaltools.SimpleConstraintDouble;
import generaltools.StringTools;
import graphtools.IntegerPermutatorList;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.SimpleQueueManager;
import launchtools.SimpleRunCommand;
import numerictools.MonteCarloOptimizer;
import numerictools.OptimizationNDResult;
import rnadesign.rnacontrol.BasePairController;
import rnadesign.rnacontrol.BindingSiteController;
import rnadesign.rnacontrol.BridgeItController;
import rnadesign.rnacontrol.CellKaleidoscope;
import rnadesign.rnacontrol.DummyKaleidoscope;
import rnadesign.rnacontrol.GridShapeTools;
import rnadesign.rnacontrol.InvalidParametersException;
import rnadesign.rnacontrol.JunctionController;
import rnadesign.rnacontrol.Kaleidoscope;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Mutation;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphControllerEventConstants;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.PackageConstants;
import rnadesign.rnacontrol.PdbJunctionController;
import rnadesign.rnacontrol.PdbJunctionControllerParameters;
import rnadesign.rnacontrol.RnaInverseTools;
import rnadesign.rnacontrol.SequenceController;
import rnadesign.rnacontrol.SimpleBasePairController;
import rnadesign.rnacontrol.SimpleBindingSiteController;
import rnadesign.rnacontrol.SimpleLinkController;
import rnadesign.rnacontrol.SimpleSequenceController;
import rnadesign.rnacontrol.SimpleShapeSetFactory;
import rnadesign.rnacontrol.SymmetryController;
import rnadesign.rnacontrol.SymmetryKaleidoscope;
import rnadesign.rnacontrol.SymmetryTools;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.AtomTools;
import rnadesign.rnamodel.BasepairOptimizer;
import rnadesign.rnamodel.BasepairOptimizerTools;
import rnadesign.rnamodel.BioPolymer;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.BuildingBlockGrower;
import rnadesign.rnamodel.CompleteGridTiler;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.CorridorDescriptor;
import rnadesign.rnamodel.DBElementDescriptor;
import rnadesign.rnamodel.DebugGridTiler;
import rnadesign.rnamodel.DefaultLatticeTiler;
import rnadesign.rnamodel.Dna3DTools;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.FragmentGridTiler;
import rnadesign.rnamodel.GeneralPdbWriter;
import rnadesign.rnamodel.GeneralRnaReader;
import rnadesign.rnamodel.GraphJunctionFactory;
import rnadesign.rnamodel.Grid3DTools;
import rnadesign.rnamodel.GridTiler;
import rnadesign.rnamodel.GrowConnectivity;
import rnadesign.rnamodel.GrowFramework;
import rnadesign.rnamodel.HelixBridgeFinder;
import rnadesign.rnamodel.HelixOptimizerTools;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.InteractionLinkImp;
import rnadesign.rnamodel.JunctionCollector;
import rnadesign.rnamodel.JunctionDBConstraintLink;
import rnadesign.rnamodel.JunctionMultiConstraintLink;
import rnadesign.rnamodel.KnotPlotReader;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.NucleotideDBTools;
import rnadesign.rnamodel.NucleotideStrand;
import rnadesign.rnamodel.NucleotideTools;
import rnadesign.rnamodel.PointSetReader;
import rnadesign.rnamodel.PointSetReader3;
import rnadesign.rnamodel.RandomGridTiler;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RingFixLinkGenerator;
import rnadesign.rnamodel.RingFuser;
import rnadesign.rnamodel.Rna3DTools;
import rnadesign.rnamodel.RnaConstants;
import rnadesign.rnamodel.RnaForceFieldFactory;
import rnadesign.rnamodel.RnaIntegerPotential;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaPdbReader;
import rnadesign.rnamodel.RnaPdbRnaviewReader;
import rnadesign.rnamodel.RnaStem3D;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.RnaStrandTools;
import rnadesign.rnamodel.SequenceBindingSiteCollector;
import rnadesign.rnamodel.SequenceCollector;
import rnadesign.rnamodel.SignatureTranslatorCanonizer;
import rnadesign.rnamodel.SimpleConnectivityGenerator;
import rnadesign.rnamodel.SimpleGridTiler;
import rnadesign.rnamodel.SimpleStrandFuser;
import rnadesign.rnamodel.SingleStrandBridgeFinder;
import rnadesign.rnamodel.SingleStrandsBridgeFinder;
import rnadesign.rnamodel.StemTools;
import rnadesign.rnamodel.StrandFuser;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionTools;
import rnadesign.rnamodel.SystematicBasepairOptimizer;
import rnadesign.rnamodel.TraceRnaGraphPotential;
import rnadesign.rnamodel.TraceRnaPotential;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.InteractionType;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.RnaInteractionType;
import rnasecondary.SecondaryStructure;
import rnasecondary.SecondaryStructureCTFormatWriter;
import rnasecondary.SecondaryStructureFastaFormatWriter;
import rnasecondary.SecondaryStructureScriptFormatWriter;
import rnasecondary.SecondaryStructureServerFormatWriter;
import rnasecondary.SecondaryStructureWriter;
import rnasecondary.SimpleInteraction;
import rnasecondary.SimpleMutableSecondaryStructure;
import secondarystructuredesign.CritonScorer;
import secondarystructuredesign.DummyEnergySecondaryStructureScorer;
import secondarystructuredesign.MonteCarloSequenceOptimizer;
import secondarystructuredesign.MonteCarloSequenceOptimizer3Step;
import secondarystructuredesign.NupackStructureScorer;
import secondarystructuredesign.RiboswitchSecondaryStructureScorer;
import secondarystructuredesign.RnacofoldSecondaryStructureScorer;
import secondarystructuredesign.SecondaryStructureScorer;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Residue;
import sequence.Sequence;
import sequence.SimpleLetterSymbol;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;
import symmetry.Ccp4SpaceGroupFactory;
import symmetry.Cell;
import symmetry.DefaultCell;
import symmetry.DefaultLattice;
import symmetry.DefaultSpaceGroup;
import symmetry.SpaceGroup;
import symmetry.SpaceGroupFactory;
import symmetry.SymmetryException;
import tools3d.Appearance;
import tools3d.Cube;
import tools3d.Geometry;
import tools3d.LatticeSection;
import tools3d.Matrix3D;
import tools3d.Shape3D;
import tools3d.Shape3DSet;
import tools3d.Superimpose;
import tools3d.Vector3D;
import tools3d.geometry.PlanarTools;
import tools3d.geometry.PlatonicTools;
import tools3d.objects3d.ConstraintLink;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.MultiConstraintLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DActionVisitor;
import tools3d.objects3d.Object3DException;
import tools3d.objects3d.Object3DFactory;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DLinkSetBundleTools;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DSetTools;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.Object3DWriter;
import tools3d.objects3d.RotationInfo;
import tools3d.objects3d.Shape3DSetFactory;
import tools3d.objects3d.SimpleConstraintLink;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;
import tools3d.objects3d.TorsionLink;
import tools3d.objects3d.modeling.ForceFieldFactory;
import tools3d.objects3d.modeling.MonteCarloMinimizer;
import tools3d.objects3d.modeling.SimpleMinimizationParameters;

public class Object3DGraphController
implements ModelChanger,
ModelChangeListener {
    public static String nanotilerHome = System.getenv("NANOTILER_HOME");
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private static ResourceBundle rb = ResourceBundle.getBundle("Controller");
    public static final String rnaInverseScriptName = rb.getString("rnaInverseScript");
    public static final String ccp4PdbsetBinary = rb.getString("ccp4PdbsetBinary");
    private static final Object3DGraphControllerEventConstants eventConst = new Object3DGraphControllerEventConstants();
    private BridgeItController bridgeController;
    private SymmetryController symmetryController = new SymmetryController();
    private Color defaultColor = Color.BLUE;
    private Color[] depthColors = new Color[]{Color.RED, Color.YELLOW, Color.GREEN, Color.BLUE};
    private Object3DController graph = new Object3DController();
    private int gridShapeMode = 1;
    private int symmetryMode = 1;
    private Appearance selectionCursorAppearance = new Appearance(Color.WHITE);
    private CorridorDescriptor corridorDescriptor = new CorridorDescriptor(0.0, 2.0);
    private double stemFitRmsTolerance = 5.0;
    private double selectionCursorRadius = 3.0;
    private Appearance selectionRootAppearance = new Appearance(Color.CYAN);
    private double selectionRootRadius = 2.0;
    private Vector3D[] points;
    private List<ModelChangeListener> modelChangeListeners = new ArrayList<ModelChangeListener>();
    private FragmentGridTiler fgTiler = new FragmentGridTiler();
    private ForceFieldFactory forceFieldFactory = new RnaForceFieldFactory();
    private int importStemLengthMin = 3;
    private SequenceController sequences = new SimpleSequenceController();
    private BindingSiteController bindingSites = new SimpleBindingSiteController();
    private LinkController links = new SimpleLinkController();
    private BasePairController basePairDB = new SimpleBasePairController();
    private Shape3DSet shapeSet = null;
    private Shape3DSetFactory shapeSetFactory = new SimpleShapeSetFactory();
    private SpaceGroup spaceGroup = new DefaultSpaceGroup();
    private int spaceGroupSymmetryCount = -1;
    private final SpaceGroupFactory spaceGroupFactory = new Ccp4SpaceGroupFactory();
    private Cell cell = new DefaultCell();
    private LatticeSection latticeSection = new LatticeSection(0, 0, 0, 1, 1, 1);
    private Kaleidoscope kaleidoscope = new CellKaleidoscope(this.cell, this.latticeSection);
    private Object3D nucleotideDB = null;
    private String lastReadDirectory = ".";
    private String lastWriteDirectory = ".";
    private PdbJunctionController junctionController = new PdbJunctionController();
    private double atomBondCutoff = 1.5;

    public Object3DGraphController() {
        this.graph.addModelChangeListener(this);
        this.links.addModelChangeListener(this);
    }

    public void addAtom(String nucleotideName, String atomName) throws Object3DGraphControllerException {
        this.getGraph().addAtom(nucleotideName, atomName);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void addBundle(Object3DLinkSetBundle bundle) {
        this.graph.addGraph(bundle.getObject3D());
        this.links.addLinks(bundle.getLinks());
    }

    public void generateLink(String name1, String name2, String linkTypeName) throws Object3DGraphControllerException {
        Object3D obj1 = this.graph.findByFullName(name1);
        Object3D obj2 = this.graph.findByFullName(name2);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + name2);
        }
        if (obj1 == obj2) {
            throw new Object3DGraphControllerException("Currently all links have to connect two different objects.");
        }
        this.links.add(new SimpleLink(obj1, obj2));
    }

    public void addBasePair(String objectName1, String objectName2, int interactionTypeId, int offset, int symId1, int symId2) throws Object3DGraphControllerException {
        this.addBasePair(objectName1, objectName2, interactionTypeId, offset);
    }

    public void addBasePair(String objectName1, String objectName2, int interactionTypeId, int offset) throws Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), objectName1);
        Object3D obj2 = Object3DTools.findByFullName(this.graph.getGraph(), objectName2);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName2);
        }
        if (obj1.getParent() == null) {
            throw new Object3DGraphControllerException("Cannot find object parent: " + objectName1);
        }
        if (obj2.getParent() == null) {
            throw new Object3DGraphControllerException("Cannot find object parent: " + objectName2);
        }
        if (offset != 0) {
            if (obj1.getSiblingId() + offset >= obj1.getParent().size()) {
                throw new Object3DGraphControllerException("Illegal object index: " + obj2.getFullName());
            }
            if (obj2.getSiblingId() - offset < 0) {
                throw new Object3DGraphControllerException("Illegal object index: " + obj2.getFullName());
            }
            obj1 = obj1.getParent().getChild(obj1.getSiblingId() + offset);
            obj2 = obj2.getParent().getChild(obj2.getSiblingId() - offset);
        }
        if (!(obj1 instanceof Residue3D)) {
            throw new Object3DGraphControllerException("Specified object is not a residue: " + objectName1);
        }
        if (!(obj2 instanceof Residue3D)) {
            throw new Object3DGraphControllerException("Specified object is not a residue: " + objectName2);
        }
        Residue3D res1 = (Residue3D)obj1;
        Residue3D res2 = (Residue3D)obj2;
        RnaInteractionType interactionType = new RnaInteractionType(interactionTypeId);
        SimpleInteraction interaction = new SimpleInteraction(res1, res2, interactionType);
        InteractionLinkImp interactionLink = new InteractionLinkImp(res1, res2, interaction);
        int numBPOrig = this.links.getHydrogenBondInteractions().size();
        this.links.add(interactionLink);
        assert (this.links.getHydrogenBondInteractions().size() == numBPOrig + 1);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void addHelixConstraint(String objectName1, String objectName2, int basePairMin, int basePairMax, double rms, int symId1, int symId2, String name) throws Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), objectName1);
        Object3D obj2 = Object3DTools.findByFullName(this.graph.getGraph(), objectName2);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName2);
        }
        this.links.addHelixConstraintLink(obj1, obj2, basePairMin, basePairMax, rms, symId1, symId2, name);
        this.graph.fireModelChanged(new ModelChangeEvent(this));
    }

    public ConstraintLink addDistanceConstraint(String objectName1, String objectName2, double min, double max, int symId1, int symId2) throws Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), objectName1);
        Object3D obj2 = Object3DTools.findByFullName(this.graph.getGraph(), objectName2);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName2);
        }
        ConstraintLink newLink = this.links.addDistanceConstraintLink(obj1, obj2, min, max, symId1, symId2);
        this.graph.fireModelChanged(new ModelChangeEvent(this));
        return newLink;
    }

    public TorsionLink addTorsionConstraint(String objectName1, String objectName2, String objectName3, String objectName4, double min, double max) throws Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), objectName1);
        Object3D obj2 = Object3DTools.findByFullName(this.graph.getGraph(), objectName2);
        Object3D obj3 = Object3DTools.findByFullName(this.graph.getGraph(), objectName3);
        Object3D obj4 = Object3DTools.findByFullName(this.graph.getGraph(), objectName4);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName2);
        }
        if (obj3 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName3);
        }
        if (obj4 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + objectName4);
        }
        TorsionLink newLink = this.links.addTorsionConstraintLink(obj1, obj2, obj3, obj4, min, max);
        this.graph.fireModelChanged(new ModelChangeEvent(this));
        return newLink;
    }

    public MultiConstraintLink addJunctionMultiConstraintLink(String name, List<Nucleotide3D> fivePrimeResidues, List<Nucleotide3D> threePrimeResidues, ConstraintDouble constraint, ConstraintDouble bridgableConstraint, List<Integer> symIds) throws Object3DGraphControllerException {
        MultiConstraintLink newLink = null;
        try {
            newLink = this.getLinks().addJunctionMultiConstraintLink(name, fivePrimeResidues, threePrimeResidues, constraint, bridgableConstraint, symIds);
            log.info("Adding junction link: " + newLink.toString());
        }
        catch (RnaModelException rme) {
            throw new Object3DGraphControllerException(rme.getMessage());
        }
        this.graph.fireModelChanged(new ModelChangeEvent(this));
        return newLink;
    }

    public JunctionDBConstraintLink addJunctionDBConstraintLink(String name, List<String> branchNames, boolean kissingLoopMode) throws Object3DGraphControllerException {
        JunctionDBConstraintLink newLink = null;
        ArrayList<BranchDescriptor3D> branches = new ArrayList<BranchDescriptor3D>();
        log.info("Added junctionDBConstraintLink of size " + branchNames.size());
        try {
            for (int i = 0; i < branchNames.size(); ++i) {
                Object3D obj = this.getGraph().findByFullName(branchNames.get(i));
                if (obj == null || !(obj instanceof BranchDescriptor3D)) {
                    throw new Object3DGraphControllerException("The name " + branchNames.get(i) + " does not point to a helix descriptor (BranchDescriptor3D class)");
                }
                branches.add((BranchDescriptor3D)obj);
                log.info("Added branch " + branchNames.get(i));
            }
            assert (this.junctionController != null);
            if (kissingLoopMode) {
                this.links.addJunctionDBConstraintLink(name, branches, this.junctionController.getKissingLoopDB());
            } else {
                this.links.addJunctionDBConstraintLink(name, branches, this.junctionController.getJunctionDB());
            }
        }
        catch (RnaModelException rme) {
            throw new Object3DGraphControllerException(rme.getMessage());
        }
        this.graph.fireModelChanged(new ModelChangeEvent(this));
        return newLink;
    }

    public MultiConstraintLink addJunctionMultiConstraintLink(String name, List<String> fivePrimeResidueNames, List<String> threePrimeResidueNames, double min, double max, double minBridge, double maxBridge, List<Integer> symIds) throws Object3DGraphControllerException {
        assert (fivePrimeResidueNames.size() == threePrimeResidueNames.size());
        ArrayList<Nucleotide3D> fivePrimeResidues = new ArrayList<Nucleotide3D>();
        ArrayList<Nucleotide3D> threePrimeResidues = new ArrayList<Nucleotide3D>();
        for (int i = 0; i < fivePrimeResidueNames.size(); ++i) {
            Object3D obj5 = this.getGraph().findByFullName(fivePrimeResidueNames.get(i));
            if (obj5 == null) {
                throw new Object3DGraphControllerException("Could not find object: " + fivePrimeResidueNames.get(i));
            }
            if (!(obj5 instanceof Nucleotide3D)) {
                throw new Object3DGraphControllerException("5' residue does not have type Nucleotide3D: " + fivePrimeResidueNames.get(i) + " " + ((Object)obj5).toString());
            }
            Object3D obj3 = this.getGraph().findByFullName(threePrimeResidueNames.get(i));
            if (obj3 == null) {
                throw new Object3DGraphControllerException("Could not find object: " + threePrimeResidueNames.get(i));
            }
            if (!(obj3 instanceof Nucleotide3D)) {
                throw new Object3DGraphControllerException("3' residue does not have type Nucleotide3D: " + threePrimeResidueNames.get(i) + " : " + ((Object)obj3).toString());
            }
            fivePrimeResidues.add((Nucleotide3D)obj5);
            threePrimeResidues.add((Nucleotide3D)obj3);
        }
        SimpleConstraintDouble bridgeConstraint = null;
        if (maxBridge > minBridge) {
            bridgeConstraint = new SimpleConstraintDouble(minBridge, maxBridge);
        }
        return this.addJunctionMultiConstraintLink(name, fivePrimeResidues, threePrimeResidues, new SimpleConstraintDouble(min, max), bridgeConstraint, symIds);
    }

    public void cloneObject(String origFullName, String newParentFullName, String newIndividualName, int symId) throws Object3DGraphControllerException {
        this.graph.cloneObject(origFullName, newParentFullName, newIndividualName, symId);
        int numInteractions = this.links.size();
        String newFullName = newParentFullName + "." + newIndividualName;
        Object3D origTree = this.graph.getGraph(origFullName);
        Object3D clonedTree = this.graph.getGraph(newFullName);
        if (origTree == null) {
            throw new Object3DGraphControllerException("Object3DGraphController: Could not find original object with name: " + newParentFullName);
        }
        if (clonedTree == null) {
            throw new Object3DGraphControllerException("Object3DGraphController: Could not find cloned object with name: " + newFullName);
        }
        LinkSet clonedLinks = this.links.cloneLinks(origTree, clonedTree);
        this.links.merge(clonedLinks);
    }

    public void addCloneGrid(Object3D toBeCloned, Object3D gridRoot) {
        for (int i = 0; i < gridRoot.size(); ++i) {
            Object3DLinkSetBundle cloneBundle = Object3DLinkSetBundleTools.generateClone(toBeCloned, this.links);
            Object3D obj = cloneBundle.getObject3D();
            obj.setPosition(gridRoot.getChild(i).getPosition());
            this.addBundle(cloneBundle);
        }
    }

    public void addCubicGrid(Vector3D startPos, Vector3D v1, Vector3D v2, Vector3D v3, int n1, int n2, int n3, String name, Object3D toBeClonedObject, boolean addGridFlag, boolean addStemsFlag, char sequenceChar, boolean onlyFirstPathMode, int tilerAlgorithm) throws Object3DGraphControllerException {
        Object3DLinkSetBundle gridBundle = Grid3DTools.generateCubicGrid(startPos, v1, v2, v3, n1, n2, n3, name);
        if (addGridFlag) {
            this.addBundle(gridBundle);
        }
        if (toBeClonedObject != null) {
            this.addCloneGrid(toBeClonedObject, gridBundle.getObject3D());
        }
        if (addStemsFlag) {
            String nameBase = name + "_cov";
            Object3DLinkSetBundle coveringStems = this.generateCoveringStems(gridBundle, nameBase, onlyFirstPathMode, sequenceChar, tilerAlgorithm);
            this.addBundle(coveringStems);
        }
    }

    public void addGeometry(Vector3D startPos, double length, String name, String childNameBase, boolean addStemsFlag, char sequenceChar, boolean onlyFirstPathMode, int geometryCode, int tilerAlgorithm) throws Object3DGraphControllerException {
        assert (childNameBase != null);
        Geometry geometry = null;
        if (geometryCode > 100 && geometryCode < 200) {
            geometry = PlanarTools.generateNtagon(geometryCode - 100, length);
        } else if (geometryCode > 200 && geometryCode < 300) {
            geometry = PlanarTools.generatePrism(geometryCode - 200, length, length);
        } else {
            switch (geometryCode) {
                case 10: {
                    geometry = PlatonicTools.generateTetrahedron(length);
                    break;
                }
                case 11: {
                    geometry = PlatonicTools.generateCube(length);
                    break;
                }
                case 12: {
                    geometry = PlatonicTools.generateOctahedron(length);
                    break;
                }
                case 13: {
                    geometry = PlatonicTools.generateDodecahedron(length);
                    break;
                }
                case 14: {
                    geometry = PlatonicTools.generateIcosahedron(length);
                }
            }
        }
        assert (geometry != null);
        Object3DLinkSetBundle bundle = Object3DLinkSetBundleTools.generateBundleFromGeometry(geometry, name, childNameBase, new SimpleObject3D());
        Object3D obj = bundle.getObject3D();
        obj.setPosition(startPos);
        this.addBundle(bundle);
        if (addStemsFlag) {
            String nameBase = name + "_cov";
            Object3DLinkSetBundle coveringStems = this.generateCoveringStems(bundle, nameBase, onlyFirstPathMode, sequenceChar, tilerAlgorithm);
            this.addBundle(coveringStems);
        }
    }

    public void addGraphitGrid(Vector3D startPos, double sideLength, double height, int n1, int n2, String name, Object3D toBeClonedObject, boolean addGridFlag, boolean addStemsFlag, char sequenceChar, boolean onlyFirstPathMode, int tilerAlgorithm) throws Object3DGraphControllerException {
        Object3DLinkSetBundle gridBundle = Grid3DTools.generateGraphitGrid(startPos, sideLength, height, n1, n2, name);
        if (addGridFlag) {
            this.addBundle(gridBundle);
        }
        if (toBeClonedObject != null) {
            this.addCloneGrid(toBeClonedObject, gridBundle.getObject3D());
        }
        if (addStemsFlag) {
            String nameBase = name + "_cov";
            Object3DLinkSetBundle coveringStems = this.generateCoveringStems(gridBundle, nameBase, onlyFirstPathMode, sequenceChar, tilerAlgorithm);
            this.addBundle(coveringStems);
        }
    }

    @Override
    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void addStrand(String name, String seq, Vector3D pos, Vector3D dir, int typeId) throws UnknownSymbolException {
        Object3DLinkSetBundle bundle;
        switch (typeId) {
            case 0: {
                bundle = Rna3DTools.generateSimpleRnaStrand(name, seq, pos, dir);
                log.info("Generating RNA strand!");
                break;
            }
            case 1: {
                bundle = Dna3DTools.generateSimpleDnaStrand(name, seq, pos, dir);
                log.info("Generating DNA strand!");
                break;
            }
            case 2: {
                log.warning("Sorry, cannot generated Protein strand yet!");
                return;
            }
            default: {
                return;
            }
        }
        this.graph.addGraph(bundle.getObject3D());
        this.links.addLinks(bundle.getLinks());
        log.info("the number of links after adding the strand is: " + this.links);
    }

    private Properties alignStructures(Object3DSet objectBlocks1, Object3DSet objectBlocks2, List<Atom3D> atoms1, List<Atom3D> atoms2, int numberSteps) throws Object3DGraphControllerException {
        assert (atoms1.size() == atoms2.size());
        Vector3D v1 = AtomTools.centerOfMass(atoms1);
        Vector3D v2 = AtomTools.centerOfMass(atoms2);
        Vector3D deltaV = v1.minus(v2);
        log.info("Shifting object blocks 2 by vector: " + deltaV);
        for (int i = 0; i < objectBlocks2.size(); ++i) {
            objectBlocks2.get(i).translate(deltaV);
        }
        Random rnd = Randomizer.getInstance();
        String nameBase = "tmp." + rnd.nextDouble();
        SimpleConstraintDouble zeroConstraint = new SimpleConstraintDouble(0.0, 0.0);
        SimpleLinkSet addedLinks = new SimpleLinkSet();
        for (int i = 0; i < atoms1.size(); ++i) {
            SimpleConstraintLink link = new SimpleConstraintLink(atoms1.get(i), atoms2.get(i), zeroConstraint);
            addedLinks.add(link);
        }
        ArrayList<Object3DSet> objectBlocks = new ArrayList<Object3DSet>();
        objectBlocks.add(objectBlocks1);
        objectBlocks.add(objectBlocks2);
        double errorScoreLimit = 0.01;
        double kt = 0.1;
        BasepairOptimizer optimizer = new BasepairOptimizer(addedLinks, objectBlocks, numberSteps, errorScoreLimit, this.basePairDB, null, this.symmetryController.getSymCopies());
        optimizer.setOutputInterval(100000);
        optimizer.setKeepFirstFixedMode(true);
        optimizer.setKT(kt);
        optimizer.setVerboseLevel(0);
        Properties result = optimizer.optimize();
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return result;
    }

    private Properties alignStructuresFast(List<Atom3D> atoms1, List<Atom3D> atoms2, Matrix3D rot, Vector3D mc1, Vector3D mc2) {
        assert (atoms1.size() == atoms2.size());
        Vector3D[] v1 = new Vector3D[atoms1.size()];
        Vector3D[] v2 = new Vector3D[atoms2.size()];
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = atoms1.get(i).getPosition();
            v2[i] = atoms2.get(i).getPosition();
        }
        Properties resultProp = new Properties();
        double result = Superimpose.superimpose(v1, v2, rot, mc1, mc2);
        resultProp.setProperty("score", "" + result);
        return resultProp;
    }

    private List<Atom3D> generateAtomList(List<Residue3D> residues, String[] atomNames) throws Object3DGraphControllerException {
        ArrayList<Atom3D> atoms = new ArrayList<Atom3D>();
        for (int i = 0; i < residues.size(); ++i) {
            for (String name : atomNames) {
                Object3D child = residues.get(i).getChild(name);
                if (child == null || !(child instanceof Atom3D)) {
                    throw new Object3DGraphControllerException("Could not find atom " + name + " in nucleotide " + residues.get(i).getFullName());
                }
                atoms.add((Atom3D)child);
            }
        }
        return atoms;
    }

    public Properties alignStructures(Object3DSet objectBlocks1, Object3DSet objectBlocks2, List<Residue3D> residues1, List<Residue3D> residues2, String[] atomNames, int numberSteps) throws Object3DGraphControllerException {
        if (residues1.size() != residues2.size()) {
            throw new Object3DGraphControllerException("Number of specified residues must be equal for aligning!");
        }
        List<Atom3D> atoms1 = this.generateAtomList(residues1, atomNames);
        List<Atom3D> atoms2 = this.generateAtomList(residues2, atomNames);
        Matrix3D rot = new Matrix3D();
        Vector3D mc1 = new Vector3D();
        Vector3D mc2 = new Vector3D();
        Properties result = this.alignStructuresFast(atoms1, atoms2, rot, mc1, mc2);
        for (int i = 0; i < objectBlocks2.size(); ++i) {
            Object3DTools.applySuperposition(objectBlocks2.get(i), rot, mc1, mc2);
        }
        return result;
    }

    public Properties alignStructures(Object3DSet objectBlocks1, Object3DSet objectBlocks2, String residueDescriptor1, String residueDescriptor2, String[] atomNames, int numberSteps) throws Object3DGraphControllerException {
        Properties result = null;
        try {
            List<Residue3D> residues1 = this.sequences.collectResidues(residueDescriptor1);
            List<Residue3D> residues2 = this.sequences.collectResidues(residueDescriptor2);
            assert (residues1 != null);
            assert (residues2 != null);
            if (residues1.size() == 0 || residues1.size() != residues2.size()) {
                throw new Object3DGraphControllerException("Error in residue specification while aligning structures!");
            }
            System.out.println("Aligning structures by superposing the following residues:");
            for (int i = 0; i < residues1.size(); ++i) {
                System.out.println(residues1.get(i).getFullName() + " : " + residues2.get(i).getFullName() + PackageConstants.NEWLINE);
            }
            result = this.alignStructures(objectBlocks1, objectBlocks2, residues1, residues2, atomNames, numberSteps);
        }
        catch (ParsingException pe) {
            throw new Object3DGraphControllerException(pe.getMessage());
        }
        return result;
    }

    public int bridgeAllStrands(String nameBase, String rootName) throws Object3DGraphControllerException {
        assert (this.graph != null);
        Properties properties = new Properties();
        if (this.bridgeController == null) {
            this.initBridgeController();
        }
        assert (this.bridgeController != null);
        SingleStrandsBridgeFinder bridgesFinder = this.bridgeController.generateSingleStrandBridgesFinder();
        Object3D root = this.graph.getGraph();
        if (nameBase != null) {
            root = this.graph.findByFullName(nameBase);
        }
        if (root == null) {
            throw new Object3DGraphControllerException("Could not find object with name " + nameBase);
        }
        Object3DSet strands = Object3DTools.collectByClassName(root, "RnaStrand");
        if (strands.size() == 0) {
            throw new Object3DGraphControllerException("Could not find any RNA strands in subtree " + nameBase);
        }
        List<Object3DLinkSetBundle> result = bridgesFinder.findBridges(strands);
        log.info("Found " + result.size() + " bridges!");
        if (rootName == null) {
            rootName = this.graph.getGraph().getName();
        }
        for (int i = 0; i < result.size(); ++i) {
            this.graph.addGraph(result.get(i).getObject3D(), rootName);
            this.links.addLinks(result.get(i).getLinks());
        }
        return result.size();
    }

    public Properties bridgeIt(String name1, String name2, String rootName, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMin, int lenMax) throws Object3DGraphControllerException {
        Object3D obj1 = this.graph.findByFullName(name1);
        Object3D obj2 = this.graph.findByFullName(name2);
        Object3D root = this.graph.findByFullName(rootName);
        if (obj1 == null || obj2 == null) {
            throw new Object3DGraphControllerException("Could not find objects: " + name1 + " " + name2);
        }
        return this.bridgeIt(obj1, obj2, root, filePrefix, n, rms, angleWeight, helixAlgorithm, lenMin, lenMax);
    }

    public Properties jBridgeIt(String jName, String rootName, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMin, int lenMax) throws Object3DGraphControllerException {
        LinkSet junctionList = this.links.findLinks(jName);
        Properties properties = new Properties();
        Object3D root = this.graph.findByFullName(rootName);
        if (root == null) {
            throw new Object3DGraphControllerException("Could not find node with name " + rootName);
        }
        if (junctionList == null || junctionList.size() == 0) {
            throw new Object3DGraphControllerException("Could not junction links with name: " + jName);
        }
        for (int i = 0; i < junctionList.size(); ++i) {
            this.jBridgeIt((JunctionMultiConstraintLink)junctionList.get(i), root, filePrefix, n, rms, angleWeight, helixAlgorithm, lenMin, lenMax);
        }
        return properties;
    }

    public Properties extendIt(String name1, String rootName, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMax) throws Object3DGraphControllerException {
        Object3D obj1 = this.graph.findByFullName(name1);
        assert (obj1.getParent() != null);
        Object3D root = this.graph.findByFullName(rootName);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Could not find object: " + name1);
        }
        if (!(obj1 instanceof Nucleotide3D)) {
            throw new Object3DGraphControllerException("Currently strands can only be extended by specifying first or last nucleotide: " + name1);
        }
        if (obj1.getSiblingId() == 0) {
            return this.bridgeIt(null, obj1, root, filePrefix, n, rms, angleWeight, helixAlgorithm, lenMax, lenMax);
        }
        if (obj1.getSiblingId() == obj1.getParent().size() - 1) {
            return this.bridgeIt(obj1, null, root, filePrefix, n, rms, angleWeight, helixAlgorithm, lenMax, lenMax);
        }
        if (Math.sin(0.0) < 10.0) {
            throw new Object3DGraphControllerException("Wrong residue index. Currently strands can only be extended by specifying first or last nucleotide: " + name1);
        }
        return null;
    }

    public Properties bridgeItCombined(String name1, String name2, String name3, String name4, String rootName, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMax, double collisionDistance) throws Object3DGraphControllerException {
        Object3D obj1 = this.graph.findByFullName(name1);
        Object3D obj2 = this.graph.findByFullName(name2);
        Object3D obj3 = this.graph.findByFullName(name3);
        Object3D obj4 = this.graph.findByFullName(name4);
        Object3D root = this.graph.findByFullName(rootName);
        if (obj1 == null || obj2 == null || obj3 == null || obj4 == null || root == null) {
            throw new Object3DGraphControllerException("Could not find objects: " + name1 + " " + name2 + " " + name3 + " " + name4 + " " + root);
        }
        return this.bridgeItCombined(obj1, obj2, obj3, obj4, root, filePrefix, n, rms, angleWeight, helixAlgorithm, lenMax, collisionDistance);
    }

    public Properties bridgeItCombined(Object3D obj1, Object3D obj2, Object3D obj3, Object3D obj4, Object3D root, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMax, double collisionDistance) throws Object3DGraphControllerException {
        Properties properties;
        block11: {
            if (this.bridgeController == null) {
                this.initBridgeController();
            }
            properties = new Properties();
            log.info("Started bridgeIt " + obj1.getFullName() + " " + obj2.getFullName());
            properties.setProperty("name1", obj1.getFullName());
            properties.setProperty("name2", obj2.getFullName());
            properties.setProperty("name3", obj3.getFullName());
            properties.setProperty("name4", obj4.getFullName());
            try {
                this.bridgeController.setAngleWeight(angleWeight);
                this.bridgeController.setLenMax(lenMax);
                this.bridgeController.setRms(rms);
                this.bridgeController.setSolutionMax(n);
                this.bridgeController.setHelixAlgorithm(helixAlgorithm);
                List<Object3DLinkSetBundle> bridges1 = this.bridgeController.findBridge(obj1, obj2);
                List<Object3DLinkSetBundle> bridges2 = this.bridgeController.findBridge(obj3, obj4);
                if (bridges1 != null && bridges2 != null) {
                    log.info("Total number of found bridging fragments: " + bridges1.size() + " " + bridges2.size());
                    Collections.sort(bridges1);
                    Collections.sort(bridges2);
                    for (int i = n - 1; i >= 0; --i) {
                        if (i >= bridges1.size()) continue;
                        Object3D bridge1 = bridges1.get(i).getObject3D();
                        for (int j = n - 1; j >= 0; --j) {
                            if (j >= bridges2.size()) continue;
                            Object3D bridge2 = bridges2.get(j).getObject3D();
                            int colls = AtomTools.countExternalCollisions(bridge1, bridge2, collisionDistance);
                            if (colls > 0) {
                                log.info("Ignoring bridge combination " + (i + 1) + " " + (j + 1) + " because of collisions!");
                                continue;
                            }
                            String name1 = root.insertChildSafe(bridge1);
                            String name2 = root.insertChildSafe(bridge2);
                            GeneralPdbWriter writer = new GeneralPdbWriter();
                            if (filePrefix != null && filePrefix.length() > 0) {
                                String bridgeFileName = filePrefix + (i + 1) + "_" + (j + 1) + ".pdb";
                                try {
                                    FileOutputStream fos = new FileOutputStream(bridgeFileName);
                                    writer.write((OutputStream)fos, root);
                                }
                                catch (IOException ioe) {
                                    log.warning("Could not write file with bridge: " + bridgeFileName);
                                }
                            }
                            if (i == 0 && j == 0) {
                                PropertyTools.mergeProperties(properties, bridge1.getProperties(), name1);
                                this.links.merge(bridges1.get(i).getLinks());
                                this.links.merge(bridges2.get(j).getLinks());
                                log.info("Added top ranking bridge: " + bridge1.getFullName() + " with name " + name1 + " " + name2);
                                continue;
                            }
                            root.removeChild(bridge1);
                            root.removeChild(bridge2);
                        }
                    }
                    break block11;
                }
                log.warning("No bridge could be found between " + obj1.getFullName() + " and " + obj2.getFullName());
            }
            catch (RnaModelException rne) {
                throw new Object3DGraphControllerException("RnaModelException in brigdeController: " + rne.getMessage());
            }
        }
        return properties;
    }

    public Properties bridgeIt(Object3D obj1, Object3D obj2, Object3D root, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMin, int lenMax) throws Object3DGraphControllerException {
        Properties properties;
        block11: {
            assert (obj1 != null || obj2 != null);
            if (this.bridgeController == null) {
                this.initBridgeController();
            }
            properties = new Properties();
            if (obj1 != null) {
                properties.setProperty("name1", obj1.getFullName());
            }
            if (obj2 != null) {
                properties.setProperty("name2", obj2.getFullName());
            }
            try {
                this.bridgeController.setAngleWeight(angleWeight);
                this.bridgeController.setLenMin(lenMin);
                this.bridgeController.setLenMax(lenMax);
                this.bridgeController.setSolutionMax(n);
                this.bridgeController.setRms(rms);
                List<Object3DLinkSetBundle> bridges = this.bridgeController.findBridge(obj1, obj2);
                if (bridges != null) {
                    log.info("Total number of found bridging fragments: " + bridges.size());
                    if (bridges.size() > 0) {
                        Object3D bridge = bridges.get(0).getObject3D();
                        PropertyTools.merge(properties, bridge.getProperties());
                        log.info("Adding top ranking bridge: " + bridge.getFullName());
                        this.graph.addGraph(bridge);
                        GeneralPdbWriter writer = new GeneralPdbWriter();
                        String bridgeFileName = "bridge_tmp.pdb";
                        try {
                            FileOutputStream fos = new FileOutputStream(bridgeFileName);
                            writer.write((OutputStream)fos, bridge);
                        }
                        catch (IOException ioe) {
                            log.warning("Could not write file with bridge: " + bridgeFileName);
                        }
                        this.links.merge(bridges.get(0).getLinks());
                        break block11;
                    }
                    log.info("Could not find bridge solution " + (n + 1) + " for specified geometry.");
                    break block11;
                }
                assert (false);
            }
            catch (RnaModelException rne) {
                throw new Object3DGraphControllerException("RnaModelException in brigdeController: " + rne.getMessage());
            }
        }
        return properties;
    }

    public Properties jBridgeIt(JunctionMultiConstraintLink jLink, Object3D root, String filePrefix, int n, double rms, double angleWeight, int helixAlgorithm, int lenMin, int lenMax) throws Object3DGraphControllerException {
        Properties properties;
        block10: {
            assert (jLink != null);
            if (this.bridgeController == null) {
                this.initBridgeController();
            }
            properties = new Properties();
            properties.setProperty("name", jLink.getName());
            try {
                this.bridgeController.setAngleWeight(angleWeight);
                this.bridgeController.setLenMin(lenMin);
                this.bridgeController.setLenMax(lenMax);
                this.bridgeController.setSolutionMax(n);
                this.bridgeController.setRms(rms);
                List<Object3DLinkSetBundle> bridges = this.bridgeController.findBridges(jLink);
                if (bridges != null) {
                    log.info("Total number of found bridges: " + bridges.size());
                    if (bridges.size() > 0) {
                        for (int i = 0; i < bridges.size(); ++i) {
                            Object3D bridge = bridges.get(i).getObject3D();
                            PropertyTools.merge(properties, bridge.getProperties());
                            log.info("Adding top ranking bridge: " + bridge.getFullName());
                            this.graph.addGraph(bridge);
                            GeneralPdbWriter writer = new GeneralPdbWriter();
                            String bridgeFileName = "bridge_tmp.pdb";
                            try {
                                FileOutputStream fos = new FileOutputStream(bridgeFileName);
                                writer.write((OutputStream)fos, bridge);
                            }
                            catch (IOException ioe) {
                                log.warning("Could not write file with bridge: " + bridgeFileName);
                            }
                            this.links.merge(bridges.get(i).getLinks());
                        }
                        break block10;
                    }
                    log.info("Could not find bridge solution " + (n + 1) + " for specified geometry.");
                    break block10;
                }
                assert (false);
            }
            catch (RnaModelException rne) {
                throw new Object3DGraphControllerException("RnaModelException in brigdeController: " + rne.getMessage());
            }
        }
        return properties;
    }

    public void clear() {
        this.links.clear();
        this.graph.clear();
        this.symmetryController.clear();
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    @Override
    public void fireModelChanged(ModelChangeEvent changeEvent) {
        for (int i = 0; i < this.modelChangeListeners.size(); ++i) {
            ModelChangeListener listener = this.modelChangeListeners.get(i);
            listener.modelChanged(changeEvent);
        }
    }

    private void fireModelChangedOnGraphAndLinkController(ModelChangeEvent event) {
        this.graph.fireModelChanged(event);
        this.links.fireModelChanged(event);
    }

    static SequenceCollector generateCollectedSequences(Object3D root) {
        SequenceCollector collector = new SequenceCollector();
        Object3DActionVisitor visitor = new Object3DActionVisitor(root, collector);
        visitor.nextToEnd();
        return collector;
    }

    public Object3DLinkSetBundle generateCoveringStems(Object3DLinkSetBundle bundle, String nameBase, boolean onlyFirstPathMode, char sequenceChar, int tilerAlgorithm) throws Object3DGraphControllerException {
        log.info("starting generateCoveringStems.");
        GridTiler tiler = null;
        switch (tilerAlgorithm) {
            case 1: {
                tiler = new SimpleGridTiler(this.nucleotideDB);
                break;
            }
            case 2: {
                tiler = new CompleteGridTiler(this.nucleotideDB);
                break;
            }
            case 3: {
                tiler = new RandomGridTiler(this.nucleotideDB);
                break;
            }
            case 4: {
                if (!this.junctionController.isValid()) {
                    throw new Object3DGraphControllerException("Junction Database is not defined yet! Use Options menu.");
                }
                this.updateFragmentGridTiler();
                tiler = this.fgTiler;
                break;
            }
            case 5: {
                if (!this.junctionController.isValid()) {
                    throw new Object3DGraphControllerException("Junction Database is not defined yet! Use Options menu.");
                }
                tiler = new DebugGridTiler(this.junctionController.getJunctionDB());
                break;
            }
            case 6: {
                if (!this.junctionController.isValid()) {
                    throw new Object3DGraphControllerException("Junction/Kissing loop Database is not defined yet! Use Options menu.");
                }
                tiler = new DebugGridTiler(this.junctionController.getKissingLoopDB());
                break;
            }
            default: {
                throw new Object3DGraphControllerException("Unknow tiling algorithm id!");
            }
        }
        Object3DLinkSetBundle stemBundle = tiler.generateTiling(bundle.getObject3D(), bundle.getLinks(), nameBase, sequenceChar, onlyFirstPathMode);
        log.fine("Generated stems: " + stemBundle.getObject3D());
        return stemBundle;
    }

    public JunctionCollector generateJunctions() {
        log.fine("generating junctions");
        JunctionCollector collector = new JunctionCollector();
        if (this.graph != null && this.graph.getGraph() != null) {
            Object3DActionVisitor visitor = new Object3DActionVisitor(this.graph.getGraph(), collector);
            visitor.nextToEnd();
        }
        return collector;
    }

    public void generateRingFixConstraints(String[] names) {
        Object3DSet junctions = Object3DTools.collectByClassName(this.getGraph().getGraph(), names, "StrandJunction3D");
        junctions.merge(Object3DTools.collectByClassName(this.getGraph().getGraph(), names, "KissingLoop3D"));
        log.info("Found " + junctions + " junctions or kissing loops.");
        RingFixLinkGenerator fixer = new RingFixLinkGenerator(junctions);
        fixer.run();
        LinkSet ringConstraints = fixer.getLinks();
        assert (ringConstraints != null);
        if (ringConstraints.size() > 0) {
            log.info("Adding " + ringConstraints.size() + " ring helix constraints.");
        } else {
            log.warning("No ring helix constraints could be found!");
        }
        this.links.merge(ringConstraints);
    }

    public SymmetryController getSymmetryController() {
        return this.symmetryController;
    }

    public void ringFuseStrands(String[] names, String resultRoot, String resultName) throws Object3DGraphControllerException {
        if (names == null || names.length == 0) {
            names = new String[]{this.getGraph().getGraph().getFullName()};
        }
        Object3DSet junctions = Object3DTools.collectByClassName(this.getGraph().getGraph(), names, "StrandJunction3D");
        assert (junctions != null);
        Object3DSet strands = Object3DTools.collectByClassName(this.getGraph().getGraph(), "RnaStrand");
        assert (strands != null);
        if (junctions.size() == 0 || strands.size() == 0) {
            throw new Object3DGraphControllerException("No strands or junctions available for fusing!");
        }
        for (int i = 0; i < strands.size(); ++i) {
            assert (strands.get(i).getClassName().equals("RnaStrand"));
        }
        junctions.merge(Object3DTools.collectByClassName(this.getGraph().getGraph(), names, "KissingLoop3D"));
        RingFuser fuser = new RingFuser(junctions, strands);
        fuser.run();
        List<RnaStrand> fusedStrands = fuser.getFusedStrands();
        if (fusedStrands.size() == 0) {
            throw new Object3DGraphControllerException("No strands were fused!");
        }
        Vector3D position = Object3DSetTools.centerOfMass(new SimpleObject3DSet(fusedStrands));
        assert (position.isValid());
        SimpleObject3D helpRoot = new SimpleObject3D(position);
        helpRoot.setName(resultName);
        for (RnaStrand strand : fusedStrands) {
            helpRoot.insertChild(strand);
        }
        this.getGraph().addGraph(helpRoot, resultRoot);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void fuseAllStrands(String strandRoot, String resultName, String resultRoot, double scoreCutoff, double bridgeRms, int lengthMin, int lengthMax) throws Object3DGraphControllerException {
        Object3DSet strands = Object3DTools.collectByClassName(this.getGraph().getGraph(strandRoot), "RnaStrand");
        assert (strands != null);
        if (strands.size() == 0) {
            throw new Object3DGraphControllerException("No strands or junctions available for fusing!");
        }
        for (int i = 0; i < strands.size(); ++i) {
            assert (strands.get(i).getClassName().equals("RnaStrand"));
        }
        if (this.bridgeController == null) {
            this.initBridgeController();
        }
        SingleStrandBridgeFinder ssBridgeFinder = this.bridgeController.generateSingleStrandBridgeFinder();
        ssBridgeFinder.setRms(bridgeRms);
        ssBridgeFinder.setLenMin(lengthMin);
        ssBridgeFinder.setLenMax(lengthMax);
        StrandFuser fuser = new StrandFuser(strands, ssBridgeFinder);
        fuser.setScoreCutoff(scoreCutoff);
        fuser.run();
        List<RnaStrand> fusedStrands = fuser.getFusedStrands();
        if (fusedStrands.size() == 0) {
            throw new Object3DGraphControllerException("No strands were fused!");
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public Properties fuseClosestStrands(String strandRoot, String resultName, String resultRoot, double scoreCutoff, double bridgeRms, int lengthMin, int lengthMax) throws Object3DGraphControllerException {
        Object3DSet strands = Object3DTools.collectByClassName(this.getGraph().getGraph(strandRoot), "RnaStrand");
        assert (strands != null);
        if (strands.size() == 0) {
            throw new Object3DGraphControllerException("No strands or junctions available for fusing!");
        }
        for (int i = 0; i < strands.size(); ++i) {
            assert (strands.get(i).getClassName().equals("RnaStrand"));
        }
        SimpleStrandFuser fuser = new SimpleStrandFuser(strands);
        fuser.setScoreCutoff(scoreCutoff);
        fuser.run();
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return (Properties)fuser.getResult();
    }

    public int fuseAllClosestStrands(String strandRoot, String resultName, String resultRoot, double scoreCutoff) throws Object3DGraphControllerException {
        SimpleStrandFuser fuser = null;
        int count = 0;
        do {
            Object3DSet strands = Object3DTools.collectByClassName(this.getGraph().getGraph(strandRoot), "RnaStrand");
            assert (strands != null);
            if (strands.size() == 0) {
                throw new Object3DGraphControllerException("No strands or junctions available for fusing!");
            }
            fuser = new SimpleStrandFuser(strands);
            fuser.setScoreCutoff(scoreCutoff);
            fuser.run();
            ++count;
        } while (((Properties)fuser.getResult()).getProperty("score") != null);
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return --count;
    }

    public MutableSecondaryStructure generateSecondaryStructure() throws DuplicateNameException {
        if (this.graph.getGraph() == null) {
            return null;
        }
        log.fine("Generating secondary structure");
        InteractionSet hbondInteractions = this.links.getHydrogenBondInteractions();
        UnevenAlignment unevenAlignment = null;
        unevenAlignment = this.sequences.getUnevenAlignment();
        log.fine("Number found sequences: " + unevenAlignment.getSequenceCount() + " number of hydrogen bond interactions: " + hbondInteractions);
        SimpleMutableSecondaryStructure structure = new SimpleMutableSecondaryStructure(unevenAlignment, hbondInteractions);
        structure.purgeOverlappingInteractions(1);
        return structure;
    }

    public String generateSignature(String fullName) throws Object3DGraphControllerException {
        Object3D obj = this.graph.findByFullName(fullName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object: " + fullName);
        }
        SignatureTranslatorCanonizer canonizer = new SignatureTranslatorCanonizer();
        String result = "";
        try {
            result = canonizer.generateCanonizedRepresentation(new SimpleObject3DLinkSetBundle(obj, this.links));
        }
        catch (AlgorithmFailureException afe) {
            throw new Object3DGraphControllerException(afe.getMessage());
        }
        return result;
    }

    private String generateSymgenCommands(int numSymmetries) {
        StringBuffer buf = new StringBuffer();
        buf.append(SymmetryTools.generateSymgenCommandsSimple(this.spaceGroup, this.cell));
        if (numSymmetries > 0) {
            char currentChar = 'A';
            for (int i = 0; i < numSymmetries; ++i) {
                for (int j = 0; j < this.sequences.getSequenceCount(); ++j) {
                    BioPolymer strand = (BioPolymer)this.sequences.getSequence(j);
                    char origChar = GeneralPdbWriter.getOriginalStrandChar(strand);
                    buf.append("CHAIN SYMMETRY " + (i + 1) + " " + origChar + " " + currentChar + PackageConstants.NEWLINE);
                    currentChar = GeneralPdbWriter.nextStrandChar(currentChar);
                }
            }
        }
        return buf.toString();
    }

    public BasePairController getBasePairDB() {
        return this.basePairDB;
    }

    public BindingSiteController getBindingSites() {
        return this.bindingSites;
    }

    public Cell getCell() {
        return this.cell;
    }

    public FragmentGridTiler getFragmentGridTiler() {
        return this.fgTiler;
    }

    public Object3DController getGraph() {
        return this.graph;
    }

    public JunctionController getJunctionController() {
        return this.junctionController;
    }

    public Kaleidoscope getKaleidoscope() {
        return this.kaleidoscope;
    }

    public String getLastReadDirectory() {
        return this.lastReadDirectory;
    }

    public LinkController getLinks() {
        return this.links;
    }

    private Shape3D getSelectionCursorShape() {
        Object3D selectionCursor = this.graph.getSelectionCursor();
        if (selectionCursor == null) {
            return null;
        }
        Cube shape = new Cube(selectionCursor.getPosition(), this.selectionCursorRadius);
        shape.setAppearance(this.selectionCursorAppearance);
        return shape;
    }

    private Shape3D getSelectionRootShape() {
        Object3D selectionRoot = this.graph.getSelectionRoot();
        if (selectionRoot == null) {
            return null;
        }
        Cube shape = new Cube(selectionRoot.getPosition(), this.selectionRootRadius);
        log.fine("calling Object3DGraphController.getSelectionRootShape");
        shape.setAppearance(this.selectionRootAppearance);
        return shape;
    }

    public SequenceController getSequences() {
        return this.sequences;
    }

    public Shape3DSet getShapeSet() {
        if (this.shapeSet == null) {
            this.refreshShapeSet();
        }
        assert (this.shapeSet != null);
        return this.shapeSet;
    }

    public SpaceGroup getSpaceGroup() {
        return this.spaceGroup;
    }

    private int getSpaceGroupSymmetryCount() throws Object3DGraphControllerException {
        int result = this.spaceGroupSymmetryCount;
        if (result <= 0) {
            result = SymmetryTools.computeSpaceGroupSymmetryCount(this.spaceGroup);
        }
        return result;
    }

    private void initSpaceGroupFactory() throws Object3DGraphControllerException {
        try {
            String fileName = rb.getString("spacegroups.prmfile");
            FileInputStream fis = new FileInputStream(fileName);
            this.spaceGroupFactory.init(fis);
            assert (this.spaceGroupFactory.isValid());
        }
        catch (IOException ioe) {
            throw new Object3DGraphControllerException(ioe.getMessage());
        }
        catch (ParsingException pe) {
            throw new Object3DGraphControllerException(pe.getMessage());
        }
        assert (this.spaceGroupFactory.isValid());
    }

    public boolean isValid() {
        return this.getGraph().getObjectCount() > 0;
    }

    public void minimize(int steps, double scale, int algorithmCode) throws InvalidParametersException {
        SimpleMinimizationParameters parameters = new SimpleMinimizationParameters();
        parameters.setTimeStepMax(steps);
        parameters.setForceField(this.forceFieldFactory.generateForceField());
        parameters.setPrototype(new Nucleotide3D());
        SimpleObject3DSet objectSet = new SimpleObject3DSet(this.graph.getGraph());
        ModelChanger minimizer = null;
        double energyCutoff = 10.0;
        switch (algorithmCode) {
            case 1: {
                minimizer = new MonteCarloMinimizer(objectSet, this.links, parameters);
                break;
            }
            default: {
                log.warning("could not interpret algorithm id!");
            }
        }
        minimizer.addModelChangeListener(this);
        log.fine("Starting minimization!");
        new Thread((Runnable)((Object)minimizer)).start();
        log.fine("Started minimization thread!");
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        log.fine("Called modelChanged: " + event.getEventId());
        this.refresh(event);
    }

    private RnaInteractionType extractRnaInteractionType(Link link) {
        if (!(link instanceof InteractionLink)) {
            return null;
        }
        Interaction interaction = ((InteractionLink)link).getInteraction();
        InteractionType interactionType = interaction.getInteractionType();
        if (!(interactionType instanceof RnaInteractionType)) {
            return null;
        }
        return (RnaInteractionType)interactionType;
    }

    public String fuseStrands(String strandFullName1, String strandFullName2) throws Object3DGraphControllerException {
        String appendedStrandName = this.graph.fuseStrands(strandFullName1, strandFullName2);
        this.refresh(new ModelChangeEvent((Object)this, 4));
        return appendedStrandName;
    }

    private void overwriteBasePairSequences(String[] sequenceStrings, InteractionLink basePair, Set<Mutation> mutations, double rmsLimit, boolean forceMode) throws FittingException, RnaModelException {
        Object3D objOld1 = basePair.getObj1();
        Object3D objOld2 = basePair.getObj2();
        if (!(objOld1 instanceof Nucleotide3D)) {
            throw new RnaModelException("Object " + objOld1.getName() + " is not a nucleotide object!");
        }
        if (!(objOld2 instanceof Nucleotide3D)) {
            throw new RnaModelException("Object " + objOld2.getName() + " is not a nucleotide object!");
        }
        Nucleotide3D oldNuc1 = (Nucleotide3D)objOld1;
        Nucleotide3D oldNuc2 = (Nucleotide3D)objOld2;
        RnaStrand strand1 = null;
        RnaStrand strand2 = null;
        if (!(oldNuc1.getParent() instanceof RnaStrand)) {
            throw new RnaModelException("Nucleotide does not have RNA strand as parent object: " + oldNuc1.getName());
        }
        if (!(oldNuc2.getParent() instanceof RnaStrand)) {
            throw new RnaModelException("Nucleotide does not have RNA strand as parent object: " + oldNuc2.getName());
        }
        strand1 = (RnaStrand)oldNuc1.getParent();
        strand2 = (RnaStrand)oldNuc2.getParent();
        String strand1Name = strand1.getName();
        String strand2Name = strand2.getName();
        int n1 = oldNuc1.getPos();
        int n2 = oldNuc2.getPos();
        if (mutations != null) {
            boolean found1 = false;
            boolean found2 = false;
            for (Mutation mut : mutations) {
                if (mut.getPos() == n1 && mut.getSequenceName().equals(strand1Name)) {
                    found1 = true;
                }
                if (mut.getPos() == n2 && mut.getSequenceName().equals(strand2Name)) {
                    found2 = true;
                }
                if (!found1 || !found2) continue;
                break;
            }
            if (!found1 || !found2) {
                return;
            }
        }
        if (NucleotideTools.isAtStrandEnd(oldNuc1) || NucleotideTools.isAtStrandEnd(oldNuc2)) {
            log.info("Detected mutation at strand end. Allowing for less strict rms error: " + (rmsLimit += 0.5));
        }
        int strandId1 = this.sequences.getSequenceId(strand1);
        int strandId2 = this.sequences.getSequenceId(strand2);
        assert (strandId1 >= 0);
        assert (strandId2 >= 0);
        char c1New = sequenceStrings[strandId1].charAt(n1);
        char c2New = sequenceStrings[strandId2].charAt(n2);
        char c1Old = oldNuc1.getSymbol().getCharacter();
        char c2Old = oldNuc2.getSymbol().getCharacter();
        if (c1Old == c1New && c2Old == c2New && !forceMode) {
            return;
        }
        InteractionType interactionType = basePair.getInteraction().getInteractionType();
        try {
            SimpleLetterSymbol newSymbol1 = new SimpleLetterSymbol(c1New, DnaTools.AMBIGUOUS_RNA_ALPHABET);
            SimpleLetterSymbol newSymbol2 = new SimpleLetterSymbol(c2New, DnaTools.AMBIGUOUS_RNA_ALPHABET);
            if (!(interactionType instanceof RnaInteractionType)) {
                throw new RnaModelException("Link does not discribe and RNA base pair: " + basePair);
            }
            RnaStrandTools.mutateBasePair(basePair, newSymbol1, newSymbol2, (RnaInteractionType)interactionType, this.basePairDB, rmsLimit, this.links);
        }
        catch (UnknownSymbolException use) {
            throw new RnaModelException("Unknown sequence symbol found: " + use.getMessage());
        }
    }

    private void overwriteSequences(String[] sequenceStrings, Set<Mutation> mutations, double rmsLimit, boolean forceMode) throws Object3DGraphControllerException {
        int i;
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("No nucleotide database defined!");
        }
        if (this.basePairDB == null) {
            throw new Object3DGraphControllerException("No base pair database defined!");
        }
        String[] origSequenceStrings = this.sequences.getSequenceStrings();
        block9: for (i = 0; i < this.links.size(); ++i) {
            Link link = this.links.get(i);
            RnaInteractionType rnaInteractionType = this.extractRnaInteractionType(link);
            if (rnaInteractionType == null) continue;
            switch (rnaInteractionType.getSubTypeId()) {
                case -1: {
                    continue block9;
                }
                case 6: {
                    continue block9;
                }
                case 0: {
                    continue block9;
                }
                case 1: {
                    try {
                        this.overwriteBasePairSequences(sequenceStrings, (InteractionLink)link, mutations, rmsLimit, forceMode);
                    }
                    catch (RnaModelException rme) {
                        log.info("Could not mutate base pair: " + rme.getMessage());
                    }
                    catch (FittingException fe) {
                        log.info("Could fit mutated base pair: " + fe.getMessage());
                    }
                    continue block9;
                }
                default: {
                    log.warning("Sorry, mutating residue pair " + rnaInteractionType + " is not yet implemented!");
                }
            }
        }
        for (i = 0; i < sequenceStrings.length; ++i) {
            this.sequences.overwriteSequence(sequenceStrings[i], i, this.nucleotideDB, rmsLimit, (LinkSet)this.links);
        }
    }

    public void mutateSequences(Set<Mutation> mutations, double rmsLimit, boolean forceMode) throws Object3DGraphControllerException {
        Iterator<Mutation> iterator = mutations.iterator();
        String[] sequenceStrings = this.sequences.getSequenceStrings();
        while (iterator.hasNext()) {
            Mutation mut = iterator.next();
            int seqId = this.sequences.getSequenceId(mut.getSequenceName());
            if (seqId < 0) {
                throw new Object3DGraphControllerException("Unknown sequence name: " + mut.getSequenceName());
            }
            int pos = mut.getPos();
            char newChar = mut.getCharacter();
            String s = sequenceStrings[seqId];
            StringBuffer buf = new StringBuffer(s);
            log.info("Mutating sequence character: " + (pos + 1) + " " + buf.charAt(pos) + " to " + newChar);
            buf.setCharAt(pos, newChar);
            sequenceStrings[seqId] = buf.toString();
        }
        this.overwriteSequences(sequenceStrings, mutations, rmsLimit, forceMode);
    }

    public void generateHelix(BranchDescriptor3D bd1, BranchDescriptor3D bd2, char c1, char c2, FitParameters stemFitParameters, String stemRootName, int numBasePairs, String helixName) throws FittingException, Object3DGraphControllerException {
        assert (stemFitParameters != null);
        if (helixName == null) {
            helixName = "h_" + bd1.getName() + "_" + bd2.getName();
        }
        int connectionAlgorithm = 4;
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("No reference nucleotides defined. Consider command loadnucleotides.");
        }
        Object3DLinkSetBundle stemBundle = ConnectJunctionTools.generateConnectingStem(bd1, bd2, c1, c2, helixName, stemFitParameters, this.nucleotideDB, connectionAlgorithm, numBasePairs);
        if (stemBundle != null) {
            if (stemBundle.getObject3D() == null) {
                log.info("No stems were generated!");
                throw new FittingException("No helix could be generated for " + bd1.getName() + " and " + bd2.getName());
            }
        } else {
            log.fine("No stems and links were generated!");
            throw new FittingException("No helix could be generated for " + bd1.getName() + " and " + bd2.getName());
        }
        this.graph.addGraph(stemBundle.getObject3D(), stemRootName);
        this.links.merge(stemBundle.getLinks());
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void generateHelix(BranchDescriptor3D bd1, char c1, char c2, String stemRootName, int numBasePairs, String helixName, boolean propagate) throws FittingException, Object3DGraphControllerException {
        if (helixName == null) {
            helixName = "h_" + bd1.getName();
        }
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("No reference nucleotides defined. Consider command loadnucleotides.");
        }
        if (propagate) {
            bd1.propagate(1);
        }
        Object3DLinkSetBundle stemBundle = null;
        stemBundle = ConnectJunctionTools.generateIdealStem(bd1, c1, c2, helixName, this.nucleotideDB, numBasePairs);
        if (stemBundle == null || stemBundle.getObject3D() == null) {
            log.info("No stems were generated!");
            if (propagate) {
                bd1.propagate(-1);
            }
            throw new FittingException("No helix could be generated for " + bd1.getName());
        }
        this.graph.addGraph(stemBundle.getObject3D(), stemRootName);
        this.links.merge(stemBundle.getLinks());
        if (propagate) {
            bd1.propagate(-1);
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void generateIsolatedHelix(CoordinateSystem3D cs, HelixParameters helixParameters, char c1, char c2, String stemRootName, String helixName, int numBasePairs) throws FittingException, Object3DGraphControllerException {
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("No reference nucleotides defined. Consider command loadnucleotides.");
        }
        Object3DLinkSetBundle stemBundle = ConnectJunctionTools.generateIdealStem(cs, helixParameters, c1, c2, helixName, this.nucleotideDB, numBasePairs);
        if (stemBundle == null || stemBundle.getObject3D() == null) {
            log.info("No stems were generated!");
            throw new FittingException("No helix could be generated for " + cs + " and nucleotide characters " + c1 + " " + c2);
        }
        this.graph.addGraph(stemBundle.getObject3D(), stemRootName);
        this.links.merge(stemBundle.getLinks());
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void generateHelix(String bd1Name, String bd2Name, char c1, char c2, FitParameters stemFitParameters, String stemRootName, int numBasePairs, String helixName) throws FittingException, Object3DGraphControllerException {
        assert (stemFitParameters != null);
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), bd1Name);
        Object3D obj2 = Object3DTools.findByFullName(this.graph.getGraph(), bd2Name);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + obj1);
        }
        if (obj2 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + obj2);
        }
        if (!(obj1 instanceof BranchDescriptor3D)) {
            throw new Object3DGraphControllerException("Specified object is not a helix descriptor: " + bd1Name);
        }
        if (!(obj2 instanceof BranchDescriptor3D)) {
            throw new Object3DGraphControllerException("Specified object is not a helix descriptor: " + bd2Name);
        }
        this.generateHelix((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2, c1, c2, stemFitParameters, stemRootName, numBasePairs, helixName);
    }

    public void generateHelix(String bd1Name, char c1, char c2, String stemRootName, int numBasePairs, String helixName, boolean propagate) throws FittingException, Object3DGraphControllerException {
        Object3D obj1 = Object3DTools.findByFullName(this.graph.getGraph(), bd1Name);
        if (obj1 == null) {
            throw new Object3DGraphControllerException("Cannot find object: " + obj1);
        }
        if (!(obj1 instanceof BranchDescriptor3D)) {
            throw new Object3DGraphControllerException("Specified object is not a helix descriptor: " + bd1Name);
        }
        this.generateHelix((BranchDescriptor3D)obj1, c1, c2, stemRootName, numBasePairs, helixName, propagate);
    }

    public Properties generateJunction(String cornerName, String rootName, double offset, double distMin, double distMax, int angleDiv) throws Object3DGraphControllerException {
        log.info("Starting generateJunction vertex: " + cornerName + " root: " + rootName + " offset: " + offset + " distmin/max:" + distMin + " " + distMax);
        Object3D corner = this.graph.findByFullName(cornerName);
        if (corner == null) {
            throw new Object3DGraphControllerException("Could not find graph corner with name " + cornerName);
        }
        Vector3D cornerPosition = corner.getPosition();
        LinkSet neighborLinks = this.links.findLinks(corner);
        if (neighborLinks == null || neighborLinks.size() == 0) {
            throw new Object3DGraphControllerException("Could not find linked neighbors for graph corner with name " + cornerName);
        }
        Vector3D[] neighborPositions = new Vector3D[neighborLinks.size()];
        for (int i = 0; i < neighborLinks.size(); ++i) {
            neighborPositions[i] = neighborLinks.get(i).getPartner(corner).getPosition();
            assert (neighborPositions[i] != null);
            assert (neighborPositions[i].distance(cornerPosition) > 0.0);
        }
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("No reference nucleotides defined. Use command loadnucleotides.");
        }
        GraphJunctionFactory junctionFactory = new GraphJunctionFactory(corner.getPosition(), neighborPositions, this.nucleotideDB);
        junctionFactory.setOffset(offset);
        junctionFactory.setDistMin(distMin);
        junctionFactory.setDistMax(distMax);
        junctionFactory.setAngleDiv(angleDiv);
        Properties properties = new Properties();
        try {
            Object3DLinkSetBundle result = junctionFactory.generate();
            assert (result != null && result.getObject3D().size() > 0);
            properties = result.getObject3D().getProperties();
            if (rootName == null) {
                this.graph.addGraph(result.getObject3D());
            } else {
                this.graph.addGraph(result.getObject3D(), rootName);
            }
            this.links.merge(result.getLinks());
        }
        catch (Object3DException oe) {
            throw new Object3DGraphControllerException("Graph Junction Factory could not generate Junction from graph: " + oe.getMessage());
        }
        return properties;
    }

    public Properties optimizeRnaIntegerGraph(String rootName, int numIter, double threshold, double offset, int verboseLevel) throws Object3DGraphControllerException {
        log.info("Called optimizeRnaIntegerGraph with root: " + rootName + " iter: " + numIter + " thresh: " + threshold + " offset: " + offset);
        Object3D obj = this.graph.findByFullName(rootName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name " + rootName);
        }
        Object3DSet graphSet = Object3DLinkSetBundleTools.generateGraphSet(obj, this.getLinks());
        LinkSet graphLinks = Object3DLinkSetBundleTools.generateGraphLinks(obj, this.getLinks());
        RnaIntegerPotential potential = new RnaIntegerPotential(graphSet, graphLinks, RnaConstants.TURN_HEIGHT, offset);
        MonteCarloOptimizer optimizer = new MonteCarloOptimizer();
        optimizer.setKt(0.2);
        optimizer.setIterMax(numIter);
        optimizer.setVerboseLevel(verboseLevel);
        OptimizationNDResult optResult = optimizer.optimize(potential, potential.generateLowPosition());
        Properties result = new Properties();
        result.setProperty("opt_value", "" + optResult.getBestValue());
        if (optResult.getBestValue() < threshold) {
            log.info("Setting optimized graph positions!");
            double[] positions = optResult.getBestPosition();
            for (int i = 0; i < graphSet.size(); ++i) {
                Vector3D v = new Vector3D(positions[3 * i], positions[3 * i + 1], positions[3 * i + 2]);
                graphSet.get(i).setPosition(v);
            }
        } else {
            log.info("Not copying coordinates because threshold " + threshold + " not reached in optimization: " + optResult.getBestValue());
        }
        return result;
    }

    public Properties traceRnaGraph(String rootName, int numIter, double kt, double threshold, double offset, double distMax, double distMin, String baseName, int verboseLevel, boolean generateBridges, int helixLenMax) throws Object3DGraphControllerException {
        log.info("Called traceRnaGraph with root: " + rootName + " iter: " + numIter + " thresh: " + threshold + " distmax/min:" + distMax + " " + distMin + " offset: " + offset + " max helix length: " + helixLenMax);
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("Cannot start traceRnaGraph: No nucleotide database defined.");
        }
        if (!Object3DTools.validateName(baseName)) {
            throw new Object3DGraphControllerException("Cannot start traceRnaGraph: Invalid base name: " + baseName);
        }
        Object3D obj = this.graph.findByFullName(rootName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name " + rootName);
        }
        Object3DSet graphSet = Object3DLinkSetBundleTools.generateGraphSet(obj, this.getLinks());
        LinkSet graphLinks = Object3DLinkSetBundleTools.generateGraphLinks(obj, this.getLinks());
        log.info("Found " + graphLinks.size() + " graph links to be traced by RNA.");
        if (!TraceRnaPotential.validate(graphSet, graphLinks, RnaConstants.TURN_HEIGHT, offset)) {
            throw new Object3DGraphControllerException("The graph to be traced by RNA did not validate with the provided helix parameters. It probably contains too short edges.");
        }
        TraceRnaPotential potential = new TraceRnaPotential(graphSet, graphLinks, RnaConstants.TURN_HEIGHT, offset, distMax, distMin, helixLenMax);
        potential.setGenerateBridgesMode(generateBridges);
        potential.setVerboseLevel(verboseLevel);
        MonteCarloOptimizer optimizer = new MonteCarloOptimizer();
        optimizer.setIterMax(numIter);
        optimizer.setKt(kt);
        optimizer.setVerboseLevel(verboseLevel);
        log.info("Starting Monte Carlop optimization with " + numIter + " steps and temperature " + kt);
        OptimizationNDResult optResult = optimizer.optimize(potential, potential.generateLowPosition());
        log.info("Trace helix optimization finished with properties: " + optResult);
        Properties result = new Properties();
        result.setProperty("opt_value", "" + optResult.getBestValue());
        assert (this.nucleotideDB != null);
        if (optResult.getBestValue() < threshold) {
            log.info("Adding traced RNA graph!");
            assert (optResult.getBestPosition() != null);
            List<Object3DLinkSetBundle> bridgeBundle = null;
            if (generateBridges) {
                if (this.bridgeController == null) {
                    this.initBridgeController();
                }
                bridgeBundle = this.bridgeController.getBundleList();
            }
            Object3DLinkSetBundle bundle = potential.generateRna(optResult.getBestPosition(), baseName, this.nucleotideDB, bridgeBundle);
            this.graph.addGraph(bundle.getObject3D());
            this.links.merge(bundle.getLinks());
            log.info("Finished Adding traced RNA graph!");
        }
        this.fireModelChangedOnGraphAndLinkController(new ModelChangeEvent((Object)this, 4));
        return result;
    }

    public Properties traceAndModifyRnaGraph(String rootName, int numIter, double kt, double threshold, double offset, double distMax, double distMin, String baseName, int verboseLevel) throws Object3DGraphControllerException {
        LinkSet graphLinks;
        log.info("Called traceRnaGraph with root: " + rootName + " iter: " + numIter + " thresh: " + threshold + " distmax/min:" + distMax + " " + distMin + " offset: " + offset);
        if (this.nucleotideDB == null) {
            throw new Object3DGraphControllerException("Cannot start traceRnaGraph: No nucleotide database defined.");
        }
        if (!Object3DTools.validateName(baseName)) {
            throw new Object3DGraphControllerException("Cannot start traceRnaGraph: Invalid base name: " + baseName);
        }
        Object3D obj = this.graph.findByFullName(rootName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name " + rootName);
        }
        Object3DSet graphSet = Object3DLinkSetBundleTools.generateGraphSet(obj, this.getLinks());
        if (!TraceRnaGraphPotential.validate(graphSet, graphLinks = Object3DLinkSetBundleTools.generateGraphLinks(obj, this.getLinks()), RnaConstants.TURN_HEIGHT, offset)) {
            throw new Object3DGraphControllerException("The graph to be traced by RNA did not validate with the provided helix parameters. It probably contains too short edges.");
        }
        TraceRnaGraphPotential potential = new TraceRnaGraphPotential(graphSet, graphLinks, RnaConstants.TURN_HEIGHT, offset, distMax, distMin);
        potential.setVerboseLevel(verboseLevel);
        MonteCarloOptimizer optimizer = new MonteCarloOptimizer();
        optimizer.setIterMax(numIter);
        optimizer.setKt(kt);
        optimizer.setVerboseLevel(verboseLevel);
        log.info("Starting Monte Carlop optimization with " + numIter + " steps and temperature " + kt);
        OptimizationNDResult optResult = optimizer.optimize(potential, potential.generateLowPosition());
        log.info("Trace helix optimization finished with properties: " + optResult);
        Properties result = new Properties();
        result.setProperty("opt_value", "" + optResult.getBestValue());
        assert (this.nucleotideDB != null);
        if (optResult.getBestValue() < threshold) {
            log.info("Adding traced RNA graph!");
            assert (optResult.getBestPosition() != null);
            Object3DLinkSetBundle bundle = potential.generateRna(optResult.getBestPosition(), baseName, this.nucleotideDB);
            this.graph.addGraph(bundle.getObject3D());
            this.links.merge(bundle.getLinks());
        }
        this.fireModelChangedOnGraphAndLinkController(new ModelChangeEvent((Object)this, 4));
        return result;
    }

    public Properties optimizeHelices(int numSteps, double errorScoreLimit, double errorScoreInitialLimit, double kt, FitParameters stemFitParameters, String stemRootName, Object3DSet movableObjects, Object3DSet parentObjects, int connectionAlgorithm, int fuseStrandsMode, boolean firstFixedMode, int helixInterval) throws Object3DGraphControllerException {
        log.info("Starting optimizeHelices...");
        Properties properties = null;
        Object3D stemRoot = this.graph.findByFullName(stemRootName);
        if (stemRoot == null) {
            throw new Object3DGraphControllerException("Could not find object " + stemRootName);
        }
        try {
            properties = HelixOptimizerTools.optimizeHelices(numSteps, errorScoreLimit, errorScoreInitialLimit, kt, stemFitParameters, movableObjects, parentObjects, stemRoot, this.getLinks(), this.nucleotideDB, connectionAlgorithm, fuseStrandsMode, firstFixedMode, helixInterval);
        }
        catch (FittingException fe) {
            throw new Object3DGraphControllerException(fe.getMessage());
        }
        assert (properties != null);
        this.fireModelChangedOnGraphAndLinkController(new ModelChangeEvent((Object)this, 4));
        log.info("Finished optimizeHelices...");
        return properties;
    }

    public Properties optimizeBasepairs(int numSteps, double errorScoreLimit, double electrostaticWeight, double vdwWeight, double kt, List<Object3DSet> objectBlocks, List<Vector3D> fixedRotationAxisList, int[] symVdwActive, boolean keepFirstFixed, boolean placeBaseJunction, String rootName) throws Object3DGraphControllerException {
        assert (objectBlocks != null);
        assert (objectBlocks.size() > 0);
        assert (rootName != null);
        Properties properties = BasepairOptimizerTools.optimizeBasepairs(this.links, this.basePairDB, numSteps, errorScoreLimit, electrostaticWeight, vdwWeight, kt, objectBlocks, fixedRotationAxisList, symVdwActive, keepFirstFixed, this.symmetryController.getSymCopies());
        assert (properties != null);
        if (placeBaseJunction) {
            log.info("Placing junctions corresponding to junction data base constraints...");
            Set<String> propKeys = properties.stringPropertyNames();
            for (String key : propKeys) {
                String valueString = properties.getProperty(key);
                assert (valueString != null);
                log.info("Checking key-value: " + key + " : " + valueString);
                String[] words = key.split("\\.");
                if (words.length >= 2 && (words[words.length - 1].equals("junctionDB") || words[words.length - 1].equals("kissingLoopDB"))) {
                    boolean kissingLoopMode = words[words.length - 1].equals("kissingLoopDB");
                    log.info("Found junction key-value: " + key + " : " + valueString);
                    String[] orderId = valueString.split(" ");
                    assert (orderId.length > 2);
                    try {
                        int junctionOrder = Integer.parseInt(orderId[0]);
                        int junctionId = Integer.parseInt(orderId[1]);
                        String linkName = words[0];
                        String strandEnding = "_" + linkName;
                        String junctionName = linkName + "_" + junctionId;
                        Vector3D position = new Vector3D(0.0, 0.0, 0.0);
                        log.info("placing " + junctionOrder + " " + junctionId + " " + junctionName);
                        StrandJunction3D junction = null;
                        if (!kissingLoopMode) {
                            junction = this.junctionController.getJunctionDB().getJunction(junctionOrder, junctionId);
                            if (junction == null) {
                                throw new Object3DGraphControllerException("Could not find appropriate junction: " + junctionOrder + " " + junctionId);
                            }
                        } else {
                            junction = this.junctionController.getKissingLoopDB().getJunction(junctionOrder, junctionId);
                            if (junction == null) {
                                throw new Object3DGraphControllerException("Could not find appropriate kissing loop: " + junctionOrder + " " + junctionId);
                            }
                        }
                        assert (junction != null);
                        ArrayList<StrandJunction3D> tmpJunctionList = new ArrayList<StrandJunction3D>();
                        tmpJunctionList.add(junction);
                        ArrayList<BranchDescriptor3D> branches = new ArrayList<BranchDescriptor3D>();
                        for (int i = 2; i < orderId.length; ++i) {
                            String branchName = orderId[i];
                            Object3D obj = this.getGraph().findByFullName(branchName);
                            assert (obj != null && obj instanceof BranchDescriptor3D);
                            branches.add((BranchDescriptor3D)obj);
                        }
                        assert (branches.size() == junctionOrder);
                        if (junctionOrder == 2) {
                            double scoreLim;
                            HelixBridgeFinder helixBridgeFinder = new HelixBridgeFinder(tmpJunctionList, this.nucleotideDB);
                            helixBridgeFinder.setInversionMode(false);
                            helixBridgeFinder.setRms(16.0);
                            List<Object3DLinkSetBundle> placedJunctions = helixBridgeFinder.findHelixBridge((BranchDescriptor3D)branches.get(0), (BranchDescriptor3D)branches.get(1));
                            List<Object3DLinkSetBundle> placedJunctions2 = helixBridgeFinder.findHelixBridge((BranchDescriptor3D)branches.get(1), (BranchDescriptor3D)branches.get(0));
                            double score1 = scoreLim = 1.0E10;
                            double score2 = scoreLim;
                            if (placedJunctions.size() > 0) {
                                score1 = Double.parseDouble(placedJunctions.get(0).getObject3D().getProperty("score"));
                            } else {
                                log.info("No fitting junction found.");
                            }
                            if (placedJunctions2.size() > 0) {
                                score2 = Double.parseDouble(placedJunctions2.get(0).getObject3D().getProperty("score"));
                            } else {
                                log.info("No fitting junction found (2).");
                            }
                            if (score1 <= score2) {
                                if (!(score1 < scoreLim)) continue;
                                log.info("Placing best fitting junction!");
                                this.addBundle(placedJunctions.get(0));
                                continue;
                            }
                            if (!(score2 < scoreLim)) continue;
                            log.info("Placing best fitting junction (2)!");
                            this.addBundle(placedJunctions2.get(0));
                            continue;
                        }
                        log.warning("Placing of junctions with an order greater 2 is currently not implemented!");
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        log.severe("Internal error: there was now parsable junction id: " + nfe.getMessage());
                        assert (false);
                        continue;
                    }
                }
                if (words.length >= 2) {
                    log.info("not junctionId descriptor: " + words.length + " " + words[words.length - 1]);
                    continue;
                }
                log.info("too short junctionId descriptor: " + words.length + " " + key);
            }
        }
        this.refresh(new ModelChangeEvent((Object)this, 4));
        this.fireModelChangedOnGraphAndLinkController(new ModelChangeEvent((Object)this, 4));
        log.info("Result of optimizeBasePairs:");
        PropertyTools.printProperties(System.out, properties);
        return properties;
    }

    public Properties optimizeSystematic(double electrostaticWeight, double vdwWeight, List<Object3DSet> objectBlocks, IntegerPermutatorList permutators, int outputIntervall) throws Object3DGraphControllerException {
        assert (objectBlocks != null);
        assert (objectBlocks.size() > 0);
        SystematicBasepairOptimizer basepairOptimizer = new SystematicBasepairOptimizer(this.links, objectBlocks, this.basePairDB, permutators);
        basepairOptimizer.setElectrostaticWeight(electrostaticWeight);
        basepairOptimizer.setOutputInterval(outputIntervall);
        basepairOptimizer.setVdwWeight(vdwWeight);
        Properties properties = basepairOptimizer.optimize();
        assert (properties != null);
        this.refresh(new ModelChangeEvent((Object)this, 4));
        this.fireModelChangedOnGraphAndLinkController(new ModelChangeEvent((Object)this, 4));
        return properties;
    }

    private SecondaryStructureScorer findScorer(int scoringFunction) {
        switch (scoringFunction) {
            case 5: {
                log.info("Setting scorer to dummy mode!");
                DummyEnergySecondaryStructureScorer scorer = new DummyEnergySecondaryStructureScorer();
                scorer.setZeroMode(true);
                return scorer;
            }
            case 0: {
                return null;
            }
            case 1: {
                log.info("Setting scorer to RNAcofold mode!");
                return new RnacofoldSecondaryStructureScorer();
            }
            case 2: {
                log.info("Setting scorer to pknotsRG mode!");
                RnacofoldSecondaryStructureScorer scorer = new RnacofoldSecondaryStructureScorer();
                scorer.setPkMode(true);
                return scorer;
            }
            case 3: {
                log.info("Setting scorer to NUPACK mode!");
                return new NupackStructureScorer();
            }
            case 4: {
                log.info("Setting scorer to criton-scorer!");
                return new CritonScorer();
            }
            case 7: {
                log.info("Setting scorer to pathway-scorer not supported anymore!");
                assert (false);
                return null;
            }
        }
        log.severe("Unknown secondary structure scorer id!");
        assert (false);
        return null;
    }

    public void optimizeSequences(boolean importSequenceFlag, int optimizerAlgorithm, int scoringFunction, int scoringFunction2, double rmsLimit, double errorLimit, int iterMax, int iter2Max, int rerun, Properties params) throws IOException, DuplicateNameException, Object3DGraphControllerException, UnknownSymbolException {
        String[] sequenceStrings;
        System.out.println("");
        System.out.println(">>>>> Running 2-step optimization algorithm <<<<<");
        System.out.println("");
        MutableSecondaryStructure secStruct = this.generateSecondaryStructure();
        MonteCarloSequenceOptimizer sequenceOptimizer = new MonteCarloSequenceOptimizer();
        System.out.println("MonteCarloSequenceOptimizer initialized");
        sequenceOptimizer.setIterMax(iterMax);
        sequenceOptimizer.setIter2Max(iter2Max);
        sequenceOptimizer.setRerun(rerun);
        sequenceOptimizer.setErrorScoreLimit(errorLimit);
        SecondaryStructureScorer scorer1 = this.findScorer(scoringFunction);
        if (scorer1 != null) {
            sequenceOptimizer.setDefaultScorer(scorer1);
        }
        assert (sequenceOptimizer.getDefaultScorer() != null);
        SecondaryStructureScorer scorer2 = this.findScorer(scoringFunction2);
        if (scorer2 != null) {
            sequenceOptimizer.setFinalScorer(scorer2);
        }
        assert (sequenceOptimizer.getFinalScorer() != null);
        if (secStruct == null || secStruct.getSequenceCount() == 0) {
            log.warning("No sequences defined that can be optimized!");
            return;
        }
        if (optimizerAlgorithm == 0) {
            log.info("No sequence optimization performed!");
            return;
        }
        log.info("Starting optimizeSequences");
        if (optimizerAlgorithm != 1) {
            sequenceStrings = sequenceOptimizer.optimize(secStruct);
        } else {
            File tmpInputFile = File.createTempFile("nanotiler", ".sec");
            String inputFileName = tmpInputFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(tmpInputFile);
            PrintStream ps = new PrintStream(fos);
            SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
            log.info("Writing to file: " + inputFileName);
            log.info("Writing content: " + secWriter.writeString(secStruct));
            ps.println(secWriter.writeString(secStruct));
            fos.close();
            File tmpOutputFile = File.createTempFile("nanotiler", ".seq");
            String outputFileName = tmpOutputFile.getAbsolutePath();
            if (tmpOutputFile.exists()) {
                tmpOutputFile.delete();
            }
            File tempFile = new File(rnaInverseScriptName);
            String[] commandWords = new String[]{rnaInverseScriptName, inputFileName, outputFileName};
            SimpleRunCommand command = new SimpleRunCommand(commandWords);
            SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
            Job job = queueManager.createJob(command);
            queueManager.submit(job);
            log.info("queue manager finished job!");
            log.info("Importing optimized sequences from " + outputFileName);
            try {
                FileInputStream resultFile = new FileInputStream(outputFileName);
                String[] resultLines = StringTools.readAllLines(resultFile);
                sequenceStrings = RnaInverseTools.getSequenceStrings(resultLines);
            }
            catch (IOException ioe) {
                log.warning("Error when scraping result file from: " + outputFileName);
                throw ioe;
            }
        }
        if (sequenceStrings == null) {
            log.info("Could not find sufficiently optimized sequences!");
            return;
        }
        if (importSequenceFlag) {
            log.info("The new sequences are: ");
            this.overwriteSequences(sequenceStrings, null, rmsLimit, false);
            this.modelChanged(new ModelChangeEvent((Object)this, 4));
            log.info("Finished importing sequences!");
        } else {
            log.info("Optimized sequences were by request not imported!");
        }
        log.info("Finished optimize sequences!");
    }

    public void optimizeSequences(boolean importSequenceFlag, int optimizerAlgorithm, int scoringFunction, int scoringFunction2, int scoringFunction3, double rmsLimit, double errorLimit, int iterMax, int iter2Max, int iter3Max, int rerun) throws IOException, DuplicateNameException, Object3DGraphControllerException, UnknownSymbolException {
        String[] sequenceStrings;
        MutableSecondaryStructure secStruct = this.generateSecondaryStructure();
        MonteCarloSequenceOptimizer3Step sequenceOptimizer = new MonteCarloSequenceOptimizer3Step();
        System.out.println("MonteCarloSequenceOptimizer initialized");
        sequenceOptimizer.setIterMax(iterMax);
        sequenceOptimizer.setIter2Max(iter2Max);
        sequenceOptimizer.setIter3Max(iter3Max);
        sequenceOptimizer.setRerun(rerun);
        sequenceOptimizer.setErrorScoreLimit(errorLimit);
        sequenceOptimizer.setDefaultScorer(this.findScorer(scoringFunction));
        sequenceOptimizer.setMidScorer(this.findScorer(scoringFunction2));
        sequenceOptimizer.setFinalScorer(this.findScorer(scoringFunction3));
        if (secStruct == null || secStruct.getSequenceCount() == 0) {
            log.warning("No sequences defined that can be optimized!");
            return;
        }
        if (optimizerAlgorithm == 0) {
            log.info("No sequence optimization performed!");
            return;
        }
        log.info("Starting optimizeSequences");
        if (optimizerAlgorithm != 1) {
            sequenceStrings = sequenceOptimizer.optimize(secStruct);
        } else {
            File tmpInputFile = File.createTempFile("nanotiler", ".sec");
            String inputFileName = tmpInputFile.getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(tmpInputFile);
            PrintStream ps = new PrintStream(fos);
            SecondaryStructureScriptFormatWriter secWriter = new SecondaryStructureScriptFormatWriter();
            log.info("Writing to file: " + inputFileName);
            log.info("Writing content: " + secWriter.writeString(secStruct));
            ps.println(secWriter.writeString(secStruct));
            fos.close();
            File tmpOutputFile = File.createTempFile("nanotiler", ".seq");
            String outputFileName = tmpOutputFile.getAbsolutePath();
            if (tmpOutputFile.exists()) {
                tmpOutputFile.delete();
            }
            File tempFile = new File(rnaInverseScriptName);
            String[] commandWords = new String[]{rnaInverseScriptName, inputFileName, outputFileName};
            SimpleRunCommand command = new SimpleRunCommand(commandWords);
            SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
            Job job = queueManager.createJob(command);
            queueManager.submit(job);
            log.info("queue manager finished job!");
            log.info("Importing optimized sequences from " + outputFileName);
            try {
                FileInputStream resultFile = new FileInputStream(outputFileName);
                String[] resultLines = StringTools.readAllLines(resultFile);
                sequenceStrings = RnaInverseTools.getSequenceStrings(resultLines);
            }
            catch (IOException ioe) {
                log.warning("Error when scraping result file from: " + outputFileName);
                throw ioe;
            }
        }
        if (sequenceStrings == null) {
            log.info("Could not find sufficiently optimized sequences!");
            return;
        }
        if (importSequenceFlag) {
            log.info("The new sequences are: ");
            this.overwriteSequences(sequenceStrings, null, rmsLimit, false);
            this.modelChanged(new ModelChangeEvent((Object)this, 4));
            log.info("Finished importing sequences!");
        } else {
            log.info("Optimized sequences were by request not imported!");
        }
        log.info("Finished 3-step sequence optimization!");
    }

    private void initRiboswitchIgnoreStatus(SecondaryStructure secStruct) {
        for (int i = 1; i < secStruct.getSequenceCount(); ++i) {
            Sequence seq = secStruct.getSequence(i);
            for (int j = 0; j < seq.size(); ++j) {
                Residue res = seq.getResidue(j);
                String status = res.getProperty("seqstatus");
                if (status != null && status.length() != 0) continue;
                res.setProperty("seqstatus", "ignore");
            }
        }
    }

    public void optimizeBistableSequences(boolean importSequenceFlag, int optimizerAlgorithm, double rmsLimit, double errorLimit, int iterMax, int iter2Max, int rerun) throws IOException, DuplicateNameException, Object3DGraphControllerException, UnknownSymbolException {
        MutableSecondaryStructure secStruct = this.generateSecondaryStructure();
        this.initRiboswitchIgnoreStatus(secStruct);
        MonteCarloSequenceOptimizer sequenceOptimizer = new MonteCarloSequenceOptimizer();
        sequenceOptimizer.setFinalScorer(new RiboswitchSecondaryStructureScorer());
        sequenceOptimizer.setIterMax(iterMax);
        sequenceOptimizer.setIter2Max(iter2Max);
        sequenceOptimizer.setRerun(rerun);
        sequenceOptimizer.setErrorScoreLimit(errorLimit);
        if (secStruct == null || secStruct.getSequenceCount() == 0) {
            log.warning("No sequences defined that can be optimized!");
            return;
        }
        if (optimizerAlgorithm == 0) {
            log.info("No sequence optimization performed!");
            return;
        }
        log.info("Starting optimizeSequences");
        String[] sequenceStrings = sequenceOptimizer.optimize(secStruct);
        if (sequenceStrings == null) {
            log.info("Could not find succifiently optimized sequences!");
            return;
        }
        if (importSequenceFlag) {
            log.info("The new sequences are: ");
            this.overwriteSequences(sequenceStrings, null, rmsLimit, false);
            this.modelChanged(new ModelChangeEvent((Object)this, 4));
            log.info("Finished importing sequences!");
        } else {
            log.info("Optimized sequences were by request not imported!");
        }
        log.info("Finished optimize sequences!");
    }

    public StrandJunction3D placeKissingLoop(int order, int n, String rootName, String newName, Vector3D position, String strandEnding) throws Object3DGraphControllerException {
        StrandJunction3D junction = this.junctionController.getKissingLoopDB().getJunction(order, n);
        if (junction == null) {
            throw new Object3DGraphControllerException("No junction of order " + order + " and id " + (n + 1) + " is currently loaded.");
        }
        junction = (StrandJunction3D)junction.cloneDeep();
        junction.setPosition(position);
        junction.setName(newName);
        if (strandEnding != null && strandEnding.length() > 0) {
            HashSet<String> allowedNames = new HashSet<String>();
            allowedNames.add("RnaStrand");
            HashSet<String> forbiddenNames = new HashSet<String>();
            Object3DTools.addEnding(junction, strandEnding, allowedNames, forbiddenNames);
        }
        this.graph.addGraph(junction, rootName);
        ModelChangeEvent event = new ModelChangeEvent((Object)this, 4);
        this.graph.fireModelChanged(event);
        this.links.fireModelChanged(event);
        return junction;
    }

    public StrandJunction3D placeJunction(int order, int n, String rootName, String newName, Vector3D position, String strandEnding) throws Object3DGraphControllerException {
        StrandJunction3D junction = this.junctionController.getJunctionDB().getJunction(order, n);
        if (junction == null) {
            throw new Object3DGraphControllerException("No junction of order " + order + " and id " + (n + 1) + " is currently loaded.");
        }
        junction = (StrandJunction3D)junction.cloneDeep();
        junction.setPosition(position);
        junction.setName(newName);
        if (strandEnding != null && strandEnding.length() > 0) {
            HashSet<String> allowedNames = new HashSet<String>();
            allowedNames.add("RnaStrand");
            HashSet<String> forbiddenNames = new HashSet<String>();
            Object3DTools.addEnding(junction, strandEnding, allowedNames, forbiddenNames);
        }
        this.graph.addGraph(junction, rootName);
        ModelChangeEvent event = new ModelChangeEvent((Object)this, 4);
        this.graph.fireModelChanged(event);
        this.links.fireModelChanged(event);
        return junction;
    }

    public Object3D placeBuildingBlock(DBElementDescriptor element, String rootName, String newName, Vector3D position, String strandEnding) throws Object3DGraphControllerException {
        StrandJunction3D result;
        switch (element.getType()) {
            case 1: {
                result = this.placeJunction(element.getOrder(), element.getId(), rootName, newName, position, strandEnding);
                break;
            }
            case 2: {
                result = this.placeKissingLoop(element.getOrder(), element.getId(), rootName, newName, position, strandEnding);
                break;
            }
            default: {
                throw new Object3DGraphControllerException("placeBuildingBlock: Database type not implemented: " + element);
            }
        }
        result.setProperty("db_element", element.toString());
        return result;
    }

    private StrandJunction3D extractAndPlaceJunction(Properties properties, String rootName, String newName, Vector3D position) throws Object3DGraphControllerException {
        String junctionType = properties.getProperty("junction_type");
        assert (junctionType != null);
        StrandJunction3D junction = null;
        int junctionId = Integer.parseInt(properties.getProperty("junction_id"));
        int junctionOrder = Integer.parseInt(properties.getProperty("junction_order"));
        String ending = "_fit";
        if (junctionType.equals("StrandJunction3D")) {
            junction = this.placeJunction(junctionOrder, junctionId, rootName, newName, position, ending);
        } else if (junctionType.equals("KissingLoop3D")) {
            junction = this.placeKissingLoop(junctionOrder, junctionId, rootName, newName, position, ending);
        } else assert (false);
        return junction;
    }

    private int extractHelix1(Properties properties) {
        return Integer.parseInt(properties.getProperty("num_alt1")) - 1;
    }

    private int extractHelix2(Properties properties) {
        return Integer.parseInt(properties.getProperty("num_alt2")) - 1;
    }

    public void initBridgeController(String fileNameFile) {
        if (fileNameFile != null && fileNameFile.length() > 0 && new File(fileNameFile).exists()) {
            log.info("Initializing bridge controller with filename file: " + fileNameFile);
            this.bridgeController = new BridgeItController(fileNameFile, this.junctionController);
        } else {
            log.info("Could not initializize bridge controller with file name: " + fileNameFile);
        }
    }

    public void initBridgeController(List<String> fileNames) {
        this.bridgeController = new BridgeItController(fileNames, this.junctionController, this.nucleotideDB);
    }

    public void initBridgeController() throws Object3DGraphControllerException {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(nanotilerHome + PackageConstants.SLASH + rb.getString("bridgedb"));
        this.initBridgeController(fileNames);
        if (this.bridgeController == null) {
            throw new Object3DGraphControllerException("Bridge database not initialized. Call bridgeinit");
        }
        log.info("Bridge controller succesfully initialized.");
    }

    private void placeFittedJunction(BranchDescriptor3D b1, BranchDescriptor3D b2, Properties properties, double rms, String rootName) throws FittingException, Object3DGraphControllerException {
        int fuseStrands = 0;
        boolean firstFixedMode = true;
        Vector3D position = Vector3D.average(b1.getPosition(), b2.getPosition());
        String newName = b1.getName() + "_" + b2.getName();
        StrandJunction3D junction = this.extractAndPlaceJunction(properties, rootName, newName, position);
        assert (junction != null);
        int n1 = this.extractHelix1(properties);
        int n2 = this.extractHelix2(properties);
        boolean forwardMode = properties.getProperty("junction_direction").equals("forward");
        String name2 = junction.getBranch(0).getFullName();
        String name3 = junction.getBranch(1).getFullName();
        if (!forwardMode) {
            name2 = junction.getBranch(1).getFullName();
            name3 = junction.getBranch(0).getFullName();
        }
        log.info("starting addHelixConstraint (1)" + b1.getFullName() + " " + name2 + " " + n1 + " " + rms);
        assert (this.getGraph().findByFullName(b1.getFullName()) != null);
        assert (this.getGraph().findByFullName(b2.getFullName()) != null);
        assert (this.getGraph().findByFullName(name2) != null);
        assert (this.getGraph().findByFullName(name3) != null);
        this.addHelixConstraint(b1.getFullName(), name2, n1, n1, rms, 0, 0, null);
        log.info("starting addHelixConstraint (2)" + b2.getFullName() + " " + name3 + " " + n2 + " " + rms);
        this.addHelixConstraint(b2.getFullName(), name3, n2, n2, rms, 0, 0, null);
        FitParameters stemFitParameters = new FitParameters(rms, Math.toRadians(30.0));
        SimpleObject3DSet movable = new SimpleObject3DSet();
        movable.add(junction.getBranch(0));
        movable.add(junction.getBranch(1));
        String helixRootName = "root";
        log.info("Starting to optimize helices!");
        Object3DSet parentObjects = null;
        Properties prop = this.optimizeHelices(50000, 10.0, 1.0E10, 20.0, stemFitParameters, helixRootName, movable, parentObjects, 4, fuseStrands, firstFixedMode, 0);
        Vector3D testPosition = Vector3D.average(b1.getPosition(), b2.getPosition());
        assert (position.distance(testPosition) < 0.1);
        double score = Double.parseDouble(prop.getProperty("final_score"));
        if (score > rms) {
            log.warning("Too bad junction fit ( " + score + " instad of limit " + rms + " ), removing junction again:");
            this.getGraph().remove(junction);
        }
        log.info("Finished placeFittedJunction: " + prop);
    }

    public List<Properties> rankJunctionFits(BranchDescriptor3D b1, BranchDescriptor3D b2, int n1Min, int n1Max, int n2Min, int n2Max, double placeRms, String rootName) throws FittingException, Object3DGraphControllerException {
        List<Properties> result = this.junctionController.rankJunctionFits(b1, b2, n1Min, n1Max, n2Min, n2Max);
        if (placeRms >= 0.0) {
            Vector3D testPos1 = b1.getPosition();
            Vector3D testPos2 = b2.getPosition();
            this.placeFittedJunction(b1, b2, result.get(0), placeRms, rootName);
            assert (testPos1.distance(b1.getPosition()) < 0.1);
            assert (testPos2.distance(b2.getPosition()) < 0.1);
            this.refresh(new ModelChangeEvent((Object)this, 4));
        }
        return result;
    }

    public List<Properties> rankKissingLoopFits(BranchDescriptor3D b1, BranchDescriptor3D b2, int n1Min, int n1Max, int n2Min, int n2Max, double placeRms, String rootName) throws FittingException, Object3DGraphControllerException {
        List<Properties> result = this.junctionController.rankKissingLoopFits(b1, b2, n1Min, n1Max, n2Min, n2Max);
        if (placeRms >= 0.0) {
            Vector3D testPos1 = b1.getPosition();
            Vector3D testPos2 = b2.getPosition();
            this.placeFittedJunction(b1, b2, result.get(0), placeRms, rootName);
            assert (testPos1.distance(b1.getPosition()) < 0.1);
            assert (testPos2.distance(b2.getPosition()) < 0.1);
            this.refresh(new ModelChangeEvent((Object)this, 4));
        }
        return result;
    }

    public void generateAtomLinks(Object3D root, double cutoff) {
        Object3DSet atoms = Object3DTools.collectByClassName(root, "Atom3D");
        for (int i = 0; i < atoms.size(); ++i) {
            for (int j = i + 1; j < atoms.size(); ++j) {
                double dist = atoms.get(i).distance(atoms.get(j));
                if (!(dist < cutoff)) continue;
                try {
                    this.generateLink(((Object)atoms.get(i)).toString(), ((Object)atoms.get(j)).toString(), "null");
                    continue;
                }
                catch (Object3DGraphControllerException e) {
                    System.out.println("Command error");
                }
            }
        }
    }

    public double getAtomBondCutoff() {
        return this.atomBondCutoff;
    }

    public int getImportStemLengthMin() {
        return this.importStemLengthMin;
    }

    private void printDBElementInfo(PrintStream ps, DBElementDescriptor dbe) {
        assert (dbe != null && ps != null);
        StrandJunction3D junction = null;
        if (dbe.getType() == 1) {
            junction = this.junctionController.getJunctionDB().getJunction(dbe.getOrder(), dbe.getId());
        } else if (dbe.getType() == 2) {
            junction = this.junctionController.getKissingLoopDB().getJunction(dbe.getOrder(), dbe.getId());
        } else assert (false);
        if (junction != null) {
            String propString = "";
            propString = junction.getProperties() != null ? propString + junction.getProperties() : "undefined";
            ps.print("" + dbe + ";properties:" + propString);
        } else {
            ps.print(" junction_not_found_error");
        }
    }

    private void printConnectivityInfo(PrintStream ps, GrowConnectivity connectivity) {
        List<DBElementDescriptor> buildingBlocks = connectivity.getBuildingBlocks();
        ps.print("" + buildingBlocks.size() + ";");
        for (int i = 0; i < buildingBlocks.size(); ++i) {
            DBElementDescriptor dbe = buildingBlocks.get(i);
            ps.print("bb:" + (i + 1) + ":");
            this.printDBElementInfo(ps, dbe);
            ps.print(";");
        }
    }

    public Properties growBuildingBlocks(GrowConnectivity connectivity, String rootName, String nameBase, Vector3D startPosition, boolean addStemsFlag, double stemRmsLimit, boolean avoidCollisionsMode, double ringClosureExportLimit, String ringClosureExportFileNameBase) throws Object3DGraphControllerException {
        System.out.print("used_blocks_info:");
        this.printConnectivityInfo(System.out, connectivity);
        System.out.println();
        BuildingBlockGrower grower = new BuildingBlockGrower(this.junctionController.getJunctionDB(), this.junctionController.getKissingLoopDB(), this.nucleotideDB);
        grower.addStemsFlag = addStemsFlag;
        grower.avoidCollisionsMode = avoidCollisionsMode;
        grower.setRingClosureExportLimit(ringClosureExportLimit);
        grower.setStemRmsLimit(stemRmsLimit);
        Properties properties = null;
        try {
            properties = grower.growBuildingBlocks(connectivity, rootName, nameBase, startPosition, ringClosureExportFileNameBase);
        }
        catch (FittingException fe) {
            throw new Object3DGraphControllerException(fe.getMessage());
        }
        catch (IOException ioe) {
            throw new Object3DGraphControllerException(ioe.getMessage());
        }
        this.addBundle(grower.getBundle());
        return properties;
    }

    public Properties growBuildingBlocksFramework(Object3DLinkSetBundle bundle, int generationCount, List<DBElementDescriptor> buildingBlockDescriptors, List<List<Integer>> buildingBlockIndices, int maxBlocks, int maxConnections, int helixVariation, String nameBase, boolean buildMode, double ringClosureExportLimit) throws Object3DGraphControllerException {
        assert (bundle != null && buildingBlockDescriptors != null && buildingBlockIndices != null && buildingBlockDescriptors.size() > 0);
        SimpleConnectivityGenerator genConn = new SimpleConnectivityGenerator(bundle.getObject3D(), bundle.getLinks(), buildingBlockDescriptors, buildingBlockIndices, generationCount);
        genConn.setBuildingBlockCountMax(maxBlocks);
        genConn.setConnectionCountMax(maxConnections);
        genConn.setHelixLengthVariation(helixVariation);
        GrowFramework growFramework = new GrowFramework(genConn, this.junctionController.getJunctionDB(), this.junctionController.getKissingLoopDB(), this.nucleotideDB, nameBase);
        growFramework.setBuildMode(buildMode);
        growFramework.setRingClosureExportLimit(ringClosureExportLimit);
        assert (genConn.getConnectionCountMax() == maxConnections);
        if (nameBase != null) {
            growFramework.setNameBase(nameBase);
        }
        if (bundle != null && bundle.getObject3D() != null && bundle.getObject3D().size() > 0) {
            try {
                SignatureTranslatorCanonizer canonizer = new SignatureTranslatorCanonizer();
                String topology = canonizer.generateCanonizedRepresentation(bundle);
                log.info("Setting target topology to: " + topology);
                genConn.setTopology(topology);
            }
            catch (AlgorithmFailureException afe) {
                log.warning("Exception whlie generating signature of graph: " + afe.getMessage());
            }
        }
        log.info("Starting grow framework ...");
        growFramework.run();
        log.info("Finished grow framework.");
        if (growFramework.getException() != null) {
            throw new Object3DGraphControllerException("Exception in growBuildingBlocksFramework: " + growFramework.getException().getMessage());
        }
        BuildingBlockGrower bestGrower = growFramework.getBestGrower();
        if (bestGrower != null) {
            Object3D genStruct = bestGrower.getRoot();
            assert (genStruct != null);
            this.getGraph().addGraph(genStruct, this.getGraph().getGraph().getFullName());
            this.refresh(new ModelChangeEvent((Object)this, 4));
        }
        return growFramework.getProperties();
    }

    private List<Integer> generateBuildingBlockIndices(Object3D obj, LinkSet links, List<DBElementDescriptor> buildingBlockDescriptors) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < buildingBlockDescriptors.size(); ++i) {
            result.add(new Integer(i));
        }
        return result;
    }

    private List<List<Integer>> generateAllBuildingBlockIndices(Object3D root, LinkSet links, List<DBElementDescriptor> buildingBlockDescriptors) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        for (int i = 0; i < root.size(); ++i) {
            result.add(this.generateBuildingBlockIndices(root.getChild(i), links, buildingBlockDescriptors));
        }
        log.warning("Using simplified implementation of generateBuildingBlockIndices");
        return result;
    }

    public Object3D getNucleotideDB() {
        return this.nucleotideDB;
    }

    private void addAllBuildingBlockDescriptors(List<DBElementDescriptor> elements, StrandJunctionDB junctionDB, int junctionType) {
        assert (elements != null);
        int count = 0;
        for (int i = 0; i < junctionDB.size(); ++i) {
            for (int j = 0; j < junctionDB.size(i); ++j) {
                DBElementDescriptor dbe = new DBElementDescriptor(i, j, junctionType, elements.size());
                elements.add(dbe);
                ++count;
            }
        }
        assert (count == junctionDB.getJunctionCount());
    }

    public void trimUnpaired(String rnastrandFullName) throws Object3DGraphControllerException {
        log.info("Called trim command for name: " + rnastrandFullName);
        Object3D obj = this.graph.findByFullName(rnastrandFullName);
        if (obj == null || !(obj instanceof RnaStrand)) {
            throw new Object3DGraphControllerException("Not a valid RNA strand: " + obj.getFullName());
        }
        RnaStrandTools.trimUnpaired((RnaStrand)obj, this.links);
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public Object3DSet findPureHelicalStrands() {
        return RnaStrandTools.findPureHelicalStrands(this.getGraph().getGraph(), this.getLinks());
    }

    private List<DBElementDescriptor> generateAllBuildingBlockDescriptors() {
        ArrayList<DBElementDescriptor> elements = new ArrayList<DBElementDescriptor>();
        StrandJunctionDB junctionDB = this.junctionController.getJunctionDB();
        StrandJunctionDB kissingLoopDB = this.junctionController.getKissingLoopDB();
        this.addAllBuildingBlockDescriptors(elements, junctionDB, 1);
        this.addAllBuildingBlockDescriptors(elements, kissingLoopDB, 2);
        assert (elements.size() == junctionDB.getJunctionCount() + kissingLoopDB.getJunctionCount());
        return elements;
    }

    public Properties growBuildingBlocksFramework(String rootName, String nameBase, int generationCount, List<DBElementDescriptor> buildingBlockDescriptors, int maxBlocks, int maxConnections, int helixVariation, boolean buildMode, double ringClosureLimit) throws Object3DGraphControllerException {
        Object3D obj = this.getGraph().findByFullName(rootName);
        if (obj == null) {
            throw new Object3DGraphControllerException("Could not find object with name: " + rootName);
        }
        SimpleLinkSet newLinks = new SimpleLinkSet();
        newLinks.merge(this.getLinks());
        newLinks.removeBadLinks(obj);
        SimpleObject3DLinkSetBundle bundle = new SimpleObject3DLinkSetBundle(obj, newLinks);
        if (buildingBlockDescriptors == null || buildingBlockDescriptors.size() == 0) {
            log.info("No specific building blocks defined. Using all loaded building blocks for graph growing.");
            buildingBlockDescriptors = this.generateAllBuildingBlockDescriptors();
        }
        assert (buildingBlockDescriptors != null);
        if (buildingBlockDescriptors.size() == 0) {
            throw new Object3DGraphControllerException("No building blocks defined for self-assembly simulation! Consider commands loadjunctions and option blocks in command growgraph");
        }
        List<List<Integer>> indices = this.generateAllBuildingBlockIndices(obj, newLinks, buildingBlockDescriptors);
        return this.growBuildingBlocksFramework(bundle, generationCount, buildingBlockDescriptors, indices, maxBlocks, maxConnections, helixVariation, nameBase, buildMode, ringClosureLimit);
    }

    public void read(InputStream is) throws Object3DIOException {
        DataInputStream dis = new DataInputStream(is);
        GeneralRnaReader reader = new GeneralRnaReader();
        this.links.clear();
        Object3D tmpGraph = reader.readAnyObject3D(dis);
        log.finest("read tree data:" + PackageConstants.NEWLINE + ((Object)tmpGraph).toString() + PackageConstants.NEWLINE);
        this.links.read(dis, tmpGraph);
        log.finest("read LinkSet:" + PackageConstants.NEWLINE + this.links.toString() + PackageConstants.NEWLINE);
        this.graph.setGraph(tmpGraph);
    }

    public void readAndAdd(InputStream is) throws Object3DIOException {
        log.info("starting Object3DGraphController.readAndAdd(InputStream is)!");
        GeneralRnaReader reader = new GeneralRnaReader();
        Object3D tmpGraph = reader.readAnyObject3D(is);
        log.finest("read data:" + PackageConstants.NEWLINE + ((Object)tmpGraph).toString() + PackageConstants.NEWLINE);
        this.graph.addGraph(tmpGraph);
        this.generateAtomLinks(this.graph.getGraph(((Object)tmpGraph).toString()), this.atomBondCutoff);
        log.info("Finished Object3DGraphController.readAndAdd(InputStream is)!");
    }

    public void readAndAdd(InputStream is, String nameOrig, Vector3D scaleVector, Vector3D offset, int formatId, boolean addStemsFlag, char sequenceChar, boolean onlyFirstPathMode, boolean findStemsFlag, boolean addJunctionsFlag) throws Object3DIOException {
        Object3DFactory reader;
        log.info("starting Object3DGraphController.readAndAdd!");
        log.info("starting switch command with formatId: " + formatId);
        switch (formatId) {
            case 2: {
                reader = new KnotPlotReader();
                log.fine("reading KnotPlot format!");
                break;
            }
            case 3: {
                reader = new RnaPdbRnaviewReader();
                ((RnaPdbRnaviewReader)reader).setAddRnaviewMode(false);
                log.fine("reading RNA in PDB format without RNAview information!");
                break;
            }
            case 6: {
                reader = new PointSetReader();
                log.fine("reading point set format!");
                break;
            }
            case 7: {
                reader = new PointSetReader3();
                log.fine("reading point set 2 format!");
                break;
            }
            case 5: {
                reader = new RnaPdbRnaviewReader();
                ((RnaPdbRnaviewReader)reader).setResidueRenumberMode(false);
                log.fine("reading RNA PDB / RNAVIEW format!");
                break;
            }
            case 9: {
                reader = new RnaPdbRnaviewReader();
                log.info("reading RNA PDB format with added RNAView information; Also renumbering residues!");
                ((RnaPdbRnaviewReader)reader).setResidueRenumberMode(true);
                assert (false);
                break;
            }
            default: {
                assert (false);
                throw new Object3DIOException("Unknown input format id! DNA PDB and Protein PDB not supported.");
            }
        }
        log.fine("successfully chosen reader!");
        String name = nameOrig + "_cov";
        if (formatId != 7) {
            Object3DLinkSetBundle stemBundle;
            Object3D tmpGraph;
            Object3DLinkSetBundle bundle;
            block50: {
                bundle = reader.readBundle(is);
                tmpGraph = bundle.getObject3D();
                log.fine("Object3DGraphController.readAndAdd: 3D object with size " + tmpGraph.size() + " read! " + tmpGraph.getPosition());
                tmpGraph.setName(nameOrig);
                Vector3D one = new Vector3D(1.0, 1.0, 1.0);
                if (!one.equals(scaleVector)) {
                    log.info("Scaling objects with factors: " + scaleVector.toString());
                    tmpGraph.scale(scaleVector);
                }
                log.fine("adding graph to graph controller...");
                if (!this.graph.addGraph(tmpGraph)) {
                    throw new Object3DIOException("Object with name " + tmpGraph.getName() + " already exists!");
                }
                if (offset.length() > 0.0) {
                    tmpGraph.translate(offset);
                }
                this.links.addLinks(bundle.getLinks());
                if (findStemsFlag) {
                    log.fine("findStemsFlag");
                    stemBundle = null;
                    stemBundle = formatId != 5 ? StemTools.generateStems(tmpGraph) : StemTools.generateStemsFromLinks(tmpGraph, bundle.getLinks(), this.importStemLengthMin);
                    Object3D stemRoot = stemBundle.getObject3D();
                    if (stemRoot.size() > 0) {
                        block49: {
                            Object3DSet stemBranchDescriptors = BranchDescriptorTools.generateInvertedBranchDescriptors(new SimpleObject3DSet(stemBundle.getObject3D()), 0, this.stemFitRmsTolerance, 0);
                            log.info("Generated " + stemBranchDescriptors.size() + " branch descriptors for stems.");
                            try {
                                this.graph.addGraph(stemRoot, tmpGraph.getFullName());
                            }
                            catch (Object3DGraphControllerException e) {
                                log.severe(e.getMessage());
                                if ($assertionsDisabled) break block49;
                                throw new AssertionError();
                            }
                        }
                        this.links.addLinks(stemBundle.getLinks());
                        if (addJunctionsFlag) {
                            log.info("Adding junctions using " + stemRoot.size() + " stems");
                            String junctionName = name + "_jnc";
                            String kissingLoopName = name + "_kl";
                            log.fine("Using generated stems for junction generation: ");
                            for (int i = 0; i < stemRoot.size(); ++i) {
                                log.fine("" + ((RnaStem3D)stemRoot.getChild(i)).getStemInfo());
                            }
                            Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, junctionName, this.junctionController.getParameters().branchDescriptorOffset, this.corridorDescriptor, this.stemFitRmsTolerance, this.junctionController.getParameters().loopLengthSumMax);
                            Object3D kissingLoops = BranchDescriptorTools.generateKissingLoops(stemRoot, kissingLoopName, this.junctionController.getParameters().branchDescriptorOffset, this.stemFitRmsTolerance);
                            assert (junctions != null);
                            assert (kissingLoops != null);
                            log.info("Number of found junctions in imported object: " + junctions.size());
                            log.info("Number of found kissing loops in imported object: " + kissingLoops.size());
                            try {
                                if (junctions.size() > 0) {
                                    this.graph.addGraph(junctions, tmpGraph.getFullName());
                                }
                                if (kissingLoops.size() > 0) {
                                    this.graph.addGraph(kissingLoops, tmpGraph.getFullName());
                                }
                            }
                            catch (Object3DGraphControllerException e) {
                                log.severe(e.getMessage());
                                if ($assertionsDisabled) break block50;
                                throw new AssertionError();
                            }
                        }
                    }
                }
            }
            if (addStemsFlag) {
                log.fine("addStemsFlag");
                this.updateFragmentGridTiler();
                assert (this.fgTiler.getStrandJunctionDB() != null);
                stemBundle = this.fgTiler.generateTiling(tmpGraph, bundle.getLinks(), name, sequenceChar, onlyFirstPathMode);
                if (stemBundle != null) {
                    block51: {
                        try {
                            this.graph.addGraph(stemBundle.getObject3D(), tmpGraph.getFullName());
                        }
                        catch (Object3DGraphControllerException e) {
                            log.severe(e.getMessage());
                            if ($assertionsDisabled) break block51;
                            throw new AssertionError();
                        }
                    }
                    this.links.addLinks(stemBundle.getLinks());
                    if (stemBundle.getObject3D().size() > 0) assert (stemBundle.getLinks().size() > 0);
                }
            } else {
                log.fine("No placement of graph-based junctions or stems because addStemFlag was set to false!");
            }
            log.fine("readAndAdd finished!");
        } else if (reader instanceof PointSetReader3) {
            Object3DLinkSetBundle stemBundle;
            log.info("Reader point set file with PointSetReader3!");
            RotationInfo rotation = ((PointSetReader3)reader).readPoints2(is);
            Object3D root = rotation.getRoot();
            LinkSet linkSet = rotation.getLinkSet();
            log.info("3D object with size " + root.size() + " read! " + root.getPosition());
            root.setName(name);
            Vector3D one = new Vector3D(1.0, 1.0, 1.0);
            if (!one.equals(scaleVector)) {
                log.info("Scaling objects with factors: " + scaleVector);
                root.scale(scaleVector);
            }
            assert (offset.length() == 0.0);
            this.graph.addGraph(root);
            this.links.addLinks(linkSet);
            if (findStemsFlag) {
                stemBundle = null;
                if (formatId != 5) {
                    log.severe("PDB file should be augmented with RNAVIEW info!");
                    stemBundle = StemTools.generateStems(root);
                } else {
                    stemBundle = StemTools.generateStemsFromLinks(root, linkSet, this.importStemLengthMin);
                }
                Object3D stemRoot = stemBundle.getObject3D();
                if (stemRoot.size() > 0) {
                    this.graph.addGraph(stemRoot);
                    this.links.addLinks(stemBundle.getLinks());
                    if (addJunctionsFlag) {
                        log.fine("Adding junctions!");
                        String junctionName = name + "_jnc";
                        Object3D junctions = BranchDescriptorTools.generateJunctions(stemRoot, junctionName, 0, this.corridorDescriptor, this.stemFitRmsTolerance, this.junctionController.getParameters().loopLengthSumMax);
                        assert (junctions != null);
                        if (junctions.size() > 0) {
                            this.graph.addGraph(junctions);
                        }
                    }
                }
            }
            if (addStemsFlag) {
                this.updateFragmentGridTiler();
                assert (this.fgTiler.getStrandJunctionDB() != null);
                stemBundle = this.fgTiler.generateTiling(root, linkSet, name, sequenceChar, onlyFirstPathMode);
                if (stemBundle != null) {
                    this.graph.addGraph(stemBundle.getObject3D());
                    this.links.addLinks(stemBundle.getLinks());
                }
            }
            log.fine("readAndAdd finished!");
        } else assert (false);
        log.info("readAndAdd finished!");
    }

    public void readNucleotideDB(String fileName) throws Object3DGraphControllerException {
        RnaPdbReader reader = new RnaPdbReader();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.nucleotideDB = NucleotideDBTools.readNucleotideDB(fis);
        }
        catch (IOException exc) {
            throw new Object3DGraphControllerException("Error reading nucleotide database. " + exc.getMessage());
        }
    }

    public void refresh(ModelChangeEvent event) {
        log.fine("calling refresh");
        if (!(event.getSource() instanceof LinkController)) {
            this.refreshLinks();
        }
        this.refreshBindingSites();
        this.refreshSequences();
        this.refreshShapeSet();
        this.fireModelChanged(event);
        log.fine("Done calling refresh");
    }

    private void refreshBindingSites() {
        if (this.graph.getGraph() != null) {
            SequenceBindingSiteCollector collector = new SequenceBindingSiteCollector();
            Object3DActionVisitor visitor = new Object3DActionVisitor(this.graph.getGraph(), collector);
            visitor.nextToEnd();
            this.bindingSites.clear();
            for (int i = 0; i < collector.size(); ++i) {
                this.bindingSites.addBindingSite(collector.get(i));
            }
        } else {
            this.bindingSites.clear();
        }
    }

    public void refreshLinks() {
        this.links.removeBadLinks(this.graph.getGraph());
    }

    private void refreshSequences() {
        log.fine("starting refreshSequences!");
        if (this.graph.getGraph() != null) {
            SequenceCollector collector = Object3DGraphController.generateCollectedSequences(this.graph.getGraph());
            this.sequences.clear();
            for (int i = 0; i < collector.getSequenceCount(); ++i) {
                try {
                    this.sequences.addSequence(collector.getSequence(i));
                    log.finest("Found sequence: " + collector.getSequence(i).sequenceString());
                    continue;
                }
                catch (DuplicateNameException e) {
                    log.severe("internal error: duplicate sequence names found!");
                }
            }
        } else {
            this.sequences.clear();
        }
        log.fine("finished refreshSequences!");
    }

    private void refreshShapeSet() {
        assert (this.shapeSetFactory != null);
        this.shapeSetFactory.setDepthMax(this.graph.getDepthMax());
        this.shapeSet = this.shapeSetFactory.createShapeSet(this.graph.getGraph());
        assert (this.shapeSet != null);
        for (int i = 0; i < this.links.size(); ++i) {
            Shape3DSet sSet = this.shapeSetFactory.createShapeSet(this.links.get(i));
            if (sSet == null) continue;
            if (this.shapeSet != null) {
                this.shapeSet.merge(sSet);
                continue;
            }
            this.shapeSet = sSet;
        }
        assert (this.shapeSet != null);
        this.shapeSet.add(this.getSelectionCursorShape());
        this.shapeSet.add(this.getSelectionRootShape());
        switch (this.gridShapeMode) {
            case 0: {
                break;
            }
            case 1: {
                log.fine("Adding grid shape!");
                this.shapeSet.merge(GridShapeTools.createUnitCellShape(this.getCell()));
                break;
            }
            case 2: {
                log.info("GRID_SHAPE_SECTION not yet implemented!");
            }
        }
        assert (this.shapeSet != null);
    }

    public void removeDuplicateSequences() {
        this.getGraph().removeDuplicateSequences();
        this.refresh(new ModelChangeEvent((Object)this, 4));
    }

    public void resetJunctionController(PdbJunctionControllerParameters parameters) {
        this.junctionController.reset(parameters);
    }

    public void setCell(double a, double b, double c, double alpha, double beta, double gamma) {
        this.cell.setA(a);
        this.cell.setB(b);
        this.cell.setC(c);
        this.cell.setAlpha(alpha);
        this.cell.setBeta(beta);
        this.cell.setGamma(gamma);
        this.modelChanged(new ModelChangeEvent(6));
    }

    public void setGridShapeMode(int mode) {
        this.gridShapeMode = mode;
        this.refresh(new ModelChangeEvent((Object)this, 5));
    }

    public void setImportStemLengthMin(int length) {
        this.importStemLengthMin = length;
    }

    public void setLastReadDirectory(String dir) {
        this.lastReadDirectory = dir;
    }

    public void setLatticeSection(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this.latticeSection.setXMin(xMin);
        this.latticeSection.setYMin(yMin);
        this.latticeSection.setZMin(zMin);
        this.latticeSection.setXMax(xMax);
        this.latticeSection.setYMax(yMax);
        this.latticeSection.setZMax(zMax);
        this.refresh(new ModelChangeEvent((Object)this, 5));
    }

    public void setSpaceGroup(int number) throws Object3DGraphControllerException {
        log.info("called setSpaceGroup with " + number);
        if (!this.spaceGroupFactory.isValid()) {
            this.initSpaceGroupFactory();
        }
        try {
            log.info("Generating space group from factory class...");
            SpaceGroup g = this.spaceGroupFactory.generate(number);
            log.info("The generated space group is: " + g.toString());
            this.setSpaceGroup(g);
        }
        catch (SymmetryException se) {
            throw new Object3DGraphControllerException(se.getMessage());
        }
    }

    public void setSpaceGroup(String name) throws Object3DGraphControllerException {
        if (!this.spaceGroupFactory.isValid()) {
            this.initSpaceGroupFactory();
        }
        try {
            SpaceGroup g = this.spaceGroupFactory.generate(name);
            this.setSpaceGroup(g);
        }
        catch (SymmetryException se) {
            throw new Object3DGraphControllerException(se.getMessage());
        }
        this.spaceGroupSymmetryCount = SymmetryTools.computeSpaceGroupSymmetryCount(this.spaceGroup);
    }

    public void setSpaceGroup(String name, String conventionName) throws Object3DGraphControllerException {
        if (!this.spaceGroupFactory.isValid()) {
            this.initSpaceGroupFactory();
        }
        try {
            this.setSpaceGroup(this.spaceGroupFactory.generate(name, conventionName));
        }
        catch (SymmetryException se) {
            throw new Object3DGraphControllerException(se.getMessage());
        }
    }

    private void setSpaceGroup(SpaceGroup spaceGroup) throws Object3DGraphControllerException {
        this.spaceGroup = spaceGroup;
        this.spaceGroupSymmetryCount = SymmetryTools.computeSpaceGroupSymmetryCount(spaceGroup);
        log.info("Space group symmetry count was set to: " + this.spaceGroupSymmetryCount);
        this.setSymmetryMode(this.symmetryMode);
    }

    public void setSymmetryMode(int mode) throws Object3DGraphControllerException {
        this.symmetryMode = mode;
        switch (mode) {
            case 0: {
                this.kaleidoscope = new DummyKaleidoscope();
                break;
            }
            case 1: {
                this.kaleidoscope = new CellKaleidoscope(this.cell, this.latticeSection);
                break;
            }
            case 2: {
                this.kaleidoscope = new SymmetryKaleidoscope(this.spaceGroup, this.cell, this.latticeSection);
                break;
            }
            default: {
                assert (false);
                log.severe("Unknown symmetry view mode!");
            }
        }
        assert (this.kaleidoscope != null);
        this.refresh(new ModelChangeEvent((Object)this, 5));
    }

    public void tileSpace(int xmin, int ymin, int zmin, int xmax, int ymax, int zmax, String name) {
        log.severe("Sorry, tileSpace not yet implemented!");
        DefaultLatticeTiler tiler = new DefaultLatticeTiler();
        Object3DLinkSetBundle result = tiler.generateTiling(new SimpleObject3DLinkSetBundle(this.graph.getSelectionRoot(), this.links), new DefaultLattice(this.cell, this.spaceGroup), this.latticeSection, name);
        this.graph.addGraph(result.getObject3D());
        log.warning("Sorry, no cloning of links implemented yet!");
    }

    private void updateFragmentGridTiler() {
        this.fgTiler.setStrandJunctionDB(this.junctionController.getJunctionDB());
        this.fgTiler.setKissingLoopDB(this.junctionController.getKissingLoopDB());
        this.fgTiler.setNucleotideDB(this.nucleotideDB);
    }

    public void write(OutputStream os, Object3DWriter writer) {
        this.graph.write(os, writer);
        writer.write(os, this.links);
    }

    public void write(OutputStream os, Object3DWriter writer, String[] subtreeNames) throws Object3DGraphControllerException {
        if (subtreeNames == null || subtreeNames.length == 0) {
            this.write(os, writer);
        } else {
            for (String subtree : subtreeNames) {
                Object3D tree = this.graph.findByFullName(subtree);
                if (tree == null) {
                    throw new Object3DGraphControllerException("Error in write method: Could not find object with name " + subtree);
                }
                writer.write(os, tree);
            }
            writer.write(os, this.links);
        }
    }

    public void writeJunctionsToPdb(String fileNameBase, boolean originalMode) {
        Object3DSet junctions = Object3DTools.collectByClassName(this.graph.getGraph(), "StrandJunction3D");
        String currFileName = "";
        for (int i = 0; i < junctions.size(); ++i) {
            StrandJunction3D junction = (StrandJunction3D)junctions.get(i);
            String pdbOutput = StrandJunctionTools.toPdb(junction, originalMode);
            try {
                currFileName = fileNameBase + "." + (i + 1);
                FileOutputStream fos = new FileOutputStream(currFileName);
                PrintStream ps = new PrintStream(fos);
                ps.println(pdbOutput);
                fos.close();
                continue;
            }
            catch (IOException iox) {
                log.warning("could not write to " + currFileName);
            }
        }
    }

    public void writePdbSymmetric(String fileName) throws Object3DGraphControllerException {
        SymmetryTools.writePdbSymmetric(fileName, this.graph.getGraph(), this.generateSymgenCommands(this.getSpaceGroupSymmetryCount()));
    }

    public void writeSecondaryStructure(OutputStream os, int format) throws Object3DGraphControllerException {
        MutableSecondaryStructure secStruct = null;
        try {
            secStruct = this.generateSecondaryStructure();
        }
        catch (DuplicateNameException e) {
            throw new Object3DGraphControllerException(e.getMessage());
        }
        assert (secStruct != null);
        log.fine("Writing secondary structure with: " + secStruct.getSequenceCount() + " sequences and " + secStruct.getInteractionCount() + " base pair interactions." + secStruct.toString());
        SecondaryStructureWriter secWriter = null;
        switch (format) {
            case 13: {
                secWriter = new SecondaryStructureScriptFormatWriter();
                break;
            }
            case 14: {
                secWriter = new SecondaryStructureCTFormatWriter();
                break;
            }
            case 15: {
                secWriter = new SecondaryStructureFastaFormatWriter();
                break;
            }
            case 16: {
                secWriter = new SecondaryStructureServerFormatWriter();
                break;
            }
            default: {
                throw new Object3DGraphControllerException("Unknown output format id!");
            }
        }
        assert (secWriter != null);
        PrintStream ps = new PrintStream(os);
        ps.println(secWriter.writeString(secStruct));
    }

    public void addMissingLinks() {
        Object3D root = this.getGraph().getGraph();
        this.addMissingLinks(root, this.links);
    }

    public void addMissingLinks(Object3D obj, LinkController linkSet) {
        SimpleLinkController tempSet = new SimpleLinkController();
        if (obj instanceof NucleotideStrand) {
            NucleotideStrand nucStrand = (NucleotideStrand)obj;
            for (int k = 0; k < nucStrand.getResidueCount(); ++k) {
                Nucleotide3D nuc1 = (Nucleotide3D)nucStrand.getResidue3D(k);
                tempSet.addLinks(NucleotideTools.getCovalentAtomLinks(nuc1));
            }
            for (int f = 0; f < tempSet.size(); ++f) {
                if (!linkSet.contains(tempSet.get(f))) continue;
                tempSet.remove(tempSet.get(f));
                --f;
            }
            linkSet.addLinks(tempSet);
        }
        if (obj instanceof Residue3D || obj instanceof Atom3D) {
            return;
        }
        for (int i = 0; i < obj.size(); ++i) {
            this.addMissingLinks(obj.getChild(i), this.links);
        }
    }
}

