/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import generaltools.ConstraintDouble;
import generaltools.StringTools;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import rnadesign.rnacontrol.LinkController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnacontrol.PackageConstants;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.HelixConstraintLink;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.JunctionDBConstraintLink;
import rnadesign.rnamodel.JunctionMultiConstraintLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.SimpleHelixConstraintLink;
import rnadesign.rnamodel.StrandJunctionDB;
import rnasecondary.Interaction;
import rnasecondary.InteractionSet;
import rnasecondary.InteractionType;
import rnasecondary.RnaInteractionType;
import rnasecondary.SimpleInteractionSet;
import tools3d.objects3d.AngleLink;
import tools3d.objects3d.ConstraintLink;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.MultiConstraintLink;
import tools3d.objects3d.MultiLink;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DCollector;
import tools3d.objects3d.Object3DIOException;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleConstraintLink;
import tools3d.objects3d.SimpleLink;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleTorsionLink;
import tools3d.objects3d.TorsionLink;

public class SimpleLinkController
implements LinkController {
    protected static Logger log = Logger.getLogger("NanoTiler_debug");
    protected List<Link> links = new ArrayList<Link>();
    private List<ModelChangeListener> listeners = new ArrayList<ModelChangeListener>();
    protected InteractionSet residueInteractions = new SimpleInteractionSet();
    public InteractionType defaultInteraction = new RnaInteractionType();

    public SimpleLinkController() {
    }

    public SimpleLinkController(LinkSet linkSet) {
        this();
        this.merge(linkSet);
    }

    @Override
    public LinkSet cloneDeep() {
        assert (false);
        return new SimpleLinkSet();
    }

    @Override
    public LinkSet cloneDeep(Object3D root) {
        assert (false);
        return new SimpleLinkSet();
    }

    @Override
    public HelixConstraintLink addHelixConstraintLink(Object3D obj1, Object3D obj2, int basePairMin, int basePairMax, double rms, int symId1, int symId2, String name) throws Object3DGraphControllerException {
        if (!(obj1 instanceof BranchDescriptor3D)) {
            throw new Object3DGraphControllerException("Object " + obj1.getName() + " has to be a BranchDescriptor3D !");
        }
        if (!(obj2 instanceof BranchDescriptor3D)) {
            throw new Object3DGraphControllerException("Object " + obj2.getName() + " has to be a BranchDescriptor3D !");
        }
        SimpleHelixConstraintLink link = new SimpleHelixConstraintLink((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2, basePairMin, basePairMax, rms);
        link.setName(name);
        link.setSymId1(symId1);
        link.setSymId2(symId2);
        this.add(link);
        return link;
    }

    @Override
    public ConstraintLink addDistanceConstraintLink(Object3D obj1, Object3D obj2, double min, double max, int symId1, int symId2) {
        SimpleConstraintLink link = new SimpleConstraintLink(obj1, obj2, min, max, symId1, symId2);
        this.add(link);
        return link;
    }

    @Override
    public TorsionLink addTorsionConstraintLink(Object3D obj1, Object3D obj2, Object3D obj3, Object3D obj4, double min, double max) {
        SimpleTorsionLink link = new SimpleTorsionLink(obj1, obj2, obj3, obj4, min, max);
        this.add(link);
        return link;
    }

    @Override
    public MultiConstraintLink addJunctionMultiConstraintLink(String name, List<Nucleotide3D> fivePrimeResidues, List<Nucleotide3D> threePrimeResidues, ConstraintDouble constraint, ConstraintDouble bridgableConstraint, List<Integer> symIds) throws RnaModelException {
        if (symIds != null && symIds.size() != 0 && symIds.size() != fivePrimeResidues.size()) {
            log.info("Number of symmetry operatotions and 5' residues for this junction: " + symIds.size() + " " + fivePrimeResidues.size());
            throw new RnaModelException("Number of symmetry ids does not match number of branches of junction!");
        }
        JunctionMultiConstraintLink link = new JunctionMultiConstraintLink(fivePrimeResidues, threePrimeResidues, constraint, bridgableConstraint);
        link.setName(name);
        if (symIds != null) {
            for (int i = 0; i < symIds.size(); ++i) {
                link.setSymId(i, symIds.get(i));
            }
        }
        this.add(link);
        return link;
    }

    @Override
    public JunctionDBConstraintLink addJunctionDBConstraintLink(String name, List<BranchDescriptor3D> branches, StrandJunctionDB junctionDB) throws RnaModelException {
        log.info("Added junctionDBConstraint link of size " + branches.size());
        JunctionDBConstraintLink link = new JunctionDBConstraintLink(branches, junctionDB);
        link.setName(name);
        this.add(link);
        return link;
    }

    private void addNoChange(Link link) {
        if (link instanceof InteractionLink) {
            this.residueInteractions.add(((InteractionLink)link).getInteraction());
            log.finest("Added link is interaction link: " + link.getObj1().getName() + " " + link.getObj2().getName());
        } else {
            log.finest("Added link is not interaction link: " + link.getObj1().getName() + " " + link.getObj2().getName());
        }
        this.links.add(link);
    }

    @Override
    public void add(Link link) {
        this.addNoChange(link);
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public void addLinks(LinkSet newLinks) {
        if (newLinks == null) {
            log.warning("LinkSet was null.");
            return;
        }
        for (int i = 0; i < newLinks.size(); ++i) {
            this.addNoChange(newLinks.get(i));
        }
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public LinkSet cloneLinks(Object3D origTree, Object3D clonedTree) throws Object3DGraphControllerException {
        if (origTree.size() != clonedTree.size()) {
            throw new Object3DGraphControllerException("Links between trees cannot be cloned, because they have a different number of links.");
        }
        SimpleLinkSet result = new SimpleLinkSet();
        Object3D root = Object3DTools.findRoot(clonedTree);
        String indexNameOrigRoot = Object3DTools.getFullIndexName(origTree);
        String indexNameClonedRoot = Object3DTools.getFullIndexName(clonedTree);
        for (int i = 0; i < this.size(); ++i) {
            Link link = this.get(i);
            if (link instanceof MultiLink) {
                log.info("Warning: not cloning Multi-Link: " + ((Object)link).toString());
                continue;
            }
            Object3D obj1 = link.getObj1();
            Object3D obj2 = link.getObj2();
            if (!Object3DTools.isAncestor(origTree, obj1) || !Object3DTools.isAncestor(origTree, obj2)) continue;
            String indexName1 = Object3DTools.getFullIndexName(obj1);
            String indexName2 = Object3DTools.getFullIndexName(obj2);
            String indexName1b = indexName1.replaceFirst(indexNameOrigRoot, indexNameClonedRoot);
            String indexName2b = indexName2.replaceFirst(indexNameOrigRoot, indexNameClonedRoot);
            indexName1 = indexName1b;
            indexName2 = indexName2b;
            Object3D obj1Clone = Object3DTools.findByFullName(root, indexName1);
            Object3D obj2Clone = Object3DTools.findByFullName(root, indexName2);
            if (obj1Clone == null) {
                throw new Object3DGraphControllerException("SimpleLinkController: Could not find object 1 with name " + indexName1);
            }
            if (obj2Clone == null) {
                throw new Object3DGraphControllerException("SimpleLinkController: Could not find object 2 with name " + indexName2);
            }
            Link clonedLink = (Link)link.clone(obj1Clone, obj2Clone);
            result.add(clonedLink);
        }
        return result;
    }

    @Override
    public int getLinkOrder(Object3D obj) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).linkOrder(obj);
        }
        return result;
    }

    @Override
    public LinkSet findLinks(Object3D obj) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).linkOrder(obj) <= 0) continue;
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public LinkSet findLinks(String name) {
        SimpleLinkSet result = new SimpleLinkSet();
        if (name == null) {
            return result;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!name.equals(this.get(i).getName())) continue;
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public int getLinkRank(Object3D obj, Link link) {
        LinkSet links = this.findLinks(obj);
        for (int i = 0; i < links.size(); ++i) {
            if (links.get(i) != link) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void merge(LinkSet newLinks) {
        this.addLinks(newLinks);
    }

    @Override
    public void addLink(Object3D o1, Object3D o2) {
        this.add(new SimpleLink(o1, o2));
    }

    @Override
    public void addModelChangeListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public InteractionSet getResidueInteractions() {
        return this.residueInteractions;
    }

    @Override
    public InteractionSet getHydrogenBondInteractions() {
        log.fine("Warning: calling slow method: collecting hydrogen bond interactions, starting with " + this.residueInteractions.size() + " interactions.");
        SimpleInteractionSet result = new SimpleInteractionSet();
        for (int i = 0; i < this.residueInteractions.size(); ++i) {
            Interaction interaction = this.residueInteractions.get(i);
            InteractionType interactionType = interaction.getInteractionType();
            if (!(interactionType instanceof RnaInteractionType) || interactionType.getSubTypeId() == 6) continue;
            result.add(interaction);
        }
        return result;
    }

    @Override
    public int getLinkNumber(Object3D obj1, Object3D obj2) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isLinked(obj1, obj2)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void removeAndAdd(Object3D objectTree, Object3DSet vertexSet) {
        assert (false);
    }

    @Override
    public void replaceObjectInLinks(Object3D oldObject, Object3D newObject) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).replaceObjectInLink(oldObject, newObject);
        }
    }

    @Override
    public void clear() {
        this.links.clear();
        this.residueInteractions.clear();
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public Link get(int n) throws IndexOutOfBoundsException {
        return this.links.get(n);
    }

    @Override
    public int size() {
        return this.links.size();
    }

    @Override
    public boolean contains(Link link) {
        for (int i = 0; i < this.links.size(); ++i) {
            if (!link.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Link find(Object3D obj1, Object3D obj2) {
        SimpleLink testLink = new SimpleLink(obj1, obj2);
        for (int i = 0; i < this.links.size(); ++i) {
            if (!((Object)testLink).equals(this.get(i))) continue;
            return this.get(i);
        }
        return null;
    }

    @Override
    public LinkSet findLinks(Object3D obj1, Object3D obj2) {
        SimpleLinkSet result = new SimpleLinkSet();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isLinked(obj1, obj2)) continue;
            result.add(this.get(i));
        }
        return result;
    }

    @Override
    public void remove(Link link) {
        if (link instanceof InteractionLink) {
            this.residueInteractions.remove(((InteractionLink)link).getInteraction());
        }
        this.links.remove(link);
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public void remove(LinkSet otherLinks) {
        for (int i = 0; i < otherLinks.size(); ++i) {
            Link link = otherLinks.get(i);
            if (link instanceof InteractionLink) {
                this.residueInteractions.remove(((InteractionLink)link).getInteraction());
            }
            this.links.remove(link);
        }
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public void remove(int linkId) throws Object3DGraphControllerException {
        if (linkId < 0 || linkId >= this.size()) {
            throw new Object3DGraphControllerException("Undefined link id: " + linkId);
        }
        Link link = this.get(linkId);
        this.remove(link);
    }

    @Override
    public int remove(String linkName) {
        assert (linkName != null && linkName.length() > 0);
        LinkSet rmLinks = this.findLinks(linkName);
        assert (rmLinks != null);
        for (int i = 0; i < rmLinks.size(); ++i) {
            this.remove(rmLinks.get(i));
        }
        return rmLinks.size();
    }

    @Override
    public void removeBadLinks(Object3D tree) {
        if (tree == null) {
            this.links = new ArrayList<Link>();
            return;
        }
        Object3DCollector collector = Object3DCollector.collectAll(tree);
        for (int i = this.size() - 1; i >= 0; --i) {
            Link link = this.get(i);
            if (collector.contains(link.getObj1()) && collector.contains(link.getObj2())) continue;
            this.links.remove(link);
        }
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public String toString() {
        String result = "(LinkSet " + this.size() + " ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + ((Object)this.get(i)).toString() + " ";
        }
        result = result + ")";
        return result;
    }

    private String generatePrettyStringLine(int n) {
        String result = "Link " + Object3DTools.getFullName(this.get(n).getObj1()) + " " + Object3DTools.getFullName(this.get(n).getObj2());
        if (this.get(n) instanceof InteractionLink) {
            InteractionLink link = (InteractionLink)this.get(n);
            result = result + " " + link.getInteraction().getInteractionType().toString();
        } else if (this.get(n) instanceof HelixConstraintLink) {
            HelixConstraintLink hcl = (HelixConstraintLink)this.get(n);
            result = result + " helix-constraint bpmin=" + hcl.getBasePairMin() + " bpmax=" + hcl.getBasePairMax() + " rms=" + hcl.getRms() + " name=" + hcl.getName();
        } else {
            result = this.get(n) instanceof AngleLink ? result + " " + ((Object)this.get(n)).toString() : (this.get(n) instanceof TorsionLink ? result + " " + ((Object)this.get(n)).toString() : (this.get(n) instanceof JunctionMultiConstraintLink ? ((Object)this.get(n)).toString() : result + " weird: " + ((Object)this.get(n)).toString()));
        }
        return result;
    }

    @Override
    public String toPrettyString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LinkCount " + this.size() + PackageConstants.NEWLINE);
        for (int i = 0; i < this.size(); ++i) {
            buf.append("" + (i + 1) + " " + this.generatePrettyStringLine(i) + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    @Override
    public String toPrettyString(String linkType) {
        log.info("Starting toPrettyString(" + linkType + ")");
        if (linkType == null || linkType.length() == 0) {
            return this.toPrettyString();
        }
        RnaInteractionType interactionType = null;
        if (linkType.equals("bp")) {
            interactionType = new RnaInteractionType(1);
        } else if (linkType.equals("backbone")) {
            interactionType = new RnaInteractionType(6);
        } else {
            return this.toPrettyString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("LinkCount " + this.size() + PackageConstants.NEWLINE);
        for (int i = 0; i < this.size(); ++i) {
            InteractionLink intLink;
            InteractionType otherType;
            Link link = this.get(i);
            if (!(link instanceof InteractionLink) || !interactionType.equals(otherType = (intLink = (InteractionLink)link).getInteraction().getInteractionType())) continue;
            buf.append("" + (i + 1) + " " + this.generatePrettyStringLine(i) + PackageConstants.NEWLINE);
        }
        log.info("Finished toPrettyString(" + linkType + ")");
        return buf.toString();
    }

    @Override
    public void read(InputStream is, Object3D tree) throws Object3DIOException {
        log.fine("Starting SimpleLinkController: read");
        StringTools st = new StringTools();
        String expected = "(LinkSet";
        DataInputStream dis = new DataInputStream(is);
        String word = StringTools.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("LinkSet.read: " + expected + " excepted instead of " + word);
        }
        word = StringTools.readWord(dis);
        int numLinks = 0;
        try {
            numLinks = Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw new Object3DIOException("createObject3DGraph: Could not parse number of children: " + word);
        }
        for (int i = 0; i < numLinks; ++i) {
            log.fine("Current size: " + this.size() + " reading: " + i);
            SimpleLink link = new SimpleLink();
            link.read(dis, tree);
            this.add(link);
        }
        expected = ")";
        word = StringTools.readWord(dis);
        if (!word.equals(expected)) {
            throw new Object3DIOException("createObject3D: " + expected + " excepted instead of " + word);
        }
        this.fireModelChanged(new ModelChangeEvent(this));
    }

    @Override
    public void fireModelChanged(ModelChangeEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ModelChangeListener listener = this.listeners.get(i);
            listener.modelChanged(event);
        }
    }
}

